/**
***************************************************************************
* @file dlrGeometry/ray3D.cpp
*
* Source file defining the Ray3D class.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 885 $
* $Date: 2007-05-04 01:01:15 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#include <dlrGeometry/ray3D.h>
#include <dlrNumeric/utilities.h>

namespace dnum = dlr::numeric;

namespace dlr {

  namespace geometry {
    
    // This constructor initializes the ray using a point and a
    // direction vector.
    Ray3D::
    Ray3D(const Vector3D& point,
          const Vector3D& direction,
          bool normalize)
      : m_origin(point),
        m_direction(direction)
    {
      if(normalize) {
        m_direction /= dnum::magnitude(m_direction);
      }
    }

    
    // The copy constructor deep copies its argument.
    Ray3D::
    Ray3D(const Ray3D& source)
      : m_origin(source.m_origin),
        m_direction(source.m_direction)
    {
      // Empty.
    }


    // The assignment operator deep copies its argument.
    Ray3D&
    Ray3D::
    operator=(const Ray3D& source)
    {
      if(&source != this) {
        m_origin = source.m_origin;
        m_direction = source.m_direction;
      }
      return *this;
    }


    /* ======= Non-member functions. ======= */

    std::ostream&
    operator<<(std::ostream& stream, const Ray3D& ray)
    {
      stream << "Ray3D{ "
             << ray.getOrigin() << ", "
             << ray.getDirectionVector() << " }";
      return stream;
    }
    
  } // namespace geometry
    
} // namespace dlr
