/**
***************************************************************************
* @file dlrGeometry/circle2D.h
*
* Source file defining the Circle2D class.
*
* Copyright (C) 2008 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 885 $
* $Date: 2007-05-04 01:01:15 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#include <dlrGeometry/circle2D.h>

namespace dlr {

  namespace geometry {
    
    /* ======= Non-member functions. ======= */

    std::ostream&
    operator<<(std::ostream& stream, const Circle2D& circle)
    {
      stream << "Circle2D{ "
             << circle.getOrigin() << ", "
             << circle.getRadius() << " }";
      return stream;
    }
    
  } // namespace geometry
    
} // namespace dlr
