dnl
dnl DLR_HAVE_DLRLINEARALGEBRA()
dnl
dnl Call this autoconf macro to check whether the dlrCommon library
dnl development files are installed on your system.

AC_DEFUN([DLR_HAVE_DLRLINEARALGEBRA],
    [DLR_SAVED_CPPFLAGS="${CPPFLAGS}"
     CPPFLAGS="${CPPFLAGS} -I${includedir} -I${prefix}/include"
     AC_CHECK_HEADER(dlrLinearAlgebra/linearAlgebra.h, 
         [],
         [AC_MSG_ERROR([Unable to find dlrLinearAlgebra/linearAlgebra.h.  
              Please check that the dlrLinearAlgebra utility library is 
              installed.  If it is, and this test still fails, try 
              modifying the CPPFLAGS environment variable so that the 
              compiler can more easily find this include file.  Please see 
              ./config.log for details of the failure.])])
     AC_MSG_CHECKING([for -ldlrLinearAlgebra])
     DLR_SAVED_LDFLAGS="${LDFLAGS}"
     DLR_SAVED_LIBS="${LIBS}"
     LDFLAGS="${LDFLAGS} -L${libdir} -L${prefix}/lib"
     LIBS="-ldlrLinearAlgebra -ldlrNumeric -ldlrPortability -ldlrCommon ${LAPACK_LIBS} ${BLAS_LIBS} ${DLR_SAVED_LIBS} ${FLIBS}"
     AC_TRY_LINK([#include <dlrLinearAlgebra/linearAlgebra.h>],
         [dlr::linearAlgebra::determinant(dlr::numeric::Array2D<dlr::Float64>());],
         [AC_MSG_RESULT([yes])],
         [AC_MSG_ERROR([Unable to build a test program against 
          libdlrLinearAlgebra.  Please check that the dlrLinearAlgebra utility 
          library is installed.  If it is, and this test still fails, try 
          modifying the LDFLAGS environment variable so that the compiler 
          can more easily find this library.  Please see ./config.log for 
          details of the failure.])])
     LIBS="${DLR_SAVED_LIBS}"
     LDFLAGS="${DLR_SAVED_LDFLAGS}"
     CPPFLAGS="${DLR_SAVED_CPPFLAGS}"])
