/**
***************************************************************************
* @file dlrComputerVision/imageIO.h
*
* Header file declaring functions for reading and writing images.
*
* Copyright (C) 2005-2008 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 1091 $
* $Date: 2009-01-06 23:49:57 -0500 (Tue, 06 Jan 2009) $
***************************************************************************
*/

#ifndef DLR_COMPUTERVISION_IMAGEIO_H
#define DLR_COMPUTERVISION_IMAGEIO_H


#include <string>
#include <dlrComputerVision/image.h>

namespace dlr {

  namespace computerVision {

#if 0  /* Here's the interface I think we ultimately want. */
    
    class ImageReader {
    public:
      
      /**
       * Constructor.
       */
      ImageReader();
      
      
      /**
       * Destructor.
       */
      virtual
      ~ImageReader();


      void
      readFile(std::string const& fileName);


      ImageFormat
      getNativeFormat();


      template<ImageFormat format>
      Image<format>
      getImage() {return Image<format>();}
      
    private:

      bool
      readPGM(std::string const& fileName);

      bool
      readPNG(std::string const& fileName);

      bool
      readPPM(std::string const& fileName);
      
    };

#endif

    /* ================ Non-member function declarations. ================ */
  
    Image<GRAY8>
    readPGM8(const std::string& fileName);

  
    Image<GRAY8>
    readPGM8(const std::string& fileName,
             std::string& commentString);

  
    Image<GRAY16>
    readPGM16(const std::string& fileName);

  
    Image<RGB8>
    readPPM8(const std::string& fileName);


    Image<RGB8>
    readPPM8(const std::string& fileName,
             std::string& commentString);
    
  
    void
    writePGM8(const std::string& fileName,
              const Image<GRAY8>& outputImage,
              const std::string& comment = "");
  
  
    void
    writePGM16(const std::string& fileName,
               const Image<GRAY16>& outputImage,
               const std::string& comment = "");
  

    void
    writePPM8(const std::string& fileName,
              const Image<RGB8>& outputImage,
              const std::string& comment = "");

#ifndef HAVE_LIBPNG
#define HAVE_LIBPNG 1
#endif
    
#if HAVE_LIBPNG

    /** 
     * WARNING: This routine may not stick around for long.
     * 
     * @param fileName This argument ...
     * 
     * @param commentString This argument ...
     * 
     * @return The return value ...
     */
    Image<GRAY8>
    readPNG8(const std::string& fileName,
             std::string& commentString);


    /** 
     * WARNING: This routine may not stick around for long.
     * 
     * @param fileName This argument ...
     * 
     * @param outputImage This argument ...
     * 
     * @param comment This argument ...
     */
    void
    writePNG8(const std::string& fileName,
              const Image<GRAY8>& outputImage,
              const std::string& comment = "");

#endif /* #if HAVE_LIBPNG */

    
  } // namespace computerVision

} // namespace dlr


#endif /* #ifndef DLR_COMPUTERVISION_IMAGEIO_H */
