/**
***************************************************************************
* @file erodeTest.cpp
*
* Source file defining tests for erode().
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#include <dlrComputerVision/test/testImages.h>
#include <dlrComputerVision/erode.h>
#include <dlrComputerVision/imageIO.h>
#include <dlrTest/testFixture.h>

namespace dlr {

  namespace computerVision {
    
    class ErodeTest
      : public TestFixture<ErodeTest> {

    public:

      ErodeTest();
      ~ErodeTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      // Tests.
      void testErode();

    private:

      template<ImageFormat FORMAT>
      Image<FORMAT>
      naiveErode(const Image<FORMAT>& inputImage);
      
    }; // class ErodeTest


    /* ============== Member Function Definititions ============== */

    ErodeTest::
    ErodeTest()
      : TestFixture<ErodeTest>("ErodeTest")
    {
      DLR_TEST_REGISTER_MEMBER(testErode);
    }


    void
    ErodeTest::
    testErode()
    {
      Image<GRAY8> inputImage = readPGM8(getDilateErodeFileNamePGM0());
      Image<GRAY8> referenceImage = readPGM8(getErodedFileNamePGM0());
      Image<GRAY8> erodedImage = erode<GRAY8>(inputImage);
      DLR_TEST_ASSERT(erodedImage.rows() == referenceImage.rows());
      DLR_TEST_ASSERT(erodedImage.columns() == referenceImage.columns());
      for(size_t index0 = 0; index0 < inputImage.size(); ++index0) {
        DLR_TEST_ASSERT(erodedImage[index0] == referenceImage[index0]);
      }
    }


    template<ImageFormat FORMAT>
    Image<FORMAT>
    ErodeTest::
    naiveErode(const Image<FORMAT>& inputImage)
    {
      typedef typename Image<FORMAT>::value_type ValueType;
    
      Image<FORMAT> outputImage(inputImage.rows(), inputImage.columns());

      size_t index0 = 0;
      size_t row = 0;
      size_t rowBoundary0 = 1;
      size_t rowBoundary1 = inputImage.rows() - 1;
      for(; row < rowBoundary0; ++row) {
        for(size_t column = 0; column < inputImage.columns(); ++column) {
          outputImage[index0] = ValueType(0);
          ++index0;
        }
      }


      size_t colBoundary0 = 1;
      size_t colBoundary1 = inputImage.columns() - 1;
      for(; row < rowBoundary1; ++row) {
        size_t column = 0;
        for(; column < colBoundary0; ++column) {
          outputImage[index0] = ValueType(0);
          ++index0;
        }        
        for(; column < colBoundary1; ++column) {
          if(inputImage[index0 - 1]
             && inputImage[index0 + 1]
             && inputImage[index0 - inputImage.columns() - 1]
             && inputImage[index0 - inputImage.columns()]
             && inputImage[index0 - inputImage.columns() + 1]
             && inputImage[index0 + inputImage.columns() - 1]
             && inputImage[index0 + inputImage.columns()]
             && inputImage[index0 + inputImage.columns() + 1]) {
            outputImage[index0] = inputImage[index0];
          } else {
            outputImage[index0] = ValueType(0);
          }
          ++index0;
        }
        for(; column < inputImage.columns(); ++column) {
          outputImage[index0] = ValueType(0);
          ++index0;
        }
      }

      for(; row < inputImage.rows(); ++row) {
        for(size_t column = 0; column < inputImage.columns(); ++column) {
          outputImage[index0] = ValueType(0);
          ++index0;
        }
      }      

      return outputImage;
    }


  } // namespace computerVision

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::computerVision::ErodeTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::computerVision::ErodeTest currentTest;

}

#endif

