/**
***************************************************************************
* @file dlrComputerVision/stereoRectify.h
*
* Header file declaring code to compute image rectification parameters
* for stereo image pairs.
*
* Copyright (C) 2009 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
*/

#ifndef _DLRCOMPUTERVISION_STEREORECTIFY_H_
#define _DLRCOMPUTERVISION_STEREORECTIFY_H_

#include <dlrComputerVision/cameraIntrinsicsPinhole.h>
#include <dlrNumeric/transform2D.h>
#include <dlrNumeric/transform3D.h>

namespace dlr {

  namespace computerVision {

    /**
     * A. Fusiello, E. Trucco, and A. Verri. A compact algorithm for
     * rectification of stereo pairs. Machine Vision and Applications,
     * 2000.
     *
     * ... Our convention is that, from the perspective of rectified
     * camera0, rectified camera1 is located to the right (in the
     * positive X direction).
     *
     * Warning: this routine assumes, but does not check, that the
     * camera?Tworld arguments are euclidean rigid body
     * transformations.  That is, the routine assumes that the 3x3
     * upper left block of each camera?Tworld argument is orthonormal,
     * and the last row is [0, 0, 0, 1].
     * 
     * @param intrinsics0 This argument 
     * 
     * @param intrinsics1 This argument 
     * 
     * @param camera0Tworld This argument 
     * 
     * @param camera1Tworld This argument 
     * 
     * @param rectifiedIntrinsics0 This argument 
     * 
     * @param rectifiedIntrinsics1 This argument 
     * 
     * @param image0Trimage0 This argument 
     * 
     * @param image1Trimage1 This argument 
     * 
     * @param rcamera0Tworld This argument 
     * 
     * @param rcamera1Tworld This argument 
     * 
     * @return The return value 
     */
    void
    stereoRectify(CameraIntrinsicsPinhole const& intrinsics0,
                  CameraIntrinsicsPinhole const& intrinsics1,
                  numeric::Transform3D const& camera0Tworld,
                  numeric::Transform3D const& camera1Tworld,
                  CameraIntrinsicsPinhole& rectifiedIntrinsics0,
                  CameraIntrinsicsPinhole& rectifiedIntrinsics1,
                  numeric::Transform3D& rcamera0Tworld,
                  numeric::Transform3D& rcamera1Tworld,
                  numeric::Transform2D& image0Trimage0,
                  numeric::Transform2D& image1Trimage1);
            

  } // namespace computerVision

} // namespace dlr


// /* =============== Implementation follows =============== */


#endif /* #ifndef _DLRCOMPUTERVISION_KERNEL_H_ */
