/**
***************************************************************************
* @file dlrComputerVision/imageFormatTraits.h
*
* Header file declaring ImageFormatTraits classes.
*
* Copyright (C) 2005-2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 1179 $
* $Date: 2009-07-28 00:04:21 -0400 (Tue, 28 Jul 2009) $
***************************************************************************
*/

#ifndef _DLRCOMPUTERVISION_IMAGEFORMATTRAITS_H_
#define _DLRCOMPUTERVISION_IMAGEFORMATTRAITS_H_

#include <stdlib.h>
#include <dlrCommon/types.h>
#include <dlrComputerVision/imageFormat.h>
#include <dlrComputerVision/pixelBGRA.h>
#include <dlrComputerVision/pixelHSV.h>
#include <dlrComputerVision/pixelRGB.h>
#include <dlrComputerVision/pixelRGBA.h>
#include <dlrComputerVision/pixelYIQ.h>

namespace dlr {

  namespace computerVision {
  
    /**
     ** The ImageFormatTraits class template specifies the
     ** characteristics of the available image formats.  Currently it
     ** specifies only the base type used to represent pixels.
     **/
    template <ImageFormat>
    class ImageFormatTraits {
    public:
      typedef UnsignedInt8 PixelType;
      typedef UnsignedInt8 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };


    template<>
    class ImageFormatTraits<GRAY1> {
    public:
      typedef bool PixelType;
      typedef bool ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<GRAY8> {
    public:
      typedef UnsignedInt8 PixelType;
      typedef UnsignedInt8 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<GRAY16> {
    public:
      typedef UnsignedInt16 PixelType;
      typedef UnsignedInt16 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<GRAY32> {
    public:
      typedef UnsignedInt32 PixelType;
      typedef UnsignedInt32 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<GRAY64> {
    public:
      typedef UnsignedInt64 PixelType;
      typedef UnsignedInt64 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<GRAY_SIGNED16> {
    public:
      typedef Int16 PixelType;
      typedef Int16 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<GRAY_SIGNED32> {
    public:
      typedef Int32 PixelType;
      typedef Int32 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<GRAY_FLOAT32> {
    public:
      typedef Float32 PixelType;
      typedef Float32 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<GRAY_FLOAT64> {
    public:
      typedef Float64 PixelType;
      typedef Float64 ComponentType;
      static size_t getNumberOfComponents() {return 1;}
    };
    

    template<>
    class ImageFormatTraits<RGB8> {
    public:
      typedef PixelRGB8 PixelType;
      typedef UnsignedInt8 ComponentType;
      static size_t getNumberOfComponents() {return 3;}
    };
    

    template<>
    class ImageFormatTraits<RGB16> {
    public:
      typedef PixelRGB16 PixelType;
      typedef UnsignedInt16 ComponentType;
      static size_t getNumberOfComponents() {return 3;}
    };


    template<>
    class ImageFormatTraits<RGB_SIGNED16> {
    public:
      typedef PixelRGBSigned16 PixelType;
      typedef Int16 ComponentType;
      static size_t getNumberOfComponents() {return 3;}
    };

  
    template<>
    class ImageFormatTraits<RGB_SIGNED32> {
    public:
      typedef PixelRGBSigned32 PixelType;
      typedef Int32 ComponentType;
      static size_t getNumberOfComponents() {return 3;}
    };

  
    template<>
    class ImageFormatTraits<RGB_FLOAT32> {
    public:
      typedef PixelRGBFloat32 PixelType;
      typedef Float32 ComponentType;
      static size_t getNumberOfComponents() {return 3;}
    };


    template<>
    class ImageFormatTraits<RGB_FLOAT64> {
    public:
      typedef PixelRGBFloat64 PixelType;
      typedef Float64 ComponentType;
      static size_t getNumberOfComponents() {return 3;}
    };


    template<>
    class ImageFormatTraits<HSV_FLOAT64> {
    public:
      typedef PixelHSVFloat64 PixelType;
      typedef Float64 ComponentType;
      static size_t getNumberOfComponents() {return 3;}
    };
  
  
    template<>
    class ImageFormatTraits<YIQ_FLOAT64> {
    public:
      typedef PixelYIQFloat64 PixelType;
      typedef Float64 ComponentType;
      static size_t getNumberOfComponents() {return 3;}
    };
  
  
    template<>
    class ImageFormatTraits<RGBA8> {
    public:
      typedef PixelRGBA8 PixelType;
      typedef UnsignedInt8 ComponentType;
      static size_t getNumberOfComponents() {return 4;}
    };
    

    template<>
    class ImageFormatTraits<BGRA8> {
    public:
      typedef PixelBGRA8 PixelType;
      typedef UnsignedInt8 ComponentType;
      static size_t getNumberOfComponents() {return 4;}
    };
    
  } // namespace computerVision

} // namespace dlr

#endif /* ifndef _DLRCOMPUTERVISION_IMAGEFORMATTRAITS_H_ */
