/**
***************************************************************************
* @file dlrComputerVision/imageFormat.h
*
* Header file declaring ImageFormat enum.
*
* Copyright (C) 2005-2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 1179 $
* $Date: 2009-07-28 00:04:21 -0400 (Tue, 28 Jul 2009) $
***************************************************************************
*/

#ifndef _DLRCOMPUTERVISION_IMAGEFORMAT_H_
#define _DLRCOMPUTERVISION_IMAGEFORMAT_H_

namespace dlr {

  namespace computerVision {
  
    /**
     ** This enum indicates the acceptable image format values.  Please
     ** see the ImageFormatTraits class template for the characteristics
     ** of these image formats.
     **/
    enum ImageFormat {
      GRAY1,
      GRAY8,
      GRAY16,
      GRAY32,
      GRAY64,
      GRAY_SIGNED16,
      GRAY_SIGNED32,
      GRAY_FLOAT32,
      GRAY_FLOAT64,
      RGB8,
      RGB16,
      RGB_SIGNED16,
      RGB_SIGNED32,
      RGB_FLOAT32,
      RGB_FLOAT64,
      HSV_FLOAT64,
      YIQ_FLOAT64,
      BGRA8,
      RGBA8,
      YUV420
    };

  } // namespace computerVision
    
} // namespace dlr

#endif /* #ifndef _DLRCOMPUTERVISION_IMAGEFORMAT_H_ */
