/**
***************************************************************************
* @file segmenterFelzenszwalbTest.cpp
*
* Source file defining tests for routines defined in
* dlrComputerVision/segmenterFelzenszwalb.h.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#include <dlrComputerVision/test/testImages.h>
#include <dlrComputerVision/segmenterFelzenszwalb.h>
#include <dlrComputerVision/imageIO.h>
#include <dlrComputerVision/utilities.h>
#include <dlrTest/testFixture.h>


using namespace dlr::computerVision;

namespace dlr {

  class SegmenterFelzenszwalbTest
    : public TestFixture<SegmenterFelzenszwalbTest> {

  public:

    SegmenterFelzenszwalbTest();
    ~SegmenterFelzenszwalbTest() {}

    void setUp(const std::string& testName) {}
    void tearDown(const std::string& testName) {}

    // Tests.
    void testSegmenterFelzenszwalb();

  private:

  }; // class SegmenterFelzenszwalbTest


  /* ============== Member Function Definititions ============== */

  SegmenterFelzenszwalbTest::
  SegmenterFelzenszwalbTest()
    : TestFixture<SegmenterFelzenszwalbTest>("SegmenterFelzenszwalbTest")
  {
    DLR_TEST_REGISTER_MEMBER(testSegmenterFelzenszwalb);
  }


  void
  SegmenterFelzenszwalbTest::
  testSegmenterFelzenszwalb()
  {
    SegmenterFelzenszwalb segmenter(200, 0.8, 20);
    Image<GRAY8> inputImage0 = readPGM8(getTestImageFileNamePGM0());
    segmenter.segment(inputImage0);
    Array2D<UnsignedInt32> labelArray = segmenter.getLabelArray();
    Array2D<UnsignedInt16> labelImage(labelArray.rows(), labelArray.columns());
    labelImage.copy(labelArray);
    writePGM16("foo.pgm", labelImage);
  }

} // namespace dlr

#if 0

int main(int argc, char** argv)
{
  dlr::SegmenterFelzenszwalbTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::SegmenterFelzenszwalbTest currentTest;
  
}

#endif
