/**
***************************************************************************
* @file dlrComputerVision/histogramEqualize.h
*
* Header file declaring histogram equalization routines.
*
* Copyright (C) 2005 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 975 $
* $Date: 2007-12-30 01:57:17 -0500 (Sun, 30 Dec 2007) $
***************************************************************************
*/

#ifndef _DLRCOMPUTERVISION_HISTOGRAMEQUALIZE_H_
#define _DLRCOMPUTERVISION_HISTOGRAMEQUALIZE_H_

#include <dlrComputerVision/image.h>


namespace dlr {

  namespace computerVision {
    
    /** 
     * This function computes the histogram of an image.  That is, it
     * counts the number of pixels with each possible value and returns
     * a 1D array of counts.
     * 
     * @param inputImage This argument is the image to be histogrammed.
     * 
     * @return The return value is a 1D array in which the first element
     * indicates the number of pixels having the value 0, the second
     * element indicates the number of pixels having the value 1, and so
     * forth.
     */
    Array1D<unsigned int>
    getHistogram(const Image<GRAY8>& inputImage);
  

    /** 
     * This function remaps the pixel values of the input image in such
     * a way that output pixel value increases monotonically with input
     * pixel value, and the histogram of the output image is nearly
     * flat.
     * 
     * @param inputImage This argument is the image to be equalized.
     * 
     * @return The return value is the histogram equalized image.
     */
    Image<GRAY8>
    histogramEqualize(const Image<GRAY8>& inputImage);

  } // namespace computerVision

} // namespace dlr


#endif /* #ifndef _DLRCOMPUTERVISION_HISTOGRAMEQUALIZE_H_ */
