/**
***************************************************************************
* @file cannyTest.cpp
*
* Source file defining tests for routines defined in
* dlrComputerVision/canny.h.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#include <dlrComputerVision/test/testImages.h>
#include <dlrComputerVision/canny.h>
#include <dlrComputerVision/imageIO.h>
#include <dlrComputerVision/utilities.h>
#include <dlrTest/testFixture.h>


using namespace dlr::computerVision;

namespace dlr {

  class CannyTest
    : public TestFixture<CannyTest> {

  public:

    CannyTest();
    ~CannyTest() {}

    void setUp(const std::string& testName) {}
    void tearDown(const std::string& testName) {}

    // Tests.
    void testCanny();

  private:

  }; // class CannyTest


  /* ============== Member Function Definititions ============== */

  CannyTest::
  CannyTest()
    : TestFixture<CannyTest>("CannyTest")
  {
    DLR_TEST_REGISTER_MEMBER(testCanny);
  }


  void
  CannyTest::
  testCanny()
  {
    Image<GRAY8> inputImage0 = readPGM8(getTestImageFileNamePGM0());
    Image<GRAY8> referenceImage = readPGM8(getEdgeImageFileNamePGM0());
    Image<GRAY1> binaryImage = applyCanny(inputImage0, 5, 5.0, 1.0);
    Image<GRAY8> edgeImage = convertColorspace<GRAY8>(binaryImage);

    DLR_TEST_ASSERT(edgeImage.rows() == referenceImage.rows());
    DLR_TEST_ASSERT(edgeImage.columns() == referenceImage.columns());
    for(size_t index0 = 0; index0 < edgeImage.size(); ++index0) {
      DLR_TEST_ASSERT(edgeImage[index0] == referenceImage[index0]);
    }
  }

} // namespace dlr

#if 0

int main(int argc, char** argv)
{
  dlr::CannyTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::CannyTest currentTest;
  
}

#endif
