/**
***************************************************************************
* @file dlrComputerVision/dilate.h
*
* Header file declaring the dilate() function template.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
*/

#ifndef _DLRCOMPUTERVISION_DILATE_H_
#define _DLRCOMPUTERVISION_DILATE_H_

#include <dlrComputerVision/image.h>

namespace dlr {

  namespace computerVision {
    
    template<ImageFormat FORMAT>
    Image<FORMAT>
    dilate(const Image<FORMAT>& inputImage);

  } // namespace computerVision
    
} // namespace dlr


/* ============ Definitions of inline & template functions ============ */


#include <cmath>

namespace dlr {

  namespace computerVision {
  
    template<ImageFormat FORMAT>
    Image<FORMAT>
    dilate(const Image<FORMAT>& inputImage)
    {
      typedef typename Image<FORMAT>::value_type ValueType;
    
      Image<FORMAT> outputImage(inputImage.rows(), inputImage.columns());

      size_t index0 = 0;
      if(inputImage[0]
         || inputImage[1]
         || inputImage[inputImage.columns()]
         || inputImage[inputImage.columns() + 1]) {
        outputImage[index0] = ValueType(1);
      } else {
        outputImage[index0] = ValueType(0);
      }
      ++index0;

      for(size_t column = 1; column < inputImage.columns() - 1; ++column) {
        if(inputImage[index0]
           || inputImage[index0 - 1]
           || inputImage[index0 + 1]
           || inputImage[index0 + inputImage.columns() - 1]
           || inputImage[index0 + inputImage.columns()]
           || inputImage[index0 + inputImage.columns() + 1]) {
          outputImage[index0] = ValueType(1);
        } else {
          outputImage[index0] = ValueType(0);
        }
        ++index0;
      }
        
      if(inputImage[index0]
         || inputImage[index0 - 1]
         || inputImage[index0 + inputImage.columns() - 1]
         || inputImage[index0 + inputImage.columns()]) {
        outputImage[index0] = ValueType(1);
      } else {
        outputImage[index0] = ValueType(0);
      }
      ++index0;

      for(size_t row = 1; row < inputImage.rows() - 1; ++row) {
        if(inputImage[index0]
           || inputImage[index0 + 1]
           || inputImage[index0 - inputImage.columns()]
           || inputImage[index0 - inputImage.columns() + 1]
           || inputImage[index0 + inputImage.columns()]
           || inputImage[index0 + inputImage.columns() + 1]) {
          outputImage[index0] = ValueType(1);
        } else {
          outputImage[index0] = ValueType(0);
        }
        ++index0;

        for(size_t column = 1; column < inputImage.columns() - 1; ++column) {
          if(inputImage[index0]
             || inputImage[index0 - 1]
             || inputImage[index0 + 1]
             || inputImage[index0 - inputImage.columns() - 1]
             || inputImage[index0 - inputImage.columns()]
             || inputImage[index0 - inputImage.columns() + 1]
             || inputImage[index0 + inputImage.columns() - 1]
             || inputImage[index0 + inputImage.columns()]
             || inputImage[index0 + inputImage.columns() + 1]) {
            outputImage[index0] = ValueType(1);
          } else {
            outputImage[index0] = ValueType(0);
          }
          ++index0;
        }

        if(inputImage[index0]
           || inputImage[index0 - 1]
           || inputImage[index0 - inputImage.columns()]
           || inputImage[index0 - inputImage.columns() - 1]
           || inputImage[index0 + inputImage.columns()]
           || inputImage[index0 + inputImage.columns() - 1]) {
          outputImage[index0] = ValueType(1);
        } else {
          outputImage[index0] = ValueType(0);
        }
        ++index0;
      }

      if(inputImage[index0]
         || inputImage[index0 + 1]
         || inputImage[index0 - inputImage.columns()]
         || inputImage[index0 - inputImage.columns() + 1]) {
        outputImage[index0] = ValueType(1);
      } else {
        outputImage[index0] = ValueType(0);
      }
      ++index0;

      for(size_t column = 1; column < inputImage.columns() - 1; ++column) {
        if(inputImage[index0]
           || inputImage[index0 - 1]
           || inputImage[index0 + 1]
           || inputImage[index0 - inputImage.columns() - 1]
           || inputImage[index0 - inputImage.columns()]
           || inputImage[index0 - inputImage.columns() + 1]) {
          outputImage[index0] = ValueType(1);
        } else {
          outputImage[index0] = ValueType(0);
        }
        ++index0;
      }
        
      if(inputImage[index0]
         || inputImage[index0 - 1]
         || inputImage[index0 - inputImage.columns() - 1]
         || inputImage[index0 - inputImage.columns()]) {
        outputImage[index0] = ValueType(1);
      } else {
        outputImage[index0] = ValueType(0);
      }
      ++index0;

      return outputImage;
    }

  } // namespace computerVision
    
} // namespace dlr

#endif /* #ifndef _DLRCOMPUTERVISION_DILATE_H_ */
