/**
***************************************************************************
* @file dlrCommon/tags.h
*
* Header file declaring largely superfluous tag types.
*
* Copyright (C) 2000-2007, David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 975 $
* $Date: 2007-12-30 01:57:17 -0500 (Sun, 30 Dec 2007) $
***************************************************************************
**/

#ifndef _DLR_COMMON_TAGS_H_
#define _DLR_COMMON_TAGS_H_

#include <cstdlib>

namespace dlr {

  namespace common {

    /**
     ** @deprecated {Largely replaced by explicit template specialization
     ** and by the typedefs in dlrCommon/types.h}
     **
     ** Largely superfluous class for representing an arbitrary type.
     ** Sometimes we need write a template without a meaningful
     ** argument of the templated type.  The class type_tag<> was
     ** introduced to make it easy to do this.  Example:
     **
     **   Array2D<double> A = identity(4, type_tag<double>());
     **
     ** or
     **
     **   const type_tag<double> Double;
     **   Array2D<double> A = identity(4, Double);
     **
     ** Note that it's generally just as good to write the template
     ** argument explicitly, like this:
     **
     **   int myInt = convertString<int>(myString);
     **
     ** We are moving away from the use of the type_tag template.
     **/
    template <class Type> class type_tag {};

    // Now some convenient instances of these tags.

    /// @deprecated {Largely replaced by explicit template specialization
    /// and by the typedefs in dlrCommon/types.h}
    ///
    /// Predefined type_tag for convenience.  
    extern type_tag<char> Char;

    /// @deprecated {Largely replaced by explicit template specialization
    /// and by the typedefs in dlrCommon/types.h}
    ///
    /// Predefined type_tag for convenience.
    extern type_tag<double> Double;

    /// @deprecated {Largely replaced by explicit template specialization
    /// and by the typedefs in dlrCommon/types.h}
    ///
    /// Predefined type_tag for convenience.
    extern type_tag<float> Float;

    /// @deprecated {Largely replaced by explicit template specialization
    /// and by the typedefs in dlrCommon/types.h}
    ///
    /// Predefined type_tag for convenience.
    extern type_tag<int> Int;

    /// @deprecated {Largely replaced by explicit template specialization
    /// and by the typedefs in dlrCommon/types.h}
    ///
    /// Predefined type_tag for convenience.
    extern type_tag<short> Short;

    /// @deprecated {Largely replaced by explicit template specialization
    /// and by the typedefs in dlrCommon/types.h}
    ///
    /// Predefined type_tag for convenience.
    extern type_tag<size_t> SizeT;

    /// @deprecated {Largely replaced by explicit template specialization
    /// and by the typedefs in dlrCommon/types.h}
    ///
    /// Predefined type_tag for convenience.  
    extern type_tag<unsigned char> UnsignedChar;

    /// @deprecated {Largely replaced by explicit template specialization
    /// and by the typedefs in dlrCommon/types.h}
    ///
    /// Predefined type_tag for convenience.  
    extern type_tag<unsigned short> UnsignedShort;

  } // namespace common
  
}  // namespace dlr


/* ======= Declarations to maintain compatibility with legacy code. ======= */

namespace dlr {

  using common::type_tag;
  using common::Char;
  using common::Double;
  using common::Float;
  using common::Int;
  using common::Short;
  using common::SizeT;
  using common::UnsignedChar;
  using common::UnsignedShort;
  
} // namespace dlr

#endif // #ifndef _DLR_COMMON_TAGS_H_
