/**
***************************************************************************
* @file dlrCommon/typePromoter.h
*
* Header file declaring TypePromoter template.
*
* Copyright (C) 2009, David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#ifndef DLR_COMMON_TYPEPROMOTER_H
#define DLR_COMMON_TYPEPROMOTER_H

#include <dlrCommon/types.h>

namespace dlr {

  namespace common {
    
    /**
     ** This class is used to customize the behavior of dlr_libs
     ** classes & functions for specific types so that arithmetic
     ** operations on elements of different types can anticipate the
     ** type promotions applied by the compiler.
     **/
    template <class Type0, class Type1>
    struct TypePromoter {
      /* ==================== Public typedefs to be ==================== */
      /* ==================== provided by specializations ============== */
      /* ==================== of this template ========================= */

      // /**
      //  * This typedef reflects the type resulting from arithmetic
      //  * operations on combinations of Type0 and Type1.b
      //  */
      // typedef Type0 ResultType;
    };

        
    // Specializations for <Int8, Type>

    template <>
    struct TypePromoter<Int8, Int8> {
      typedef Int8 ResultType;
    };

    template <>
    struct TypePromoter<Int8, Int16> {
      typedef Int16 ResultType;
    };

    template <>
    struct TypePromoter<Int8, Int32> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int8, Int64> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int8, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Int8, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Int8, UnsignedInt8> {
      typedef Int8 ResultType;
    };

    template <>
    struct TypePromoter<Int8, UnsignedInt16> {
      typedef UnsignedInt16 ResultType;
    };

    template <>
    struct TypePromoter<Int8, UnsignedInt32> {
      typedef UnsignedInt32 ResultType;
    };

    template <>
    struct TypePromoter<Int8, UnsignedInt64> {
      typedef UnsignedInt64 ResultType;
    };


    // Specializations for <Int16, Type>
    
    template <>
    struct TypePromoter<Int16, Int8> {
      typedef Int16 ResultType;
    };

    template <>
    struct TypePromoter<Int16, Int16> {
      typedef Int16 ResultType;
    };

    template <>
    struct TypePromoter<Int16, Int32> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int16, Int64> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int16, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Int16, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Int16, UnsignedInt8> {
      typedef Int16 ResultType;
    };

    template <>
    struct TypePromoter<Int16, UnsignedInt16> {
      typedef Int16 ResultType;
    };

    template <>
    struct TypePromoter<Int16, UnsignedInt32> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int16, UnsignedInt64> {
      typedef UnsignedInt64 ResultType;
    };

    // Specializations for <Int32, Type>
    
    template <>
    struct TypePromoter<Int32, Int8> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int32, Int16> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int32, Int32> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int32, Int64> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int32, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Int32, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Int32, UnsignedInt8> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int32, UnsignedInt16> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int32, UnsignedInt32> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<Int32, UnsignedInt64> {
      typedef UnsignedInt64 ResultType;
    };

    // Specializations for <Int64, Type>
    
    template <>
    struct TypePromoter<Int64, Int8> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int64, Int16> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int64, Int32> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int64, Int64> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int64, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Int64, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Int64, UnsignedInt8> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int64, UnsignedInt16> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int64, UnsignedInt32> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<Int64, UnsignedInt64> {
      typedef Int64 ResultType;
    };

    // Specializations for <Float32, Type>
    
    template <>
    struct TypePromoter<Float32, Int8> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Float32, Int16> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Float32, Int32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Float32, Int64> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Float32, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Float32, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float32, UnsignedInt8> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Float32, UnsignedInt16> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Float32, UnsignedInt32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<Float32, UnsignedInt64> {
      typedef Float32 ResultType;
    };

    // Specializations for <Float64, Type>
    
    template <>
    struct TypePromoter<Float64, Int8> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, Int16> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, Int32> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, Int64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, Float32> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, UnsignedInt8> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, UnsignedInt16> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, UnsignedInt32> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<Float64, UnsignedInt64> {
      typedef Float64 ResultType;
    };

    // Specializations for <UnsignedInt8, Type>

    template <>
    struct TypePromoter<UnsignedInt8, Int8> {
      typedef Int8 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, Int16> {
      typedef Int16 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, Int32> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, Int64> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, UnsignedInt8> {
      typedef UnsignedInt8 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, UnsignedInt16> {
      typedef UnsignedInt16 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, UnsignedInt32> {
      typedef UnsignedInt32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt8, UnsignedInt64> {
      typedef UnsignedInt64 ResultType;
    };


    // Specializations for <UnsignedInt16, Type>

    template <>
    struct TypePromoter<UnsignedInt16, Int8> {
      typedef UnsignedInt16 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, Int16> {
      typedef Int16 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, Int32> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, Int64> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, UnsignedInt8> {
      typedef UnsignedInt16 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, UnsignedInt16> {
      typedef UnsignedInt16 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, UnsignedInt32> {
      typedef UnsignedInt32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt16, UnsignedInt64> {
      typedef UnsignedInt64 ResultType;
    };


    // Specializations for <UnsignedInt32, Type>

    template <>
    struct TypePromoter<UnsignedInt32, Int8> {
      typedef UnsignedInt32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, Int16> {
      typedef UnsignedInt32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, Int32> {
      typedef Int32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, Int64> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, UnsignedInt8> {
      typedef UnsignedInt32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, UnsignedInt16> {
      typedef UnsignedInt32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, UnsignedInt32> {
      typedef UnsignedInt32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt32, UnsignedInt64> {
      typedef UnsignedInt64 ResultType;
    };


    // Specializations for <UnsignedInt64, Type>

    template <>
    struct TypePromoter<UnsignedInt64, Int8> {
      typedef UnsignedInt64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, Int16> {
      typedef UnsignedInt64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, Int32> {
      typedef UnsignedInt64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, Int64> {
      typedef Int64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, Float32> {
      typedef Float32 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, Float64> {
      typedef Float64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, UnsignedInt8> {
      typedef UnsignedInt64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, UnsignedInt16> {
      typedef UnsignedInt64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, UnsignedInt32> {
      typedef UnsignedInt64 ResultType;
    };

    template <>
    struct TypePromoter<UnsignedInt64, UnsignedInt64> {
      typedef UnsignedInt64 ResultType;
    };


  } // namespace 

} // namespace dlr

#endif /* #ifndef DLR_COMMON_TYPEPROMOTER_H */
