/**
***************************************************************************
* @file dlrCommon/constants.h
*
* Header file declaring useful physical constants.
*
* Copyright (C) 2009 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#ifndef DLR_COMMON_CONSTANTS_H
#define DLR_COMMON_CONSTANTS_H

namespace dlr {

  namespace common {
    
    namespace constants {

      // Basic physical constants.
      const double e = 2.7182818284590451;
      const double pi = 3.141592653589793238;

      // Empirical constants.
      const double avogadro = 6.02214179E23;

      // Constants that derive from the basic ones.
      const double degreesPerRadian = 180.0 / pi;
      const double radiansPerDegree = pi / 180.0;

    } // nameapace contants

  } // namespace common

} // namespace dlr

#endif /* #ifndef DLR_COMMON_CONSTANTS_H */
