package email.utils;



import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingConstants;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Toolbox {
	public static Node getChildByName(Node n, String s) {
		n = n.getFirstChild();
		while (n != null && !n.getNodeName().equals(s))
			n = n.getNextSibling();
		return n;
	}

	public static Node getSiblingByName(Node n, String s) {
		n = n.getNextSibling();
		while (n != null && !n.getNodeName().equals(s))
			n = n.getNextSibling();
		return n;
	}

	public static Node[] getChildrenByName(Node n, String s) {
		Vector bag = new Vector();
		n = getChildByName(n, s);
		while (n != null) {
			bag.add(n);
			n = getSiblingByName(n, s);
		}

		Node nodes[] = new Node[bag.size()];
		bag.toArray((Object[]) nodes);
		return nodes;
	}

	public static String getTextContent(Node n) {
		StringBuffer buf = new StringBuffer();
		n = n.getFirstChild();
		while (n != null) {
			if (n.getNodeType() == Node.TEXT_NODE)
				buf.append(n.getNodeValue());
			n = n.getNextSibling();
		}

		return buf.toString();
	}

	public static void setTextContent(Node n, String s) {
		while (n.getFirstChild() != null)
			n.removeChild(n.getFirstChild());
		Document doc = n.getOwnerDocument();
		n.appendChild(doc.createTextNode(s));
	}

	public static JPanel makeVerticalList(Component oldC[],
			boolean areComponentsSources, int colWidth) {
		JPanel p = new JPanel();
		SpringLayout layout = new SpringLayout();
		p.setLayout(layout);

		Component[] c;
		if (!areComponentsSources) { // add a divider after the 4th element -
										// changed
			c = oldC;
			
		} else {
			/*
			 * c = new Component[oldC.length]; int i; for(i=0;i < 4 && i <
			 * oldC.length; i++){ c[i] = oldC[i]; } for(; i<oldC.length; i++ ){
			 * c[i] = oldC[i]; }
			 */
			c = oldC;
		}

		for (int i = 0; i < c.length; i++) {
			p.add(c[i]);
			layout.putConstraint(SpringLayout.EAST, c[i], 0, SpringLayout.EAST,
					p);
			layout.putConstraint(SpringLayout.WEST, c[i], 0, SpringLayout.WEST,
					p);
			if (i == 0)
				layout.putConstraint(SpringLayout.NORTH, p, 0,
						SpringLayout.NORTH, c[i]);
			else
				layout.putConstraint(SpringLayout.NORTH, c[i], 0,
						SpringLayout.SOUTH, c[i - 1]);

		}
		return p;
	}
	
	public static int getColWidth(JFrame frame)
	{
		int rootHeight=frame.getHeight();
		int rootWidth= frame.getWidth();
		int halfWidth = rootWidth / 2;
		int colWidth = halfWidth - 30;
		
		return colWidth;
	}
	
	public static int getColHeight(JFrame frame)
	{
		int rootHeight=frame.getHeight();
		return rootHeight;
	}
	
}
