package email.utils;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

import org.apache.log4j.Logger;

import email.database.DBConnection;


public class TemporaryMap
{
	static Logger logger=null;
	static
	{
		logger = Logger.getLogger(TemporaryMap.class);
	}
	
	public static void main(String[] args)
	{
		Properties props = getProperties("hard.disk.emails.properties");
		String outPath = props.getProperty("email.temp.map");
		String orgMapPath = props.getProperty("email.org.map");
		getTempMap(outPath,orgMapPath);
	}
	
	public static void getTempMap(String outPath, String orgMapPath)
	{
		DBConnection dbc = new DBConnection();
		ArrayList mapping = dbc.getMapping("temporary");
		dbc.closeConnection();
		int size = mapping.size();
		try {
			BufferedWriter bWriter = new BufferedWriter(new FileWriter(outPath));
			BufferedWriter bWriter2 = new BufferedWriter(new FileWriter(orgMapPath, true));
			for(int i = 0; i < size/2; i ++)
			{
				String keyword = (String)mapping.get(2*i);
				String replacement = (String)mapping.get(2*i+1);
				bWriter.write(replacement+"\t"+keyword+"\f");
				int ind = replacement.lastIndexOf("_");
				String revisedReplacement = replacement.substring(0,ind);
				bWriter2.write(revisedReplacement+"\t"+keyword+"\f\n");
			}
			bWriter.close();
			bWriter2.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	
	
	private static Properties getProperties(String propertiesFile)
	{
		Properties properties = new Properties();
		try {
	        properties.load(new FileInputStream(propertiesFile));
	    }
		catch (IOException e)
	    {
			logger.warn("Could not load properties file:"+propertiesFile,e);
			System.exit(0);
	    }			
		return properties;
	}
	
	
}