package email.utils;



import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

import org.apache.log4j.Logger;

public class SerializedObjects
{
	
	static Logger logger=null;
	
	static
	{
		logger = Logger.getLogger(SerializedObjects.class);
	}
	

	
	public static void writeSerializedObject(Object object, String outFile)
	{
		ObjectOutput output = null;
	    try{
	      //use buffering
	      OutputStream file = new FileOutputStream(outFile);
	      OutputStream buffer = new BufferedOutputStream( file );
	      output = new ObjectOutputStream( buffer );
	      output.writeObject(object);
	      buffer.close();
	      file.close();
	    }
	    catch(IOException ex){
	     logger.warn("Cannot perform output.", ex);
	    }
	    finally{
	      try {
	        if (output != null) {
	          //flush and close "output" and its underlying streams
	          output.close();
	        }
	      }
	      catch (IOException ex ){
	       logger.warn("Cannot close output stream.", ex);
	      }
	    }
	}
	
	public static Object readSerializedObject(String inputFile)
	{
		ObjectInput input = null;
	    Object recoveredObject=null;
		try{
	      //use buffering
	      InputStream file = new FileInputStream(inputFile);
	      InputStream buffer = new BufferedInputStream(file);
	      input = new ObjectInputStream(buffer);
	      //deserialize the List
	      recoveredObject = input.readObject();
	    }
	    catch(IOException ex){
	      logger.warn("Cannot perform input.", ex);
	    }
	    catch (ClassNotFoundException ex){
	      logger.warn("Unexpected class found upon input.", ex);
	    }
	    finally{
	      try {
	        if ( input != null ) {
	          //close "input" and its underlying streams
	          input.close();
	        }
	      }
	      catch (IOException ex){
	        logger.warn("Cannot close input stream.", ex);
	      }
	    }
	    return recoveredObject;
	 }
	
}