package email.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;

import email.anonymize.gui.revised.RevisedConstants;



public class RetagEmails
{
	static Logger logger=null;
	static
	{
		logger = Logger.getLogger(RetagEmails.class);
	}
	
	public static void main(String[] args)
	{
		Properties props = getProperties("hard.disk.emails.properties");
		String outDir = props.getProperty("email.output.path");
		String mapFile = props.getProperty("email.temp.to.new.map");
		HashMap<String, String> tempToNewMap = (HashMap<String, String>)SerializedObjects.readSerializedObject(mapFile);
		replaceTags(outDir, tempToNewMap);
		
	}
	
	private static void replaceTags(String outDir, HashMap<String,String> map)
	{
		FilenameFilter filter = new FilenameFilter(){

			public boolean accept(File arg0, String arg1) {
				// TODO Auto-generated method stub
				return arg1.endsWith("retag");
			}
			
		};
		
		File dir = new File(outDir);
		if(!dir.isDirectory())
		{
			logger.warn("Output path not a directory");
			System.exit(0);
		}
		String[] files = dir.list(filter);
		ArrayList<String> tempTags = new ArrayList<String>(map.keySet());
		ArrayList<String> newTags = new ArrayList<String>(map.values());
		int size = tempTags.size();
		for(int i = 0; i < files.length; i ++)
		{
			StringBuffer content = new StringBuffer("");
			try {
				BufferedReader bReader = new BufferedReader(new FileReader(dir.getAbsolutePath()+"\\"+files[i]));
				
				String line=null;
				while((line=bReader.readLine())!=null)
				{
					content.append(line+"\n");
				}
				bReader.close();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			String contentString = content.toString();
			for(int j = 0; j < size; j ++)
			{
				String old = tempTags.get(j);
				String newT = newTags.get(j);
				
				contentString = contentString.replace(old, newT);
			}
			String pattern = RevisedConstants.SUFFIX_EXPR_TWO;
			Pattern p = Pattern.compile(pattern);
			Matcher m = p.matcher(contentString);
			if(m.find())
			{
				logger.warn("Email:"+files[i]+" contains temp tags even now. Exiting code. i="+i);
				System.exit(0);
			}
			
			try
			{
				String newName = files[i].substring(0,files[i].length()-5)+"done";
				BufferedWriter bWriter = new BufferedWriter(new FileWriter(dir.getAbsolutePath()+"\\"+newName));
				bWriter.write(contentString);
				bWriter.close();
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			
			File retagFile = new File(dir.getAbsolutePath()+"\\"+files[i]);
			boolean res = retagFile.delete();
			if(!res)
			{
				System.out.println("Could not delete file:"+retagFile.getAbsolutePath());
			}
			
		}
	}
	
	
	private static Properties getProperties(String propertiesFile)
	{
		Properties properties = new Properties();
		try {
	        properties.load(new FileInputStream(propertiesFile));
	    }
		catch (IOException e)
	    {
			logger.warn("Could not load properties file:"+propertiesFile,e);
			System.exit(0);
	    }			
		return properties;
	}
}
