package email.utils;

import java.awt.BorderLayout;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

import org.apache.log4j.Logger;

import email.anonymize.gui.AnonConstants;




public class PrintBodies
{
	static Logger logger=null;
	static
	{
		logger = Logger.getLogger(PrintBodies.class);
	}
	
	public static void main(String[] args)
	{
		printBodies("F:\\fall2007\\research\\email summarization\\clean_up_separated_data\\dipanjan", "F:\\fall2007\\research\\email summarization\\clean_up_separated_data\\dipanjan_text");
	}
	
	public static void printBodies(String inputDir, String outputDir)
	{
		File dir = new File(inputDir);
		FilenameFilter filter = new FilenameFilter(){
			 public boolean accept(File dir, String name) {
			        return (name.endsWith(".eml"));
			    }
		};
				
		String[] mFileList=dir.list(filter);	
		File f = new File(outputDir);
		if(!f.isDirectory())
		{
			logger.warn("Given directory:"+outputDir+" is not a directory.");
			System.exit(0);
		}
		
		int len = mFileList.length;
		for(int i =0; i < len; i ++)
		{
			String fullPath=dir.getAbsolutePath()+"\\"+mFileList[i];
			FileInputStream inp=null;
			
			try
			{
				inp = new FileInputStream(fullPath);
			}
			catch (FileNotFoundException e) {
				logger.warn("Could not read file:"+fullPath,e);
				continue;
			}
			File emailF = new File(fullPath);
			String stringContent=null;
			try
			{
				stringContent=getFileContent(emailF);
			}
			catch(IOException e)
			{
				logger.warn("Could not read raw contents of file:"+fullPath, e);
				continue;			
			}
			
			Properties props = new Properties();
			Session session = Session.getDefaultInstance(props, null);
			MimeMessage m = null;
			try
			{
				m = new MimeMessage(session, inp);
				m.setFileName(fullPath);
			}
			catch (MessagingException e1)
			{
				logger.warn("Could not create MimeMessage for file:"+fullPath,e1);
				continue;	
			}
			
			String subject=null;
			String toFields=null;
			String fromField=null;
			Date date=null;
			String bodyText=null;
						
			StringBuffer mailBody = new StringBuffer("");

			try
			{
				Address[] aList=m.getFrom();
				fromField="";
				int addressLen=0;
				if(aList!=null)
				{
					addressLen=aList.length;
					for(int j = 0; j < addressLen; j++)
					{
						fromField+=aList[j].toString().trim()+", ";
					}
				}
				if(fromField.length()>2)
					fromField=fromField.substring(0, fromField.length()-2);
				
				mailBody.append("From:"+fromField+"\n");
								
				date = m.getSentDate();
				mailBody.append(date+"\n");
							
				
				toFields="";
				aList=m.getRecipients(Message.RecipientType.TO);
				if(aList!=null)
				{	
					addressLen=aList.length;		
					for(int j = 0; j < addressLen; j++)
					{
						toFields+=aList[j].toString().trim()+", ";
					}
				}
				if(toFields.length()>2)
					toFields=toFields.substring(0, toFields.length()-2).trim();
				mailBody.append("To:"+toFields+"\n");
								
				toFields="";
				aList=m.getRecipients(Message.RecipientType.CC);
				if(aList!=null)
				{	
					addressLen=aList.length;		
					for(int j = 0; j < addressLen; j++)
					{
						toFields+=aList[j].toString().trim()+", ";
					}
				}

				if(toFields.length()>2)
					toFields=toFields.substring(0, toFields.length()-2).trim();
				if(toFields.length()>0)
				{
					mailBody.append("Cc:"+toFields+"\n");
				}
				toFields="";
							
				aList=m.getRecipients(Message.RecipientType.BCC);
				if(aList!=null)
				{	
					addressLen=aList.length;		
					for(int j = 0; j < addressLen; j++)
					{
						toFields+=aList[j].toString().trim()+", ";
					}
				}			
				if(toFields.length()>2)
					toFields=toFields.substring(0, toFields.length()-2).trim();

				if(toFields.length()>0)
				{
					mailBody.append("Bcc:"+toFields+"\n");
				}
				toFields="";
				
				
				subject=m.getSubject();		
				mailBody.append("Subject:"+subject+"\n");
				
				bodyText=getBodyText(m, fullPath);
				mailBody.append("\n"+bodyText);
				
				String fileName = mFileList[i].substring(0, mFileList[i].length()-4);
				int lastIndexUS=fileName.lastIndexOf('_');
				String num = fileName.substring(lastIndexUS+1);
				
				if(num.length()==1)
					num="000"+num;
				else if(num.length()==2)
					num="00"+num;
				else if(num.length()==3)
					num="0"+num;
				else
					num=num;
				
				fileName=fileName.substring(0,lastIndexUS+1)+num+".txt";
				System.out.println(mFileList[i]+"\t"+fileName);
				BufferedWriter bWriter = new BufferedWriter(new FileWriter(outputDir+"\\"+fileName));
				bWriter.write(mailBody.toString());
				bWriter.close();
				
			}
			catch (MessagingException e)
			{
				logger.warn("Problem in getting email Field for file:"+fullPath, e);
				continue;	
			}
			catch(IOException e)
			{
				logger.warn("Problem writing file",e);
				continue;
			}
			try
			{
				inp.close();
			}
			catch(IOException e)
			{
				logger.warn("Problem in closing file:"+fullPath,e);
				continue;
			}
			
		}
				
	}
	
	public static String getFileContent(File f) throws IOException
	{
		FileInputStream fis = new FileInputStream(f);
		InputStreamReader irdr = new InputStreamReader(fis); // promote
		int size = (int) f.length(); // get the file size (in bytes)
		char[] data = new char[size]; // allocate char array of right size
		irdr.read( data, 0, size );   // read into char array
		irdr.close();
		String contents = new String(data);
		return contents;
	}
	public static String getBodyText(MimeMessage m, String fullPath)
	{
		Object o=null;
		try
		{
			o = m.getContent();
		}
		catch(UnsupportedEncodingException e) {
			logger.warn("Content not supported for file:"+fullPath, e);
			System.exit(0);
		} catch (IOException e) {
			logger.warn("IOException in getting body for file:"+fullPath, e);
			System.exit(0);
		} catch (MessagingException e) {
			logger.warn("MessagingException in getting body for file:"+fullPath, e);
			System.exit(0);
		}
		
		String body="";			
		
		if(o instanceof String)
		{
			body+=(String)o+" ";
		}
		else if(o instanceof Multipart)
		{
			body+=getStringFromMultiPart((Multipart)o)+" ";
		}
		
			
		return body; 
	}
	public static String getStringFromMultiPart(Multipart mp)
	{
		String result="";
		
		try {
			int count = mp.getCount();
			for(int i = 0; i < count; i ++)
			{
				BodyPart b;
				try
				{
					b = mp.getBodyPart(i);
				}
				catch(Exception e) {
					logger.warn("Body part not supported, continuing");
					continue;
				}
				String disposition = b.getDisposition();
				if((disposition!=null)&&disposition.equals(Part.ATTACHMENT))
				{
					continue;
				}			
				Object o;
				try
				{
					o = b.getContent();
				}
				catch(Exception e)
				{
					logger.warn("Body part not supported, continuing");
					continue;
				}
				if(o instanceof String)
				{
					result+=(String)o+" ";
				}
				else if(o instanceof Multipart)
				{
					result+=getStringFromMultiPart((Multipart)o);
				}
				
				return result;
			}
		} catch (MessagingException e) {
			logger.warn("Problem in extracting string from Multipart, returning null",e);
			logger.warn("\n\n\n");
			return "";
		} 
		return "";
	}
	
	
}