package email.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

import org.apache.log4j.Logger;



public class CreateTempToNewMap
{
	static Logger logger=null;
	static
	{
		logger = Logger.getLogger(CreateTempToNewMap.class);
	}
	
	public static void main(String[] args)
	{
		int len = args.length;
		if(len<1)
		{
			System.out.println("Please enter the first index in outmap that came from the temporary tags");
		}
		int index = new Integer(args[0]).intValue();
		Properties props = getProperties("hard.disk.emails.properties");
		String outPath = props.getProperty("email.temp.to.new.map");
		String tempPath = props.getProperty("email.temp.map");
		String mapPath = props.getProperty("email.input.map");
		createTempToNewMap(tempPath, mapPath, outPath, index);
	}
	
	private static void createTempToNewMap(String tempPath, String mapPath, String outPath, int index)
	{
		StringBuffer wholeMapContent = new StringBuffer("");
		StringBuffer tempMapContent = new StringBuffer("");
		try {
			BufferedReader bReader = new BufferedReader(new FileReader(mapPath));
			
			String line=null;
			while((line=bReader.readLine())!=null)
			{
				wholeMapContent.append(line+"\n");
			}
			bReader.close();
			
			bReader = new BufferedReader(new FileReader(tempPath));
			line=null;
			while((line=bReader.readLine())!=null)
			{
				tempMapContent.append(line+"\n");
			}
			bReader.close();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		HashMap<String, String> tempToNewMap = new HashMap<String, String>();
		
		StringTokenizer st1 = new StringTokenizer(wholeMapContent.toString(), "\f");
		StringTokenizer st2 = new StringTokenizer(tempMapContent.toString(), "\f");
		
		int count = st1.countTokens();
		System.out.println(count);
		System.out.println(st2.countTokens());
		for(int i = 1; i < index; i ++)
		{
			st1.nextToken();
		}		
		
		while(st2.hasMoreTokens())
		{
			String tempTok = st2.nextToken();
			StringTokenizer st3 = new StringTokenizer(tempTok, "\t");
			tempTok = st3.nextToken().trim();
			st3 = new StringTokenizer(st1.nextToken(), "\t");
			String newTok = st3.nextToken().trim();
			tempToNewMap.put(tempTok, newTok);
		}
		
		SerializedObjects.writeSerializedObject(tempToNewMap, outPath);
	}	

	private static Properties getProperties(String propertiesFile)
	{
		Properties properties = new Properties();
		try {
	        properties.load(new FileInputStream(propertiesFile));
	    }
		catch (IOException e)
	    {
			logger.warn("Could not load properties file:"+propertiesFile,e);
			System.exit(0);
	    }			
		return properties;
	}
	
	
}