package email.database;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

import org.apache.log4j.Logger;



public class DBConnection
{
	private Connection con;
	static Logger logger=null;
	static
	{
		logger=Logger.getLogger(DBConnection.class);
	}
	private long id;
		
	
	public DBConnection()
	{
		//Read properties file.
	    Properties properties = new Properties();
	    try {
	        properties.load(new FileInputStream("db.properties"));
	    } 
	    catch (IOException e) 
	    {
	    	logger.warn("Problem in reading db.properties.");
	    	System.exit(0);
	    }
	    String protocol=properties.getProperty("email.protocol", "jdbc:postgresql");
	    String host=properties.getProperty("email.host", "localhost");
	    String dbname=properties.getProperty("email.dbname");
	    String user=properties.getProperty("email.user", "postgres");
	    String password=properties.getProperty("email.password");
	    String url = protocol+"://"+host+"/"+dbname;
	    
	    try {
	        Class.forName("com.mysql.jdbc.Driver");
	      } catch (ClassNotFoundException cnfe) {
	        logger.warn("Couldn't find the driver!");
	        logger.warn("Let's print a stack trace, and exit.", cnfe);
	        System.exit(0);
	      }
	    
	      
	    logger.trace("Registered the driver ok, so let's make a connection.");
	      
	    try {
			con = DriverManager.getConnection(url,user, password);
		} catch (SQLException e) {
			logger.warn("Problem in getting connection to mysql database", e);
			System.exit(0);
		}
		id=0;	
	}
		
	
	public void deleteAll(String tableName)
	{
		try {
			  PreparedStatement pstmt = con.prepareStatement("DELETE FROM "+tableName); 
		      pstmt.executeUpdate();
		      pstmt.close();
		} 
		catch (SQLException e)
		{
			logger.warn("Could not delete values from database",e);
		}
	}
	
	
	public void closeConnection()
	{
		if(con!=null)
		{
			try {
				con.close();
			} catch (SQLException e) {
				logger.warn("Could not close connection");
			}
			logger.trace("Closed connection");
		}
	}	
	
	
	public long totalIds(String tableName)
	{
		long result = 0;
		try
		{
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM "+tableName);
			while(rs.next())
			{
				result = rs.getLong(1);
				break;
			}
		}
		catch(SQLException e)
		{
			logger.warn("Could not query database for COUNT(*)",e);
		}	
		return result;
	}
	
	
	public long maxIds(String tableName)
	{
		long result = 0;
		try
		{
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("SELECT MAX(id) FROM "+tableName);
			while(rs.next())
			{
				result = rs.getLong(1);
				break;
			}
		}
		catch(SQLException e)
		{
			logger.warn("Could not query database for MAX(*)",e);
		}	
		return result;
	}
	
	
	public ArrayList<String> getTemporaryMapping(String tableName)
	{
		ArrayList<String> mapping = new ArrayList<String>();
		
		try
		{
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("SELECT keyword, replacement FROM "+tableName);
			while(rs.next())
			{
				String keyword = rs.getString(1);
				String replacement = rs.getString(2);
				mapping.add(keyword);
				mapping.add(replacement);
			}
		}
		catch(SQLException e)
		{
			logger.warn("Could not query database for keyword,replacements",e);
		}
		
		
		
		return mapping;
		
	}
	
	
	
	
	
	public ArrayList getEntryForId(String tableName, long id)
	{
		ArrayList result = null;
		try
		{
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("SELECT keyword, replacement, type FROM "+tableName+" WHERE id="+id);
			while(rs.next())
			{
				String keyword = rs.getString(1);
				String replacement = rs.getString(2);
				int type = rs.getInt(3);
				result = new ArrayList();
				result.add(keyword);
				result.add(replacement);
				result.add(new Integer(type));
				break;
			}
		}
		catch(SQLException e)
		{
			logger.warn("Could not query database for COUNT(*)",e);
		}
		
		return result;
	}
	
	public String getMaxIndex(String tableName, int type)
	{
		String result = null;
		try
		{
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("SELECT replacement FROM "+tableName+" WHERE type="+type+" AND id = (SELECT MAX(id) from "+tableName+" where type="+type+")");
			while(rs.next())
			{
				String replacement = rs.getString(1);
				result = replacement;
				break;
			}
		}
		catch(SQLException e)
		{
			logger.warn("Could not query database for COUNT(*)",e);
		}
		return result;
		
	}
	
	public ArrayList getMapping(String tableName)
	{
		ArrayList result = new ArrayList();
		try
		{
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("SELECT keyword, replacement FROM "+tableName);
			while(rs.next())
			{
				String keyword = rs.getString(1);
				String replacement = rs.getString(2);
				if(keyword==null || replacement==null)
					continue;
				result.add(keyword);
				result.add(replacement);
			}
		}
		catch(SQLException e)
		{
			logger.warn("Could not query database for COUNT(*)",e);
		}
		
		return result;
	}
	
	
	
	public boolean insertReplacement(String tableName, String keyWord, String replacement, int type)
	{
		boolean result = true;
		try {
		      // serialize the String object into a byte array
		      long id = maxIds(tableName);
		      id+=1;
		      PreparedStatement pstmt = con.prepareStatement("INSERT INTO lookup VALUES(?,?,?,?)");
		      
		      pstmt.setString(1, keyWord);
		      pstmt.setString(2, replacement);
		      pstmt.setInt(3, type);
		      pstmt.setLong(4, id);
		      pstmt.executeUpdate();
		      pstmt.close();
		} 
		catch (SQLException e)
		{
			logger.warn("Could not insert values into database",e);
			return false;
		}
		return result;
			
	}
	
	public boolean insertReplacementTwo(String tableName, String keyWord, String replacement)
	{
		boolean result = true;
		try {
			  PreparedStatement pstmt = con.prepareStatement("INSERT INTO "+tableName+" VALUES(?,?)"); 
		      pstmt.setString(1, keyWord);
		      pstmt.setString(2, replacement);
		      pstmt.executeUpdate();
		      pstmt.close();
		} 
		catch (SQLException e)
		{
			logger.warn("Could not insert values into database",e);
			return false;
		}
		return result;
			
	}
	
	
	
	public ArrayList getApproximateMatchingEntries(String tableName, String token)
	{
		ArrayList result = new ArrayList();
		try
		{
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("SELECT keyword, replacement, type FROM "+tableName+" WHERE keyword like '"+token+"%' ORDER BY keyword DESC");
			while(rs.next())
			{
				String keyword = rs.getString(1);
				String replacement = rs.getString(2);
				int type = rs.getInt(3);
				result.add(keyword);
				result.add(replacement);
				result.add(new Integer(type));
			}
		}
		catch(SQLException e)
		{
			logger.warn("Could not query database for COUNT(*)",e);
		}
		
		return result;
	}
	
	
	public static void main(String[] args)
	{
		DBConnection dbc = new DBConnection();
		dbc.closeConnection();
	}
	
}