package email.anonymize.gui.revised;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

import org.apache.log4j.Logger;

import email.anonymize.gui.GUIConstants;
import email.anonymize.gui.Suggestion;
import email.anonymize.gui.revised.MyHighlightPainter;
import email.database.DBConnection;
import email.utils.Toolbox;


public class RevisedAnonPanel extends JPanel implements ActionListener, MouseListener
{
	static Logger logger=null;
	static
	{
		logger=Logger.getLogger(RevisedAnonPanel.class);
	}
	
	//global variables;
	File mEmailDirectory;
	File mOutputPath;
	ArrayList<String> mFileList;
	int mEmailIndex;
	JPanel mTopPane;
	RevisedAnonFrame mRootFrame;
	DBConnection mDbc;
	JTextField mWordToBeReplaced;
	JTextField mReplacedByWord;
	JButton mOkButton;
	JButton mSubmitButton;
	JButton mExamineButton;
	JButton mSkipButton;
	JRadioButton[] mTagTypes;
	JPanel mMiddlePane;
	JScrollPane mEmailScrollPane;
	JPanel mBottomPane;
	JButton mPreviousButton;
	JButton mNextButton;
	JButton mPrev10Button;
	JButton mNext10Button;
	JLabel mNumberLabel;
	JButton mGoTo;
	JTextField mEmailNum;
	JPanel mBottomButtonPane;
	JTextArea mEmailText;
	String mFileName;
	JButton mReTagButton;
	JButton mReplaceTagsButton;
	JButton mShowOriginal;
	boolean mSelectionActive;
	int mReplacementEndIndex;
	int mReplacementStartIndex;
	Map<String,String> mGlobalReplacementMap;
	Map<String,String> mTemporaryReplacementMap;
	ArrayList<Replacement> mGlobalReplacements;
	ArrayList<GrayReplacement> mGrayReplacements;
	OriginalFrame mOf;
	String[] mCommonWords;
	HashSet<String> mCommonTags;
	String[] mEntityTypes;
	
	
	Highlighter.HighlightPainter mMyHighlightPainter = new MyHighlightPainter(RevisedConstants.LIGHT_RED);	
	Highlighter.HighlightPainter mMyHighlightPainterTwo = new MyHighlightPainter(RevisedConstants.LIGHT_BLUE);
	Highlighter.HighlightPainter mMyHighlightPainterThree = new MyHighlightPainter(Color.LIGHT_GRAY);
	Highlighter.HighlightPainter mMyHighlightPainterFour = new MyHighlightPainter(RevisedConstants.LIGHT_GREEN);
		
	
	public RevisedAnonPanel(Properties props, DBConnection dbc,  RevisedAnonFrame rootFrame)
	{
		initializeData(props, dbc, rootFrame);	
		//top panel with the replacement words
		mTopPane = new JPanel();
		mTopPane.setLayout(new BorderLayout());
		
		JPanel mReplacementPane = new JPanel();
		mReplacementPane.setLayout(new FlowLayout());
		mRootFrame = rootFrame;
		mDbc = dbc;
				
		mWordToBeReplaced = new JTextField(25); 
		JLabel wordToBeReplacedLabel = new JLabel("Word to be Replaced");
		wordToBeReplacedLabel.setFont(new Font("Arial", Font.BOLD, 12));
		
		
		mReplacedByWord = new JTextField(25);
		JLabel replacedBy = new JLabel("Replace by");
		replacedBy.setFont(new Font("Arial", Font.BOLD, 12));
		mReplacementPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
		mReplacedByWord.addActionListener(this);
		
		mOkButton = new JButton("OK");
		mOkButton.setFont(new Font("Arial", Font.PLAIN, 12));
		mOkButton.addActionListener(this);
		mOkButton.setEnabled(false);
				
		
		mSubmitButton = new JButton("Mark Email as Done");
		mSubmitButton.setFont(new Font("Arial", Font.PLAIN, 12));
		mSubmitButton.addActionListener(this);
				
		mExamineButton = new JButton("Re-examine Later");
		mExamineButton.setFont(new Font("Arial", Font.PLAIN, 12));
		mExamineButton.addActionListener(this);
		
		mReplaceTagsButton = new JButton("Mark Done, but Temporarily");
		mReplaceTagsButton.setFont(new Font("Arial", Font.PLAIN, 12));
		mReplaceTagsButton.addActionListener(this);
		
		mShowOriginal = new JButton("Show Original");
		mShowOriginal.setFont(new Font("Arial", Font.PLAIN, 12));
		mShowOriginal.addActionListener(this);
		
		
		
		mSkipButton = new JButton("Skip");
		mSkipButton.setFont(new Font("Arial", Font.PLAIN, 12));
		mSkipButton.addActionListener(this);
		
		mReTagButton = new JButton("Retag Email");
		mReTagButton.setFont(new Font("Arial", Font.PLAIN, 12));
		mReTagButton.addActionListener(this);
		
		
		ButtonGroup bg = new ButtonGroup();
		int mapLength = mEntityTypes.length;
		mTagTypes = new JRadioButton[mapLength];
		JPanel radioPanel = new JPanel(new GridLayout(mapLength, 1));

		for(int i = 0; i < mapLength; i ++)
		{
			mTagTypes[i] = new JRadioButton(mEntityTypes[i]);
			bg.add(mTagTypes[i]);
			mTagTypes[i].addActionListener(this);
			radioPanel.add(mTagTypes[i]);
		}
		
		mReplacementPane.add(wordToBeReplacedLabel);
		mReplacementPane.add(mWordToBeReplaced);
		mReplacementPane.add(replacedBy);
		mReplacementPane.add(mReplacedByWord);
		mReplacementPane.add(mOkButton);
		mReplacementPane.add(mReTagButton);
		
		
		JPanel submitPane = new JPanel();
		submitPane.setLayout(new FlowLayout());
		submitPane.add(mSubmitButton);
		submitPane.add(mReplaceTagsButton);
		submitPane.add(mExamineButton);
		submitPane.add(mSkipButton);
		submitPane.add(mShowOriginal);
		
		mTopPane.add(mReplacementPane, BorderLayout.NORTH);
		mTopPane.add(submitPane, BorderLayout.CENTER);
		
		mMiddlePane = new JPanel();
		mMiddlePane.setBackground(Color.white);
		fillInEmailDetails();
		mEmailScrollPane = new JScrollPane(mMiddlePane,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
				
		mBottomPane = new JPanel();
		mPreviousButton = new JButton("Previous Email");
		mNextButton = new JButton("Next Email");
		mPreviousButton.addActionListener(this);
		mNextButton.addActionListener(this);
		
		mPrev10Button = new JButton("Go 10 mails back");
		mNext10Button = new JButton("Go 10 mails forward");
		mPrev10Button.addActionListener(this);
		mNext10Button.addActionListener(this);
				
		mNumberLabel = new JLabel("Email "+(mEmailIndex+1)+" of "+mFileList.size()+" "+mFileList.get(0));	
		mNumberLabel.setFont(new Font("Arial", Font.BOLD, 12));
		
		JPanel numPanel = new JPanel();
		numPanel.add(mNumberLabel, BorderLayout.CENTER);
		
		mGoTo = new JButton("Go To Email ->");
		mGoTo.addActionListener(this);
		
		mEmailNum = new JTextField("1", 5);
				
		mBottomButtonPane = new JPanel();
		mBottomButtonPane.setLayout(new FlowLayout());
		mBottomButtonPane.add(mPrev10Button);
		mBottomButtonPane.add(mPreviousButton);
		mBottomButtonPane.add(mGoTo);
		mBottomButtonPane.add(mEmailNum);
		mBottomButtonPane.add(mNextButton);
		mBottomButtonPane.add(mNext10Button);
		
		mBottomPane.setLayout(new BorderLayout());
		mBottomPane.add(numPanel, BorderLayout.NORTH);
		mBottomPane.add(mBottomButtonPane, BorderLayout.CENTER);
		
		mBottomPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
		
		this.setLayout(new BorderLayout());
		add(mTopPane, BorderLayout.NORTH);
		add(mEmailScrollPane, BorderLayout.CENTER);
		add(mBottomPane, BorderLayout.SOUTH);
		add(radioPanel, BorderLayout.EAST);
		redoPreferredSize();
	}	
	
	
	
	
	
	private void showEmailError()
	{
		if(mEmailIndex<mFileList.size())
		{
			mEmailIndex++;
			fillInEmailDetails();
		}
		else
		{
			//custom title, error icon
			JOptionPane.showMessageDialog(mRootFrame,
			    "Could not emails till the end index",
			    "Email Load Error",
			    JOptionPane.ERROR_MESSAGE);
			return;
		}
	}
	
	
	public static String getFileContent(File f) throws IOException
	{
		FileInputStream fis = new FileInputStream(f);
		InputStreamReader irdr = new InputStreamReader(fis); // promote
		int size = (int) f.length(); // get the file size (in bytes)
		char[] data = new char[size]; // allocate char array of right size
		irdr.read( data, 0, size );   // read into char array
		irdr.close();
		fis.close();
		String contents = new String(data);
		return contents;
	}
	
	private void fillInEmailDetails()
	{
		String fullPath=mEmailDirectory.getAbsolutePath()+"\\"+mFileList.get(mEmailIndex);
		FileInputStream inp;
		inp=null;
		try
		{
			inp = new FileInputStream(fullPath);
			inp.close();
		}
		catch (Exception e) {
			logger.warn("Could not read file:"+fullPath,e);
			showEmailError();
			return;
		}
		File emailF = new File(fullPath);
		String stringContent=null;
		try
		{
			stringContent=getFileContent(emailF);
		}
		catch(IOException e)
		{
			logger.warn("Could not read raw contents of file:"+fullPath, e);
			showEmailError();
			return;			
		}	
				
		// briefing area should be scrollable
		stringContent=performReplacements(stringContent);
		mEmailText = new JTextArea(stringContent);
		mEmailText.setFont(RevisedConstants.FIXED_FONT);
		mEmailText.setLineWrap(true);
		mEmailText.setWrapStyleWord(true);
		mEmailText.addMouseListener(this);
		
		JComponent c[] = new JComponent[1];
		c[0] = mEmailText;
				
		mMiddlePane = Toolbox.makeVerticalList(c, true, Toolbox.getColWidth(mRootFrame));
		mMiddlePane.setBackground(GUIConstants.RADAR_WHITE);
		mMiddlePane.setOpaque(true);
		mMiddlePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		
		mFileName = mFileList.get(mEmailIndex);
			
		
		mReplacedByWord.setText("");
		mWordToBeReplaced.setText("");
		mGrayReplacements = new ArrayList<GrayReplacement>();
		highlightReplacements();

	}	
	
	
	
	
	private String performReplacements(String stringContent)
	{
		ArrayList<String> replacements = new ArrayList<String>(mGlobalReplacementMap.keySet());
		ArrayList<String> keywords = new ArrayList<String>(mGlobalReplacementMap.values());
		
		ArrayList<String> replacements2 = new ArrayList<String>(mTemporaryReplacementMap.keySet());
		ArrayList<String> keywords2 = new ArrayList<String>(mTemporaryReplacementMap.values());
		
		replacements.addAll(replacements2);
		keywords.addAll(keywords2);
		
		
		int size = replacements.size();
		Pair[] pArray = new Pair[size];
			
		for(int i = 0; i < size; i ++)
		{
			pArray[i] = new Pair(keywords.get(i), replacements.get(i));
		}
		
		Comparator<Pair> c = new Comparator<Pair>()
		{
			public int compare(Pair arg0, Pair arg1) {
				if(arg0.keyword.length()<arg1.keyword.length())
					return 1;
				else if(arg0.keyword.length()==arg1.keyword.length())
					return 0;
				else 
					return -1;
			}
		};
		
		Arrays.sort(pArray,c);	
		StringBuffer sb = new StringBuffer(stringContent);
				
		for(int i = 0; i < size; i ++)
		{	
			String keyword = pArray[i].keyword;
			String replacement = pArray[i].replacement;
			sb = doSingleReplacement(sb, keyword, replacement);
		}
		return sb.toString();	
	}	
	
	
	private boolean checkDelimiters(String string, int index, String keyword)
	{
		boolean first = true;
		boolean end = true;
		string=string+"\n";
		
		if(index==0)
		{
			first = true;
		}
		else 
		{
			char ch = string.charAt(index-1);
			first = isDelimiter(ch);
		}
		
		int lastIndex=index+keyword.length();
		if(lastIndex>=string.length())
		{
			end = true;
		}
		else
		{
			char ch = string.charAt(lastIndex);
			end = isDelimiter(ch);
		}				
		return first&end;
	}
		

	
	private boolean isDelimiter(char ch)
	{
		if((ch>='a'&&ch<='z')||(ch>='A'&&ch<='Z')||(ch>='0'&&ch<='9'))
			return false;
		else
			return true;
	}
	
	private void highlightReplacements()
	{
		String content = mEmailText.getText();
		int length = mEntityTypes.length;
		ArrayList<Replacement> replacements = new ArrayList<Replacement>();
		
		for(int i = 0; i < length; i ++)
		{
			String pattern = mEntityTypes[i]+RevisedConstants.SUFFIX_EXPR;
			Pattern p = Pattern.compile(pattern);
			Matcher m = p.matcher(content);
			while(m.find())
			{
				int start=m.start();
				int end=m.end();
				boolean isCommon = mCommonTags.contains(m.group());
				Replacement r = new Replacement(true,start,end,isCommon);
				replacements.add(r);
			}
			
			pattern = mEntityTypes[i]+RevisedConstants.SUFFIX_EXPR_TWO;
			p = Pattern.compile(pattern);
			m = p.matcher(content);
			while(m.find())
			{
				int start=m.start();
				int end=m.end();
				boolean isCommon = mCommonTags.contains(m.group());
				Replacement r = new Replacement(false,start,end,isCommon);
				replacements.add(r);
			}
		}		
		int size=replacements.size();
		Replacement[] rArray = new Replacement[size];
		rArray=replacements.toArray(rArray);
		ReplacementComparator replacementComparator = new ReplacementComparator();
		Arrays.sort(rArray, replacementComparator);		
		mGlobalReplacements=new ArrayList<Replacement>(Arrays.asList(rArray));
		highlightAll();
	}
		
		
	private void redoPreferredSize()
	{
		int w = Toolbox.getColWidth(mRootFrame);
		int c = 0;
		int h = 0;
		
		h += (c = getTextComponentPreferredHeight(mEmailText, w));
		mEmailText.setPreferredSize(new Dimension(w,c));		
		mMiddlePane.setPreferredSize(new Dimension(w, h));	
		revalidate();	
	}
	
	
	public int getTextComponentPreferredHeight(JTextComponent aText, int aWidth)
	{
		View rootView = aText.getUI().getRootView(aText);
		rootView.setSize(aWidth, Integer.MAX_VALUE);
		return (int) rootView.getPreferredSpan(View.Y_AXIS);
	}		
	
	
	private void initializeData(Properties props, DBConnection dbc, RevisedAnonFrame rootFrame)
	{
		String directoryPath=props.getProperty(RevisedConstants.DIRECTORY_PATH);
		mEmailDirectory = new File(directoryPath); 
		if(!mEmailDirectory.isDirectory())
		{
			logger.warn("Given directory:"+directoryPath+" is not a directory.");
			System.exit(0);
		}
				
		FilenameFilter filter =  new FilenameFilter()
		{
			    public boolean accept(File dir, String name) {
			        return (name.endsWith(".txt"));
			    }
		};
				
		mFileList=new ArrayList<String>(Arrays.asList(mEmailDirectory.list(filter)));
		mEmailIndex=0;
				
		String outputPath=props.getProperty(RevisedConstants.OUTPUT_PATH);
		mOutputPath = new File(outputPath); 
		if(!mOutputPath.isDirectory())
		{
			logger.warn("Given directory:"+directoryPath+" is not a directory.");
			System.exit(0);
		}
		
		
		
		
		String entities = props.getProperty(RevisedConstants.ENTITY_TYPES);
		if(entities==null)
		{
			logger.warn("Email Entities Property Null. Please include comma separated entity types");
			System.exit(0);
		}
		StringTokenizer st = new StringTokenizer(entities.trim(),",");
		int count = st.countTokens();
		mEntityTypes = new String[count];
		for(int i = 0; i < count; i ++)
		{
			mEntityTypes[i] = new String(st.nextToken());
		}		
		
		String mistagged = props.getProperty(RevisedConstants.COMMON_MISTAGGED_WORDS);
		if(mistagged==null)
		{
			mCommonWords = new String[0];
			return;
		}
		mistagged=mistagged.trim();
		if(mistagged.equals(""))
		{
			mCommonWords = new String[0];
			return;
		}
		st = new StringTokenizer(mistagged,",");
		int countTokens = st.countTokens();
		if(countTokens==0)
		{
			mCommonWords = new String[0];
			return;
		}
		ArrayList<String> list = new ArrayList<String>();
		while(st.hasMoreTokens())
		{
			list.add(st.nextToken().trim().toLowerCase());
		}
		
		int len = list.size();
		mCommonWords = new String[len];
		mCommonWords = list.toArray(mCommonWords);
		Arrays.sort(mCommonWords);
		mCommonTags = new HashSet<String>();
		
		
		mGlobalReplacementMap = new HashMap<String,String>();
		String mapFile = props.getProperty(RevisedConstants.MAP_PATH);
		try
		{
			BufferedReader bReader = new BufferedReader(new FileReader(mapFile));
			String line=null;
			StringBuffer content = new StringBuffer("");
			while((line=bReader.readLine())!=null)
			{
				content.append(line+"\n");
			}
			st = new StringTokenizer(content.toString(),"\f");
			while(st.hasMoreTokens())
			{	
				
				String mapping = st.nextToken().trim();
				if(mapping.equals("")||mapping==null)
					continue;

				StringTokenizer st1 = new StringTokenizer(mapping);
				String tag = st1.nextToken();
				String words=mapping.substring(tag.length()).trim();
				if(mGlobalReplacementMap.containsKey(tag))
				{
					logger.warn("Map contains tag:"+tag+" words:"+words);
					System.exit(0);
				}
				else
				{
					mGlobalReplacementMap.put(tag, words);
					int index=Arrays.binarySearch(mCommonWords, words.toLowerCase());
					if(index>=0)
					{
						mCommonTags.add(tag);
					}
				}
			}
			bReader.close();
		}
		catch(Exception e)
		{
			logger.warn("Problem reading mapFile",e);
			System.exit(0);
		}
		
		mTemporaryReplacementMap = new HashMap<String,String>();
		ArrayList<String> mapping = dbc.getTemporaryMapping("temporary");
		int size = mapping.size();
		for(int i = 0; i < size/2; i++)
		{
			String keyword = mapping.get(2*i);
			String replacement = mapping.get(2*i+1);
			mTemporaryReplacementMap.put(replacement, keyword);
			int index=Arrays.binarySearch(mCommonWords, keyword.toLowerCase());
			if(index>=0)
			{
				mCommonTags.add(replacement);
			}
		}
	}
	
	
	public int searchHighLight(int index)
	{
		int length = mGlobalReplacements.size();
		Replacement[] rArray=new Replacement[length];
		rArray=mGlobalReplacements.toArray(rArray);
		
		int low = 0;
		int high = length-1;
		while(low<=high)
		{
			int mid = (low + high)/2;
			if(index < rArray[mid].getStart())
	               high = mid - 1;
	        else if (index > rArray[mid].getEnd())
	               low = mid + 1;
	        else
	        {
	        	return mid;
	        }
		}
		return -1;
		
	}
	
	
	
	//Creates highlights around all occurrences of pattern in textComp
    public void highlight(JTextComponent textComp, int startIndex, int length, int type) {
    	
        try {
            Highlighter hilite = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            if(type==0)
            	hilite.addHighlight(startIndex, startIndex+length, mMyHighlightPainter);
            else if(type==1)
            	hilite.addHighlight(startIndex, startIndex+length, mMyHighlightPainterTwo);
            else if(type==2)
            	hilite.addHighlight(startIndex, startIndex+length, mMyHighlightPainterThree);
            else
            	hilite.addHighlight(startIndex, startIndex+length, mMyHighlightPainterFour);
            
        } catch (BadLocationException e) {
        	logger.warn("Problem in higlight", e);
        }
    }	
    

    
    // Removes only our private highlights
    public void removeHighlights(JTextComponent textComp) {
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
                
        for (int i=0; i<hilites.length; i++) {
            if (hilites[i].getPainter() instanceof MyHighlightPainter) {
                hilite.removeHighlight(hilites[i]);
            }
        }
    }
	
    private void loadEmail(int offset)
    {
    	mEmailIndex+=offset;
		mEmailNum.setText(""+(mEmailIndex+1));
		mMiddlePane = new JPanel();
		fillInEmailDetails();
		this.remove(mEmailScrollPane);
		mEmailScrollPane = new JScrollPane(mMiddlePane,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		this.add(mEmailScrollPane, BorderLayout.CENTER);
		mNumberLabel.setText("Email "+(mEmailIndex+1)+" of "+mFileList.size()+" "+mFileList.get(mEmailIndex));
		mSubmitButton.setEnabled(true);
		mSkipButton.setEnabled(true);
		mExamineButton.setEnabled(true);
		mReplaceTagsButton.setEnabled(true);
		redoPreferredSize();
    }
    
    public boolean getConfirmation()
	{
		if(!mSubmitButton.isEnabled())
			return true;
		JOptionPane.showMessageDialog(mRootFrame,
			    "Either select save, skip or reexamine button",
			    "Email Load Error",
			    JOptionPane.ERROR_MESSAGE);
		return false;
											
	}
    
    public void submitEmail()
	{
		String orgFile = mFileList.get(mEmailIndex);
		String fileName = orgFile.substring(0,  orgFile.length()-3)+"txt.done";
    	try {
			String outPath=mOutputPath.getAbsolutePath()+"\\"+fileName;
    		BufferedWriter bWriter = new BufferedWriter(new FileWriter(outPath));
			StringBuffer sb = new StringBuffer("");
			sb.append(mEmailText.getText());
			bWriter.write(sb.toString());
			bWriter.close();
			String orgPath=mEmailDirectory.getAbsolutePath()+"\\"+orgFile;
			System.out.println(orgPath);
			String revisedPath=mEmailDirectory.getAbsolutePath()+"\\"+fileName;
			System.out.println(revisedPath);
			File file = new File(orgPath);
			File newFile = new File(revisedPath);
			boolean res = file.renameTo(newFile);
			if(!res)
				throw new Exception("Problem in renaming");
			file.delete();
			mFileList.remove(mEmailIndex);
			mEmailIndex--;
			mSubmitButton.setEnabled(false);
			mExamineButton.setEnabled(false);
			mSkipButton.setEnabled(false);
			mReplaceTagsButton.setEnabled(false);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.warn("Problem in writing file:"+mFileList.get(mEmailIndex),e);
		}
			
	}
    
    public void skipEmail()
    {
    	String orgFile = mFileList.get(mEmailIndex);
		String fileName = orgFile.substring(0,  orgFile.length()-3)+"txt.skip";
    	try {
			String orgPath=mEmailDirectory.getAbsolutePath()+"\\"+orgFile;
			System.out.println(orgPath);
			String revisedPath=mEmailDirectory.getAbsolutePath()+"\\"+fileName;
			System.out.println(revisedPath);
			File file = new File(orgPath);
			File newFile = new File(revisedPath);
			boolean res = file.renameTo(newFile);
			if(!res)
				throw new Exception("Problem in renaming");
			file.delete();
			mFileList.remove(mEmailIndex);
			mEmailIndex--;
			mSubmitButton.setEnabled(false);
			mExamineButton.setEnabled(false);
			mSkipButton.setEnabled(false);
			mReplaceTagsButton.setEnabled(false);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.warn("Problem in writing file:"+mFileList.get(mEmailIndex),e);
		}
    }
    
    public void markDoneTemporarily()
    {
    	String orgFile = mFileList.get(mEmailIndex);
		String doneFileName = orgFile.substring(0,  orgFile.length()-3)+"txt.done";
		String retagFileName = orgFile.substring(0,  orgFile.length()-3)+"txt.retag";
		
    	try {
			String outPath=mOutputPath.getAbsolutePath()+"\\"+retagFileName;
    		BufferedWriter bWriter = new BufferedWriter(new FileWriter(outPath));
			StringBuffer sb = new StringBuffer("");
			sb.append(mEmailText.getText());
			bWriter.write(sb.toString());
			bWriter.close();
			String orgPath=mEmailDirectory.getAbsolutePath()+"\\"+orgFile;
			System.out.println(orgPath);
			String revisedPath=mEmailDirectory.getAbsolutePath()+"\\"+doneFileName;
			System.out.println(revisedPath);
			File file = new File(orgPath);
			File newFile = new File(revisedPath);
			boolean res = file.renameTo(newFile);
			if(!res)
				throw new Exception("Problem in renaming");
			file.delete();
			mFileList.remove(mEmailIndex);
			mEmailIndex--;
			mSubmitButton.setEnabled(false);
			mExamineButton.setEnabled(false);
			mSkipButton.setEnabled(false);
			mReplaceTagsButton.setEnabled(false);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.warn("Problem in writing file:"+mFileList.get(mEmailIndex),e);
		}
    }
    
    
    public void reExamineEmail()
    {
    	mSubmitButton.setEnabled(false);
		mExamineButton.setEnabled(false);
		mSkipButton.setEnabled(false);
		mReplaceTagsButton.setEnabled(false);
    }
    
    public void reTag()
    {
    	String stringContent = performReplacements(mEmailText.getText());
    	mEmailText.setText(stringContent);
    	mReplacedByWord.setText("");
		mWordToBeReplaced.setText("");
		mGrayReplacements = new ArrayList<GrayReplacement>();
		highlightReplacements();
		mEmailText.setCaretPosition(0);
    }
      
    
	public void actionPerformed(ActionEvent arg0)
	{
		Object source = arg0.getSource();
		
		if(source.equals(mNextButton))
		{
			if(!getConfirmation())
			{
				return;
			}
			if(mEmailIndex<(mFileList.size()-1))
			{
				loadEmail(1);	
			}
			else
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "Last email reached",
					    "Email Load Error",
					    JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(arg0.getSource().equals(mPreviousButton))
		{
			if(!getConfirmation())
			{
				return;
			}
			if(mEmailIndex>0)
			{
				
				loadEmail(-1);
			}
			else
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "First email reached",
					    "Email Load Error",
					    JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(arg0.getSource().equals(mPrev10Button))
		{
			if(!getConfirmation())
			{
				return;
			}
			if(mEmailIndex-10>=0)
			{
				loadEmail(-10);
			}
			else
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "Can't go back that much, first email reached",
					    "Email Load Error",
					    JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(arg0.getSource().equals(mNext10Button))
		{
			if(!getConfirmation())
			{
				return;
			}
			if(mEmailIndex+10<mFileList.size())
			{
				loadEmail(10);
			}
			else
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "Can't go back that much, first email reached",
					    "Email Load Error",
					    JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(arg0.getSource().equals(mOkButton))
		{
			handleReplacement();
		}
		else if(source.equals(mSubmitButton))
		{
			boolean res = checkEmailStatus();
			if(!res)
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "You cannot submit email because of the presence of blue temporary tags",
					    "Email Submit Error",
					    JOptionPane.ERROR_MESSAGE);
				return;
			}
			submitEmail();
		}
		
		else if(source.equals(mExamineButton))
		{
			reExamineEmail();
		}
		else if(source.equals(mSkipButton))
		{
			skipEmail();
		}
		else if(source.equals(mReTagButton))
		{
			reTag();
		}
		else if(source.equals(mGoTo))
		{
			gotoAction();
		}
		else if(source.equals(mReplaceTagsButton))
		{
			markDoneTemporarily();
		}
		else if(source.equals(mShowOriginal))
		{
			if(mOf!=null)
			{
				return;
			}
			mOf = new OriginalFrame(mEmailDirectory.getAbsolutePath()+"\\"+mFileList.get(mEmailIndex),this);
			mOf.setVisible(true);
		}
		else
		{
			for(int i = 0; i < mTagTypes.length; i ++)
				if(source.equals(mTagTypes[i]))
					handleSelectionOfType(i);
		}
		
	}
	
	
	public void setOfNull()
	{
		mOf.dispose();
		mOf=null;
	}
	
	public void gotoAction()
	{
		if(!getConfirmation())
		{
			return;
		}
		String text = mEmailNum.getText();
		if(text==null||text.equals(""))
			return;
		int val;
		try
		{
			val = new Integer(text.trim()).intValue();
		}
		catch(Exception e)
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Wrong Email Number. Enter an Integer",
				    "Email Number Error",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
		if(val >=1 && val <= mFileList.size())
		{
			
			int offset = val-mEmailIndex-1;
			loadEmail(offset);
		}
		else
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Index entered not in range.",
				    "Email Load Error",
				    JOptionPane.ERROR_MESSAGE);
		}
		
	}
		
	private boolean checkEmailStatus()
	{
		String pattern = RevisedConstants.SUFFIX_EXPR_TWO;
		Pattern p = Pattern.compile(pattern);
		Matcher m = p.matcher(mEmailText.getText());
		if(m.find())
		{
			return false;
		}
		else
			return true;
	}
	
	private void handleReplacement()
	{
		String keyWord = mWordToBeReplaced.getText().trim().toLowerCase();
		String replacement = mReplacedByWord.getText().trim();
				
		if(keyWord==null || keyWord.equals(""))
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Word to be Replaced is empty",
				    "Null Selection",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		if(replacement==null || replacement.equals(""))
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Replacement word is empty",
				    "Null Selection",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
			
		if(mTemporaryReplacementMap.containsKey(replacement))
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Replacement word already in database.",
				    "Database error",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
				
		Pattern p = Pattern.compile(RevisedConstants.SUFFIX_EXPR_TWO);
		Matcher m = p.matcher(replacement);
		boolean found = m.find();
		if(!found)
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Replacement should be of the form <TYPE>_NNNN+TNNN",
				    "Database error",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		boolean res = mDbc.insertReplacementTwo("temporary", keyWord, replacement);
		if(!res)
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Could not Insert in Database",
				    "Database error",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}		
				
		mTemporaryReplacementMap.put(replacement, keyWord);
		mOkButton.setEnabled(false);
			
		StringBuffer sb = new StringBuffer(mEmailText.getText());
		
		sb=doSingleReplacement(sb,keyWord,replacement);
		int offset = replacement.length() - keyWord.length();
		removeOverlappingGrayReplacements(mReplacementStartIndex,mReplacementEndIndex);
		reviseGrayReplacements(mReplacementEndIndex,offset);
		mEmailText.setText(sb.toString());
		highlightReplacements();
		mEmailText.setCaretPosition(mReplacementEndIndex);
	}
	
	private StringBuffer doSingleReplacement(StringBuffer sb, String keyWord, String replacement)
	{
		String lowerCase = sb.toString().toLowerCase();
		int fromIndex = 0;
		int index;
		keyWord = keyWord.replace("\n", " ");
		keyWord = keyWord.replace("\r", " ");
		lowerCase = lowerCase.replace("\n", " ");
		lowerCase = lowerCase.replace("\r", " ");
		while((index=lowerCase.indexOf(keyWord,fromIndex))!=-1)
		{
					
			boolean decide = checkDelimiters(lowerCase,index,keyWord);
			if(!decide)
			{
				fromIndex=index+keyWord.length();
				continue;
			}
			
			sb.delete(index, index+keyWord.length());
			sb.insert(index, replacement);
			fromIndex=index+replacement.length();				
			lowerCase = sb.toString().toLowerCase();
			lowerCase = lowerCase.replace("\n", " ");
			lowerCase = lowerCase.replace("\r", " ");
		}
		
		return sb;
	}
	
	
	public int searchGrayHighLight(int index)
	{
		int length = mGrayReplacements.size();
		if(length==0)
			return -1;
		
		GrayReplacement[] rArray=new GrayReplacement[length];
		rArray=mGrayReplacements.toArray(rArray);
		
		int low = 0;
		int high = length-1;
		while(low<=high)
		{
			int mid = (low + high)/2;
			if(index < rArray[mid].start)
	               high = mid - 1;
	        else if (index > rArray[mid].end)
	               low = mid + 1;
	        else
	        {
	        	return mid;
	        }
		}
		return -1;
		
	}
	
	public void handleGrayClick(int index)
	{
		GrayReplacement r = mGrayReplacements.get(index);
		String prefix = mEmailText.getText().substring(0,r.start);
		String suffix = mEmailText.getText().substring(r.end);
		
		String replacement = r.replacement;
		
		int keywordLength=r.end-r.start;
		int replacementLength=replacement.length();
		int offset=-(keywordLength-replacementLength);
		
		mGrayReplacements.remove(index);
		reviseGrayReplacements(r.end,offset);
		reviseReplacementsTwo(r.end,offset);
		insertActualReplacement(replacement,r.start,r.start+replacement.length());
		mEmailText.setText(prefix+replacement+suffix);
		removeHighlights(mEmailText);
		mEmailText.setCaretPosition(r.start);
		highlightAll();
	}
	
	
	public void insertActualReplacement(String replacement, int start, int end)
	{
		Pattern p = Pattern.compile(RevisedConstants.SUFFIX_EXPR_TWO);
		Matcher m = p.matcher(replacement);
		boolean found = m.find();
		boolean type=false;
		if(found)
			type = false;
		else
			type = true;
		boolean isCommon = mCommonTags.contains(replacement);
		Replacement r = new Replacement(type,start,end,isCommon);
		mGlobalReplacements.add(r);
		int size = mGlobalReplacements.size();
		Replacement[] rArray = new Replacement[size];
		rArray = mGlobalReplacements.toArray(rArray);
		Arrays.sort(rArray,new ReplacementComparator());
		mGlobalReplacements = new ArrayList<Replacement>(Arrays.asList(rArray));	
	}
	
	
	public void highlightAll()
	{
		removeHighlights(mEmailText);
		int size = mGlobalReplacements.size();
		for(int i = 0; i < size; i ++)
		{
			int type;
			if(mGlobalReplacements.get(i).getType())
				type=0;
			else
				type=1;
			
			if(mGlobalReplacements.get(i).isCommon())
				type=3;
			
			highlight(mEmailText,mGlobalReplacements.get(i).getStart(), mGlobalReplacements.get(i).getEnd()-mGlobalReplacements.get(i).getStart(), type);
		}
		size = mGrayReplacements.size();
		for(int i = 0; i < size; i ++)
		{
			highlight(mEmailText,mGrayReplacements.get(i).start, mGrayReplacements.get(i).end-mGrayReplacements.get(i).start,2);
		}	
	}
	
	public void reviseGrayReplacements(int start,int offset)
	{
		int size = mGrayReplacements.size();
		for(int i = 0; i < size; i ++)
		{
			GrayReplacement g = mGrayReplacements.get(i);
			if(g.start<start)
				continue;
			g.start+=offset;
			g.end+=offset;
		}
	}
	
	public void removeOverlappingGrayReplacements(int start,int end)
	{
		int size = mGrayReplacements.size();
		for(int i = 0; i < size; i ++)
		{
			GrayReplacement g = mGrayReplacements.get(i);
			if(g.start>=start&&g.end<=end)
			{
				mGrayReplacements.remove(i);
			}
			size = mGrayReplacements.size();
		}
	}
	
	public void mouseClicked(MouseEvent arg0) {
		// TODO Auto-generated method stub
		int button = arg0.getButton();
		if(button==arg0.BUTTON3)
		{
			int offset = mEmailText.viewToModel(arg0.getPoint());
			int index = searchHighLight(offset);
			if(index==-1)
			{
				index = searchGrayHighLight(offset);
				if(index==-1)
				{
					logger.warn("Span not found. Returning");
					return;
				}
				handleGrayClick(index);
				return;
			}
						
			Replacement r = mGlobalReplacements.get(index);
			try {
				String replacement = mEmailText.getText(r.getStart(),r.getEnd()-r.getStart());
				String keyword;
				if(r.getType())
					keyword = (String)mGlobalReplacementMap.get(replacement);
				else
					keyword = (String)mTemporaryReplacementMap.get(replacement);
				
				if(keyword==null)
					return;	

				String prefix = mEmailText.getText().substring(0,r.getStart());
				String suffix = mEmailText.getText().substring(r.getEnd());
				mEmailText.setText(prefix+keyword+suffix);
				reviseReplacements(index,keyword);
				int replacementLength=r.getEnd()-r.getStart();
				int keywordLength=keyword.length();
				offset=keywordLength-replacementLength;
				reviseGrayReplacements(r.getEnd(),offset);
				mEmailText.setCaretPosition(r.getStart());
				insertIntoGrayList(r.getStart(), r.getStart()+keyword.length(),replacement);
				highlightAll();
			}
			catch (BadLocationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return;
			}
		}
	}
	
	private void insertIntoGrayList(int start, int end, String replacement)
	{
		GrayReplacement gr = new GrayReplacement(start, end, replacement);
		mGrayReplacements.add(gr);
		int size = mGrayReplacements.size();
		GrayReplacement[] gArray = new GrayReplacement[size];
		gArray = mGrayReplacements.toArray(gArray);
		Arrays.sort(gArray, new Comparator<GrayReplacement>(){
			public int compare(GrayReplacement arg0, GrayReplacement arg1) {
				if(arg0.start<arg1.start)
					return -1;
				else if(arg0.start==arg1.start)
					return 0;
				else
					return 1;
			}
			
		});
		mGrayReplacements = new ArrayList<GrayReplacement>(Arrays.asList(gArray));
	}
	

	public void reviseReplacements(int index, String keyword)
	{
		Replacement r = mGlobalReplacements.get(index);
		
		int replacementLength=r.getEnd()-r.getStart();
		int keywordLength=keyword.length();
		int offset=keywordLength-replacementLength;
				
		mGlobalReplacements.remove(index);
		int size = mGlobalReplacements.size();
		
		for(int i = index; i < size; i ++)
		{
			Replacement r1 = mGlobalReplacements.get(i);
			r1.setStart(r1.getStart()+offset);
			r1.setEnd(r1.getEnd()+offset);
		}
		
	}
	
	public void reviseReplacementsTwo(int start,int offset)
	{
		int size = mGlobalReplacements.size();
		for(int i = 0; i < size; i ++)
		{
			Replacement g = mGlobalReplacements.get(i);
			if(g.getStart()<start)
				continue;
			g.setStart(g.getStart()+offset);
			g.setEnd(g.getEnd()+offset);
		}
	}
	
	
	
	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
	}
	
		
	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	
	
	public void mousePressed(MouseEvent arg0) {
		mSelectionActive=true;
	}
	
	
	
	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
		if(!mSelectionActive)
		{
			mSelectionActive=false;
			return;
		}
		String result = getSelectedText(mEmailText);
		mWordToBeReplaced.setText(result);
		mTagTypes[RevisedConstants.OTHER_INDEX].setSelected(true);
		mReplacedByWord.setText("");
		mOkButton.setEnabled(true);
		handleSelectionOfType(RevisedConstants.OTHER_INDEX);
		
	}
		
	
	public String getSelectedText(JTextArea area)
	{
		String result="";
		Caret caret = area.getCaret();
		int start = caret.getMark();
		int end = caret.getDot();
		if (end == start)
			return result;
		else if (end < start) {
			int swap = end;
			end = start;
			start = swap;
		}
		mReplacementEndIndex=end;
		mReplacementStartIndex=start;
		String text = area.getText();
		try
		{
			result = text.substring(start, end);
		}
		catch(Exception e)
		{
			logger.warn("Problem in extracting selected text", e);
		}
		
		return result;
	}
	
	private int getIDFromReplacement(String id)
	{
		int lastIndex0 = id.lastIndexOf("_");
		String subString = id.substring(lastIndex0+1,lastIndex0+1+RevisedConstants.LENGTH_OF_ID);
		int id0 = new Integer(subString).intValue();
		return id0;
	}
	
	private String appendZeroes(int id)
	{	
		String tok = new String(""+id);
		String prefix="";
		int extraLen = RevisedConstants.LENGTH_OF_ID-tok.length();
		for(int i = 0; i < extraLen; i ++)
			prefix+="0";
		
		return prefix+tok;
	}
	
	private String getNewMaxIndex()
	{
		if(mTemporaryReplacementMap.size()==0)
			return appendZeroes(0);
		
		ArrayList<String> replacements = new ArrayList<String>(mTemporaryReplacementMap.keySet());
		String[] rArray = new String[replacements.size()];
		rArray = replacements.toArray(rArray);
		
		Arrays.sort(rArray,new Comparator<String>()
				{

					public int compare(String arg0, String arg1) {
						int id0 = getIDFromReplacement(arg0);
						int id1 = getIDFromReplacement(arg1);
						
						if(id0<id1)
							return 1;
						else if(id0==id1)
							return 0;
						else 
							return -1;
						
					}
				});
		return appendZeroes(getIDFromReplacement(rArray[0])+1);
	}
		
	public void handleSelectionOfType(int i)
	{
		int selectedIndex = i;
		String type = mEntityTypes[selectedIndex];	
		String maxIndex=getNewMaxIndex();
		String newReplacement = type+"_"+maxIndex+"+"+RevisedConstants.TEMP_REPLACEMENT_SUFFIX;
		mReplacedByWord.setText(newReplacement);
	}
}

//A private subclass of the default highlight painter
class MyHighlightPainter extends DefaultHighlighter.DefaultHighlightPainter {
    public MyHighlightPainter(Color color) {
        super(color);
    }
}

class Pair
{
	public String keyword;
	public String replacement;
	
	public Pair(String k, String r)
	{
		keyword = k;
		replacement = r;
	}
}


class GrayReplacement
{
	public int start;
	public int end;
	public String replacement;
	
	public GrayReplacement(int s, int e, String r)
	{
		start = s;
		end = e;
		replacement = r;
	}
	
}

