package email.anonymize.gui.revised;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import email.anonymize.gui.GUIConstants;
import email.database.DBConnection;
import email.utils.Toolbox;



public class OriginalFrame extends JFrame implements WindowListener
{
	RevisedAnonPanel mRootPane;
	
	
	public OriginalFrame(String fileName, RevisedAnonPanel rootPane)
	{	
		this.setSize(800, 600);
		this.setTitle("Anonymization Tool 1.1");
		this.setIconImage(GUIConstants.RADAR_ICON.getImage());
		
		JPanel panel = new JPanel();
		JTextArea area = new JTextArea();
		String emailText="";
		try
		{
			emailText = getFileContent(new File(fileName));
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		area.setText(emailText);
		area.setFont(RevisedConstants.FIXED_FONT);
		area.setLineWrap(true);
		area.setWrapStyleWord(true);
		
		
		JScrollPane scroll = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		scroll.getViewport().add(area);
		area.setCaretPosition(0);
		
		this.getContentPane().add(scroll);
		centerOnScreen();
		mRootPane=rootPane;
		addWindowListener(this);
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
	}
	
	public String getFileContent(File f) throws IOException
	{
		FileInputStream fis = new FileInputStream(f);
		InputStreamReader irdr = new InputStreamReader(fis); // promote
		int size = (int) f.length(); // get the file size (in bytes)
		char[] data = new char[size]; // allocate char array of right size
		irdr.read( data, 0, size );   // read into char array
		irdr.close();
		fis.close();
		String contents = new String(data);
		return contents;
	}
	
	
	public void centerOnScreen()
	{
		 Dimension d = null; // size of what we're positioning against
         Point     p = null;
                  
         try
         {
        	 d = Toolkit.getDefaultToolkit().getScreenSize();        
        	 p = new Point();
         }
         catch(Exception e)
         {
        	 e.printStackTrace();
        	 return;
         }        

         double centreX = p.getX() + d.getWidth()  / 2;
         double centreY = p.getY() + d.getHeight() / 2;

         this.getSize(d);
         p.setLocation(centreX - d.getWidth() / 2,
                       centreY - d.getHeight() / 2);
         if (p.getX() < 0)
           p.setLocation(0, p.getY());

         if (p.getY() < 0)
           p.setLocation(p.getX(), 0);

         this.setLocation(p);
	}

	public void windowActivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowClosed(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowClosing(WindowEvent arg0) {
		this.setVisible(false);
		mRootPane.setOfNull();
	}

	public void windowDeactivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowDeiconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowIconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowOpened(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	
	
}