package email.anonymize.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SpringLayout;

import org.apache.log4j.Logger;

import email.database.DBConnection;
import email.utils.Toolbox;

import javax.swing.BorderFactory;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class AnonPanel extends JPanel implements ActionListener, MouseListener
{
	DBConnection mDbc;
	AnonFrame mRootFrame;
	File mEmailDirectory;
	String[] mFileList;
	int mEmailIndex;
	
	JTextField mWordToBeReplaced;
	JTextField mReplacedByWord;
	JButton mOkButton;
	JButton mSubmitButton;
	JButton mPreviousButton;
	JButton mNextButton;
	
	
	JButton mNext10Button;
	JButton mPrev10Button;
	
	JTextArea mSubject;
	JTextArea mTo;
	JTextArea mFrom;
	JTextArea mDate;
	JTextArea mBodyText;
	String mFileName;
	
	JPanel mMiddlePane;
	JScrollPane mEmailScrollPane;
	
	JPanel mTopPane;
	JPanel mBottomPane;
	
	JPanel mFromPane;
	JPanel mDatePane;
	
	JPanel mToPane;
	JPanel mSubjPane;
	
	JLabel mNumberLabel;
	JPanel mBottomButtonPane;
	
	JComboBox mReplacementBox;
	JLabel mFinding;
	JButton mShowNext;
	JButton mAccept;
	int mNumSuggestions;
	int mCurrentSuggestion=-1;
	
	boolean mSelectionActive;
	Object mActiveArea;
	
	
	
	JButton mGoTo;
	JTextField mEmailNum;
	
	Suggestion[] mSug;
	
	String mOldText="";
	
	Highlighter.HighlightPainter mMyHighlightPainter = new MyHighlightPainter(Color.red);
    	
	String mOutputPath;
	
	
	
	ArrayList mSeenButNotAcceptedSuggestionList;
	Suggestion mPreviousSuggestion;
	boolean mASuggestionSeenFlag;
	
	static Logger logger = null;
	static
	{
		logger = Logger.getLogger(AnonPanel.class);
	}
	
	
	public AnonPanel(Properties props, DBConnection dbc, AnonFrame rootFrame)
	{
		initializeData(props, dbc, rootFrame);
		mSeenButNotAcceptedSuggestionList=new ArrayList();
		//top panel with the replacement words
		mTopPane = new JPanel();
		mTopPane.setLayout(new BorderLayout());
		
		JPanel mReplacementPane = new JPanel();
		mReplacementPane.setLayout(new FlowLayout());
		mRootFrame = rootFrame;
		mDbc = dbc;
				
		mWordToBeReplaced = new JTextField(10); 
		JLabel wordToBeReplacedLabel = new JLabel("Word to be Replaced");
		wordToBeReplacedLabel.setFont(new Font("Arial", Font.BOLD, 12));
				
		mReplacedByWord = new JTextField(10);
		JLabel replacedBy = new JLabel("Replace by");
		replacedBy.setFont(new Font("Arial", Font.BOLD, 12));
		mReplacementPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
		mReplacedByWord.addActionListener(this);
		
		mOkButton = new JButton("OK");
		mOkButton.setFont(new Font("Arial", Font.PLAIN, 12));
		mOkButton.addActionListener(this);
		mOkButton.setEnabled(false);
		
		mSubmitButton = new JButton("Submit Email");
		mSubmitButton.setFont(new Font("Arial", Font.PLAIN, 12));
		mSubmitButton.addActionListener(this);
		
		mReplacementBox = new JComboBox(GUIConstants.SUGGESTION_TYPES);
		mReplacementBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.blue), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
		mReplacementBox.addActionListener(this);
		mReplacementBox.setSelectedIndex(GUIConstants.SUGGESTION_TYPES.length-1);
		JLabel replacementType = new JLabel("Replacement Category");
		replacementType.setFont(new Font("Arial", Font.BOLD, 12));
		
		
		mReplacementPane.add(wordToBeReplacedLabel);
		mReplacementPane.add(mWordToBeReplaced);
		mReplacementPane.add(replacementType);
		mReplacementPane.add(mReplacementBox);
		mReplacementPane.add(replacedBy);
		mReplacementPane.add(mReplacedByWord);
		mReplacementPane.add(mOkButton);
		mReplacementPane.add(mSubmitButton);
				
		
		JPanel suggestionsPane = new JPanel();
		suggestionsPane.setLayout(new FlowLayout());
		mNumSuggestions = 0;
		mFinding = new JLabel(mNumSuggestions + " suggestions have been found.");
		mFinding.setFont(new Font("Arial", Font.BOLD, 12));
		mShowNext = new JButton("Show Next");
		mShowNext.addActionListener(this);
		mShowNext.setEnabled(false);
		mAccept = new JButton("Accept");
		mAccept.addActionListener(this);
		mAccept.setEnabled(false);
		
		suggestionsPane.add(mFinding);
		suggestionsPane.add(mShowNext);
		suggestionsPane.add(mAccept);
		
		mTopPane.add(mReplacementPane, BorderLayout.NORTH);
		mTopPane.add(suggestionsPane, BorderLayout.SOUTH);
		
		mMiddlePane = new JPanel();
		mMiddlePane.setBackground(Color.white);
		fillInEmailDetails();
		mEmailScrollPane = new JScrollPane(mMiddlePane,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
				
		
		mBottomPane = new JPanel();
		mPreviousButton = new JButton("Previous Email");
		mNextButton = new JButton("Next Email");
		mPreviousButton.addActionListener(this);
		mNextButton.addActionListener(this);
		
		mPrev10Button = new JButton("Go 10 mails back");
		mNext10Button = new JButton("Go 10 mails forward");
		mPrev10Button.addActionListener(this);
		mNext10Button.addActionListener(this);
			
		
		
		mNumberLabel = new JLabel("Email "+(mEmailIndex+1)+" of "+mFileList.length+" "+mFileList[0]);	
		mNumberLabel.setFont(new Font("Arial", Font.BOLD, 12));
		
		JPanel numPanel = new JPanel();
		numPanel.add(mNumberLabel, BorderLayout.CENTER);
		
		mGoTo = new JButton("Go To Email ->");
		mGoTo.addActionListener(this);
		
		mEmailNum = new JTextField("1", 5);
				
		mBottomButtonPane = new JPanel();
		mBottomButtonPane.setLayout(new FlowLayout());
		mBottomButtonPane.add(mPrev10Button);
		mBottomButtonPane.add(mPreviousButton);
		mBottomButtonPane.add(mGoTo);
		mBottomButtonPane.add(mEmailNum);
		mBottomButtonPane.add(mNextButton);
		mBottomButtonPane.add(mNext10Button);
		
		mBottomPane.setLayout(new BorderLayout());
		mBottomPane.add(numPanel, BorderLayout.NORTH);
		mBottomPane.add(mBottomButtonPane, BorderLayout.CENTER);
		
		mBottomPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
		
		this.setLayout(new BorderLayout());
		add(mTopPane, BorderLayout.NORTH);
		add(mEmailScrollPane, BorderLayout.CENTER);
		add(mBottomPane, BorderLayout.SOUTH);
		redoPreferredSize();
	}
		
	
	
	
	private void redoPreferredSize()
	{
		int w = Toolbox.getColWidth(mRootFrame);
		int c = 0;
		int h = 0;
		
		w-=50;
		
		h += mToPane.getPreferredSize().height;
		h += mDatePane.getPreferredSize().height;
		h += mFromPane.getPreferredSize().height;
		h += mSubjPane.getPreferredSize().height;
		
		h+=10;
		
		h += (c = getTextComponentPreferredHeight(mBodyText, w));
		mBodyText.setPreferredSize(new Dimension(w,c));		
		mMiddlePane.setPreferredSize(new Dimension(w, h));	
		revalidate();	
	}
	
	
	
	
	private void showEmailError()
	{
		if(mEmailIndex<mFileList.length)
		{
			mEmailIndex++;
			fillInEmailDetails();
		}
		else
		{
//			custom title, error icon
			JOptionPane.showMessageDialog(mRootFrame,
			    "Could not emails till the end index",
			    "Email Load Error",
			    JOptionPane.ERROR_MESSAGE);
			return;
		}
	}
	
	
	private void fillInEmailDetails()
	{
		String fullPath=mEmailDirectory.getAbsolutePath()+"\\"+mFileList[mEmailIndex];
		FileInputStream inp=null;
		
		try
		{
			inp = new FileInputStream(fullPath);
		}
		catch (FileNotFoundException e) {
			logger.warn("Could not read file:"+fullPath,e);
			showEmailError();
			return;
		}
		File emailF = new File(fullPath);
		String stringContent=null;
		try
		{
			stringContent=getFileContent(emailF);
		}
		catch(IOException e)
		{
			logger.warn("Could not read raw contents of file:"+fullPath, e);
			showEmailError();
			return;			
		}
		
		Properties props = new Properties();
		Session session = Session.getDefaultInstance(props, null);
		MimeMessage m = null;
		try
		{
			m = new MimeMessage(session, inp);
			m.setFileName(fullPath);
		}
		catch (MessagingException e1)
		{
			logger.warn("Could not create MimeMessage for file:"+fullPath,e1);
			showEmailError();
			return;	
		}
		
		String subject=null;
		String toFields=null;
		String fromField=null;
		Date date=null;
		String bodyText=null;
		String fileName=null;

		
		JLabel spacer;
		
				
		try
		{
			Address[] aList=m.getFrom();
			fromField="";
			int addressLen=0;
			if(aList!=null)
			{
				addressLen=aList.length;
				for(int j = 0; j < addressLen; j++)
				{
					fromField+=aList[j].toString().trim()+", ";
				}
			}
			if(fromField.length()>2)
				fromField=fromField.substring(0, fromField.length()-2);
			mFrom = new JTextArea(fromField);
			mFrom.setFont(GUIConstants.FIXED_FONT);
			mFrom.setLineWrap(true);
			mFrom.setWrapStyleWord(true);
			mFrom.addMouseListener(this);
			
			
			
			JLabel fromLabel = new JLabel("From: ");
			fromLabel.setFont(GUIConstants.FIXED_BOLD_FONT);
			mFromPane = new JPanel(new BorderLayout());
			mFromPane.add(fromLabel, BorderLayout.WEST);
			mFromPane.add(mFrom, BorderLayout.CENTER);
			mFromPane.setBackground(GUIConstants.RADAR_WHITE);
			
			
			date = m.getSentDate();
			mDate = new JTextArea(""+date);
			mDate.addMouseListener(this);
			JLabel dateLabel = new JLabel("Date: ");
			dateLabel.setFont(GUIConstants.FIXED_BOLD_FONT);
			mDatePane = new JPanel(new BorderLayout());
			mDatePane.add(dateLabel, BorderLayout.WEST);
			mDatePane.add(mDate, BorderLayout.CENTER);
			mDatePane.setBackground(GUIConstants.RADAR_WHITE);
			
						
			toFields="";
			aList=m.getRecipients(Message.RecipientType.TO);
			if(aList!=null)
			{	
				addressLen=aList.length;		
				for(int j = 0; j < addressLen; j++)
				{
					toFields+=aList[j].toString().trim()+", ";
				}
			}
			aList=m.getRecipients(Message.RecipientType.CC);
			if(aList!=null)
			{	
				addressLen=aList.length;		
				for(int j = 0; j < addressLen; j++)
				{
					toFields+=aList[j].toString().trim()+", ";
				}
			}
			aList=m.getRecipients(Message.RecipientType.BCC);
			if(aList!=null)
			{	
				addressLen=aList.length;		
				for(int j = 0; j < addressLen; j++)
				{
					toFields+=aList[j].toString().trim()+", ";
				}
			}			
			if(toFields.length()>2)
				toFields=toFields.substring(0, toFields.length()-2).trim();
			
			mTo = new JTextArea(toFields);
			mTo.setFont(GUIConstants.FIXED_FONT);
			mTo.setLineWrap(true);
			mTo.setWrapStyleWord(true);
			mTo.addMouseListener(this);
			JLabel toLabel = new JLabel("To: ");
			toLabel.setFont(GUIConstants.FIXED_BOLD_FONT);
			mToPane = new JPanel(new BorderLayout());
			mToPane.add(toLabel, BorderLayout.WEST);
			mToPane.add(mTo, BorderLayout.CENTER);
			mToPane.setBackground(GUIConstants.RADAR_WHITE);
					
			
			subject=m.getSubject();		
			mSubject = new JTextArea(subject);
			mSubject.setFont(GUIConstants.FIXED_FONT);
			mSubject.setLineWrap(true);
			mSubject.setWrapStyleWord(true);
			mSubject.addMouseListener(this);
			JLabel subjLabel = new JLabel("Subject: ");
			subjLabel.setFont(GUIConstants.FIXED_BOLD_FONT);
			mSubjPane = new JPanel(new BorderLayout());
			mSubjPane.add(subjLabel, BorderLayout.WEST);
			mSubjPane.add(mSubject, BorderLayout.CENTER);
			mSubjPane.setBackground(GUIConstants.RADAR_WHITE);

	
			
			
			bodyText=getBodyText(m, fullPath);
			// briefing area should be scrollable
			mBodyText = new JTextArea(bodyText);
			mBodyText.setFont(GUIConstants.FIXED_FONT);
			mBodyText.setLineWrap(true);
			mBodyText.setWrapStyleWord(true);
			mBodyText.addMouseListener(this);
			spacer = new JLabel();
			spacer.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
			fileName=m.getFileName();
			mFileName = fileName;
				
		}
		catch (MessagingException e)
		{
			logger.warn("Problem in getting email Field for file:"+fullPath, e);
			showEmailError();
			return;	
		}
		try
		{
			inp.close();
		}
		catch(IOException e)
		{
			logger.warn("Problem in closing file:"+fullPath,e);
			showEmailError();
			return;	
		}
		
		
		JComponent c[] = new JComponent[6];
		c[0] = mFromPane;
		c[1] = mDatePane;
		c[2] = mToPane;
		c[3] = mSubjPane;
		c[4] = spacer;
		c[5] = mBodyText;
		mMiddlePane = Toolbox.makeVerticalList(c, true, Toolbox.getColWidth(mRootFrame));
		mMiddlePane.setBackground(GUIConstants.RADAR_WHITE);
		mMiddlePane.setOpaque(true);
		mMiddlePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		
		mReplacedByWord.setText("");
		mWordToBeReplaced.setText("");
		mReplacementBox.setSelectedIndex(GUIConstants.SUGGESTION_TYPES.length-1);
		mCurrentSuggestion = -1;
		
		mSug = getSuggestions();
		mNumSuggestions = mSug.length;
		if(mNumSuggestions==0)
			mFinding.setText("No suggestions have been found.");
		else
			mFinding.setText("Some suggestions have been found.");
		mAccept.setEnabled(false);
		if(mNumSuggestions>0)
		{
			mShowNext.setEnabled(true);
			mCurrentSuggestion = -1;
		}
		mSeenButNotAcceptedSuggestionList = new ArrayList();
		mASuggestionSeenFlag=false;
	}
		
	public Suggestion[] getSuggestions()
	{	
		
		long totalIds = mDbc.totalIds("lookup");
		logger.trace("Total ids = " + totalIds);
		
		ArrayList suggestions = new ArrayList();
		JTextArea[] tempAreas = new JTextArea[5];
		tempAreas[0]=mFrom;
		tempAreas[1]=mDate;
		tempAreas[2]=mTo;
		tempAreas[3]=mSubject;
		tempAreas[4]=mBodyText;
		
		JTextArea currentArea;
		int index = -1;
		if(mCurrentSuggestion!=-1&&mNumSuggestions!=0)
		{
			currentArea=(JTextArea)mSug[mCurrentSuggestion].component;
			for(int i = 0; i < 5; i ++)
				if(currentArea==tempAreas[i])
				{
					index=i;
					break;
				}
		}
		else
			index=0;
		
		for(int j = index; j < 5; j ++)
		{
			
			String textInArea = tempAreas[j].getText();
			StringTokenizer st = new StringTokenizer(textInArea, " \t\n,./<>?;:'\"[]{}\\|~`!@#$%^&*()_+-=",true);
			int countTokens = st.countTokens();
			String previousToken=null;
			
			int runningIndex=0;
			int previousIndex=0;
			for(int k = 0; k < countTokens; k ++)
			{
				String token = st.nextToken();
				runningIndex+=token.length();
				token=token.trim();
				
				if(token==null||token.equals(""))
				{
					previousIndex=runningIndex;
					continue;
				}
				if(isDelimiter2(token))
				{
					previousIndex=runningIndex;
					continue;
				}
								
				token=token.toLowerCase();
				ArrayList matches = mDbc.getApproximateMatchingEntries("lookup", token);
				int size = matches.size();
				
				for(int l = 0; l < size/3; l ++)
				{
					String keyword = (String)matches.get(3*l);
					String replacement = (String)matches.get(3*l+1);
					int type = ((Integer)matches.get(3*l+2)).intValue();
					
					int endIndex=previousIndex+keyword.length();
					if(endIndex>textInArea.length())
						continue;
					String actualSubString=textInArea.toLowerCase().substring(previousIndex,endIndex);
					if(actualSubString.equals(keyword.toLowerCase()))
					{
						Suggestion s = new Suggestion(tempAreas[j],keyword,replacement, type, previousIndex);
						suggestions.add(s);
					}
				}
				previousToken=token.toLowerCase();
				previousIndex=runningIndex;
			}			
		}
		
		Suggestion[] sug = removeDuplicates(suggestions);
		Arrays.sort(sug, new SuggestionComparator(tempAreas));
		
		return sug;
	}
	
	public Suggestion[] removeDuplicates(ArrayList suggestions)
	{
		ArrayList finalSuggestions=new ArrayList();
		ArrayList check=new ArrayList();
		int size = suggestions.size();
		JTextArea[] tempAreas = new JTextArea[5];
		tempAreas[0]=mFrom;
		tempAreas[1]=mDate;
		tempAreas[2]=mTo;
		tempAreas[3]=mSubject;
		tempAreas[4]=mBodyText;
		logger.trace("Total Suggestions size="+size);
		
		for(int i = 0; i < size; i ++)
		{
			Suggestion s = (Suggestion)suggestions.get(i);
			int index=-1;
			for(int j = 0; j < 5; j ++)
				if(s.component==tempAreas[j])
				{
					index=j;
					break;
				}
			
			String label = ""+index+"_"+s.keyword.toLowerCase()+"_"+s.startIndex;
			
			if(mSeenButNotAcceptedSuggestionList.contains(label))
			{
				continue;
			}
			if(check.indexOf(label)==-1)
			{
				finalSuggestions.add(s);
				check.add(label);
			}
		}
		

		size = finalSuggestions.size();
		logger.trace("Revised Suggestions size="+size);
		Suggestion[] sug = new Suggestion[size];
		for(int i = 0; i < size; i ++)
		{
			sug[i]=(Suggestion)finalSuggestions.get(i);
		}
		
		
		return sug;
	}
	
	
	
	
	
	private ArrayList getSuggestionsForArea(JTextArea area, String keyword, String replacement, int type, int fromIndex)
	{
		int index = -1;
		String text = area.getText();
		ArrayList result = new ArrayList();
		while(true)
		{
			index = getIndex(text, keyword, fromIndex);
			if(index!=-1)
			{
				int newIndex=index+keyword.length();
				char ch;
				if(newIndex<text.length())
				{
					ch = text.charAt(newIndex);
				}
				else
					ch = ',';
				if(isDelimiter(ch))
				{	
					Suggestion s = new Suggestion(area, keyword, replacement, type, index);
					if(!result.contains(s))
						result.add(s);
				}	
				fromIndex+=index+keyword.length();
			}
			else
			{
				break;
			}
		}
		return result;
	}
	
	private boolean isDelimiter(char ch)
	{
		if((ch>='a'&&ch<='z')||(ch>='A'&&ch<='Z'))
			return false;
		else
			return true;
	}
	
	private boolean isDelimiter2(String ch)
	{
		String[] delims= {" ","\t","\n",".",",","/","<",">","?",";",":","'","\"","[","]","{","}","\\","|","~","`","!","@","#","$","%","^","&","*","(",")","_","+","-","="};
		Arrays.sort(delims);
		if(Arrays.binarySearch(delims,ch)>=0)
			return true;
		else
			return false;
	}
		
	private int getIndex(String string, String target, int fromIndex)
	{
		return string.toLowerCase().indexOf(target.toLowerCase(), fromIndex);
	}
	
	
	
	
	public static String getBodyText(MimeMessage m, String fullPath)
	{
		Object o=null;
		try
		{
			o = m.getContent();
		}
		catch(UnsupportedEncodingException e) {
			logger.warn("Content not supported for file:"+fullPath, e);
			System.exit(0);
		} catch (IOException e) {
			logger.warn("IOException in getting body for file:"+fullPath, e);
			System.exit(0);
		} catch (MessagingException e) {
			logger.warn("MessagingException in getting body for file:"+fullPath, e);
			System.exit(0);
		}
		
		String body="";			
		
		if(o instanceof String)
		{
			body+=(String)o+" ";
		}
		else if(o instanceof Multipart)
		{
			body+=getStringFromMultiPart((Multipart)o)+" ";
		}
		
			
		return body; 
	}
	
	
	public static String getFileContent(File f) throws IOException
	{
		FileInputStream fis = new FileInputStream(f);
		InputStreamReader irdr = new InputStreamReader(fis); // promote
		int size = (int) f.length(); // get the file size (in bytes)
		char[] data = new char[size]; // allocate char array of right size
		irdr.read( data, 0, size );   // read into char array
		irdr.close();
		String contents = new String(data);
		return contents;
	}

	public static String getStringFromMultiPart(Multipart mp)
	{
		String result="";
		
		try {
			int count = mp.getCount();
			for(int i = 0; i < count; i ++)
			{
				BodyPart b;
				try
				{
					b = mp.getBodyPart(i);
				}
				catch(Exception e) {
					logger.warn("Body part not supported, continuing");
					continue;
				}
				String disposition = b.getDisposition();
				if((disposition!=null)&&disposition.equals(Part.ATTACHMENT))
				{
					continue;
				}			
				Object o;
				try
				{
					o = b.getContent();
				}
				catch(Exception e)
				{
					logger.warn("Body part not supported, continuing");
					continue;
				}
				if(o instanceof String)
				{
					result+=(String)o+" ";
				}
				else if(o instanceof Multipart)
				{
					result+=getStringFromMultiPart((Multipart)o);
				}
				
				return result;
			}
		} catch (MessagingException e) {
			logger.warn("Problem in extracting string from Multipart, returning null",e);
			logger.warn("\n\n\n");
			return "";
		} 
		return "";
	}
	
	private void initializeData(Properties props, DBConnection dbc, AnonFrame rootFrame)
	{
		String directoryPath=props.getProperty(AnonConstants.DIRECTORY_PATH);
		mEmailDirectory = new File(directoryPath); 
		if(!mEmailDirectory.isDirectory())
		{
			logger.warn("Given directory:"+directoryPath+" is not a directory.");
			System.exit(0);
		}
		
		FilenameFilter filter =  new FilenameFilter()
		{
			    public boolean accept(File dir, String name) {
			        return (name.endsWith(".eml"));
			    }
		};
		
		mFileList=mEmailDirectory.list(filter);	
		mEmailIndex=0;
		String outputPath=props.getProperty(AnonConstants.OUTPUT_PATH);
		File f = new File(outputPath);
		if(!f.isDirectory())
		{
			logger.warn("Given directory:"+outputPath+" is not a directory.");
			System.exit(0);
		}
		
		mOutputPath=f.getAbsolutePath();
	}
	
	
	public boolean getConfirmation()
	{
		if(!mSubmitButton.isEnabled())
			return true;
		Object[] options = {"Yes",
                "No"};
		int n = JOptionPane.showOptionDialog(mRootFrame, "Would you like to save the email?",
											"Confirmation",
											JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[1]);
		
		if(n==0)
			return false;
		else
			return true;
										
	}
	
	public void actionPerformed(ActionEvent arg0)
	{
		if(arg0.getSource().equals(mNextButton))
		{
			if(mEmailIndex<(mFileList.length-1))
			{
				if(!getConfirmation())
				{
					submitEmail();
				}
					
				mEmailIndex++;
				mEmailNum.setText(""+(mEmailIndex+1));
				mMiddlePane = new JPanel();
				fillInEmailDetails();
				this.remove(mEmailScrollPane);
				mEmailScrollPane = new JScrollPane(mMiddlePane,
						JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
						JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
				this.add(mEmailScrollPane, BorderLayout.CENTER);
				mNumberLabel.setText("Email "+(mEmailIndex+1)+" of "+mFileList.length+" "+mFileList[mEmailIndex]);
				mSubmitButton.setEnabled(true);
				redoPreferredSize();
			}
			else
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "Last email reached",
					    "Email Load Error",
					    JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(arg0.getSource().equals(mPreviousButton))
		{
			
			if(mEmailIndex>0)
			{
				if(!getConfirmation())
				{
					submitEmail();
				}
				mEmailIndex--;
				mEmailNum.setText(""+(mEmailIndex+1));
				mMiddlePane = new JPanel();
				fillInEmailDetails();
				this.remove(mEmailScrollPane);
				mEmailScrollPane = new JScrollPane(mMiddlePane,
						JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
						JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
				this.add(mEmailScrollPane, BorderLayout.CENTER);
				mNumberLabel.setText("Email "+(mEmailIndex+1)+" of "+mFileList.length+" "+mFileList[mEmailIndex]);
				mSubmitButton.setEnabled(true);
				redoPreferredSize();
			}
			else
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "First email reached",
					    "Email Load Error",
					    JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(arg0.getSource().equals(mPrev10Button))
		{
			if(mEmailIndex-10>=0)
			{
				if(!getConfirmation())
				{
					submitEmail();
				}
				mEmailIndex-=10;
				mEmailNum.setText(""+(mEmailIndex+1));
				mMiddlePane = new JPanel();
				fillInEmailDetails();
				this.remove(mEmailScrollPane);
				mEmailScrollPane = new JScrollPane(mMiddlePane,
						JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
						JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
				this.add(mEmailScrollPane, BorderLayout.CENTER);
				mNumberLabel.setText("Email "+(mEmailIndex+1)+" of "+mFileList.length+" "+mFileList[mEmailIndex]);
				mSubmitButton.setEnabled(true);
				redoPreferredSize();
			}
			else
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "Can't go back that much, first email reached",
					    "Email Load Error",
					    JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(arg0.getSource().equals(mNext10Button))
		{
			if(mEmailIndex+10<mFileList.length)
			{
				if(!getConfirmation())
				{
					submitEmail();
				}
				mEmailIndex+=10;
				mEmailNum.setText(""+(mEmailIndex+1));
				mMiddlePane = new JPanel();
				fillInEmailDetails();
				this.remove(mEmailScrollPane);
				mEmailScrollPane = new JScrollPane(mMiddlePane,
						JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
						JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
				this.add(mEmailScrollPane, BorderLayout.CENTER);
				mNumberLabel.setText("Email "+(mEmailIndex+1)+" of "+mFileList.length+" "+mFileList[mEmailIndex]);
				mSubmitButton.setEnabled(true);
				redoPreferredSize();
			}
			else
			{
				JOptionPane.showMessageDialog(mRootFrame,
					    "Can't go back that much, first email reached",
					    "Email Load Error",
					    JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(arg0.getSource().equals(mShowNext))
		{
			handleNextCase();

		}
		else if(arg0.getSource().equals(mAccept))
		{
			handleAcceptCase();
		}
		else if(arg0.getSource().equals(mReplacementBox))
		{
			handleSelectionOfType();
		}
		else if(arg0.getSource().equals(mOkButton))
		{
			handleReplacement();
		}
		else if(arg0.getSource().equals(mWordToBeReplaced))
		{
			if(!mWordToBeReplaced.equals(mOldText))
			{
				mOkButton.setEnabled(true);
			}
		}
		else if(arg0.getSource().equals(mSubmitButton))
		{	
			submitEmail();
		}
		else if(arg0.getSource().equals(mGoTo))
		{
			gotoAction();
		}
	}
	
	public void gotoAction()
	{
		String text = mEmailNum.getText();
		if(text==null||text.equals(""))
			return;
		int val;
		try
		{
			val = new Integer(text.trim()).intValue();
		}
		catch(Exception e)
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Wrong Email Number. Enter an Integer",
				    "Email Number Error",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		if(val >=1 && val <= mFileList.length)
		{
			mEmailIndex=val-1;
			mEmailNum.setText(""+val);
			mMiddlePane = new JPanel();
			fillInEmailDetails();
			this.remove(mEmailScrollPane);
			mEmailScrollPane = new JScrollPane(mMiddlePane,
					JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
					JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			this.add(mEmailScrollPane, BorderLayout.CENTER);
			mNumberLabel.setText("Email "+(mEmailIndex+1)+" of "+mFileList.length+" "+mFileList[mEmailIndex]);
			mSubmitButton.setEnabled(true);
			redoPreferredSize();
		}
		else
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Index entered not in range.",
				    "Email Load Error",
				    JOptionPane.ERROR_MESSAGE);
		}
		
	}
	
	public void submitEmail()
	{
		try {
			String fileName = mFileList[mEmailIndex].substring(0,  mFileList[mEmailIndex].length()-3)+"txt";
			BufferedWriter bWriter = new BufferedWriter(new FileWriter(mOutputPath+"\\"+fileName));
			StringBuffer sb = new StringBuffer("");
			sb.append("From:");
			sb.append(mFrom.getText()+"\n");
			sb.append("Date:");
			sb.append(mDate.getText()+"\n");
			sb.append("To:");
			sb.append(mTo.getText()+"\n");
			sb.append("Subject:");
			sb.append(mSubject.getText()+"\n\n");
			sb.append(mBodyText.getText());
			
			bWriter.write(sb.toString());
			bWriter.close();
			mSubmitButton.setEnabled(false);
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.warn("Problem in writing file:"+mFileList[mEmailIndex],e);
		}
			
	}

	
	public void handleReplacement()
	{
		String keyWord = mWordToBeReplaced.getText().trim().toLowerCase();
		String replacement = mReplacedByWord.getText().trim();
		
		if(keyWord==null || keyWord.equals(""))
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Word to be Replaced is empty",
				    "Null Selection",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		if(replacement==null || replacement.equals(""))
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Replacement word is empty",
				    "Null Selection",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
			
		int type = mReplacementBox.getSelectedIndex();
		
		boolean res = mDbc.insertReplacement("lookup", keyWord, replacement, type);
		if(!res)
		{
			JOptionPane.showMessageDialog(mRootFrame,
				    "Could not insert into database",
				    "Database error",
				    JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		JTextArea area = (JTextArea)mActiveArea;
		Caret caret = area.getCaret();
		int start = caret.getMark();
		int end = caret.getDot();
		if (end < start) {
			int swap = end;
			end = start;
			start = swap;
		}
		
		String prefix = area.getText().substring(0, start);
		String suffix = area.getText().substring(end);
		
		String revised = prefix+replacement+suffix;
		area.setText(revised);		
		area.getCaret().setDot(prefix.length());
		Suggestion s = new Suggestion(area,null,replacement,-1,prefix.length());
		moveViewPort(area,s,false);
		
		
		mOldText = replacement;
		mOkButton.setEnabled(false);
		mSug=getSuggestions();
		mNumSuggestions = mSug.length;
		if(mNumSuggestions==0)
			mFinding.setText("No more suggestions have been found.");
		else
			mFinding.setText("Some more suggestions have been found.");
		mAccept.setEnabled(false);
		mShowNext.setEnabled(false);
		if(mNumSuggestions>0)
		{
			mShowNext.setEnabled(true);
			mCurrentSuggestion = -1;
		}		
		
	}
	
	
	public void handleSelectionOfType()
	{
		int selectedIndex = mReplacementBox.getSelectedIndex();
		String type = GUIConstants.SUGGESTION_TYPES[selectedIndex];
		
		String replacement;
		
		String maxReplacement = mDbc.getMaxIndex("lookup", selectedIndex);
		
		if(type.equalsIgnoreCase("email"))
		{
			if(maxReplacement==null)
				replacement="email_0@abc.com";
			else
			{	StringTokenizer st = new StringTokenizer(maxReplacement, "@");
				String prefix = st.nextToken();
				int lastIndex= prefix.lastIndexOf('_');
				int ind = (new Integer(prefix.substring(lastIndex+1))).intValue()+1;			
				replacement = "email_"+ind+"@abc.com";
			}
		}
		else
		{
			
			
			int ind;
			if(maxReplacement!=null)
			{
				int lastIndex= maxReplacement.lastIndexOf('_');
				ind = (new Integer(maxReplacement.substring(lastIndex+1))).intValue()+1;
			}
			else
				ind = 0;
			StringTokenizer st = new StringTokenizer(type);
			replacement="";
			while(st.hasMoreTokens())
			{
				replacement+=st.nextToken().toLowerCase()+"_";
			}
			replacement+=""+ind;
		}
		
		mReplacedByWord.setText(replacement);
		
	}
	
	public void moveViewPort(JTextArea area, Suggestion s, boolean flag)
	{
		String text = area.getText();
		int len=0;
		if(!flag)
			len=s.replacement.length();
		else
			len=s.keyword.length();
		
		String subString=text.substring(0,s.startIndex+len);
		JTextArea tempArea = new JTextArea(subString+"\n\n\n");
		int height=0;
		height = mEmailScrollPane.getHeight();
		int h = 0;
		h += mToPane.getPreferredSize().height;
		h += mDatePane.getPreferredSize().height;
		h += mFromPane.getPreferredSize().height;
		h += mSubjPane.getPreferredSize().height;
		
		h+=10;
				
		int w = Toolbox.getColWidth(mRootFrame);	
		h += getTextComponentPreferredHeight(tempArea, w);
		
				
		int caretPosition=s.startIndex+200;
		if(caretPosition>=text.length())
			caretPosition=text.length()-1;
		area.setCaretPosition(caretPosition);
		
//		if(h<=height)
//		{
//			Rectangle r = new Rectangle(0,0,mRootFrame.getWidth(), h);
//			mMiddlePane.scrollRectToVisible(r);
//		}
//		else
//		{
//			System.out.println("y start="+(h-height)+" h="+h+" height="+height+" height of bodyText="+getTextComponentPreferredHeight(mBodyText,w));
//			Rectangle r = new Rectangle(0,h-height,mRootFrame.getWidth(), h);
//			mMiddlePane.scrollRectToVisible(r);
//		}
	}
	
	public void handleAcceptCase()
	{
		Suggestion s = mSug[mCurrentSuggestion];
		JTextArea area = (JTextArea)s.component;
		String text = area.getText();
		int startIndex = s.startIndex;
		int len = s.keyword.length();
		
		String prefix = text.substring(0, startIndex);
		String suffix = text.substring(startIndex+len);
		String finalString = prefix+mReplacedByWord.getText()+suffix;
		area.setText(finalString);
		mAccept.setEnabled(false);
		
		//area.getCaret().setDot(prefix.length());
		
		moveViewPort(area,s,false);
		
		mSug = getSuggestions();
		mNumSuggestions = mSug.length;
		if(mNumSuggestions==0)
			mFinding.setText("No more suggestions have been found.");
		else
			mFinding.setText("Some more suggestions have been found.");
		mAccept.setEnabled(false);
		if(mNumSuggestions>0)
		{
			mShowNext.setEnabled(true);
			mCurrentSuggestion = -1;
		}
		else
		{
			mShowNext.setEnabled(false);
		}
		mASuggestionSeenFlag=false;
	}
	
	public void removeAllHighlights()
	{
		removeHighlights(mTo);
		removeHighlights(mFrom);
		removeHighlights(mSubject);
		removeHighlights(mDate);
		removeHighlights(mBodyText);
	}
	
	public String generateLabel(Suggestion s)
	{
		JTextArea[] tempAreas = new JTextArea[5];
		tempAreas[0]=mFrom;
		tempAreas[1]=mDate;
		tempAreas[2]=mTo;
		tempAreas[3]=mSubject;
		tempAreas[4]=mBodyText;
		
		int index=-1;
		for(int j = 0; j < 5; j ++)
			if(s.component==tempAreas[j])
			{
				index=j;
				break;
			}
		
		String label=""+index+"_"+s.keyword.toLowerCase()+"_"+s.startIndex;
		return label;
	}
	
	
	public void handleNextCase()
	{
		
		if(mASuggestionSeenFlag)
		{
			String label = generateLabel(mPreviousSuggestion);
			mSeenButNotAcceptedSuggestionList.add(label);
		}
		removeAllHighlights();
		
		mCurrentSuggestion++;
		
		System.out.println("Current Suggestion no:"+mCurrentSuggestion+" Total number of suggestions:"+mNumSuggestions);
		Suggestion s = mSug[mCurrentSuggestion];
		JTextArea area = (JTextArea)s.component;
		
		String toBeReplaced;
		try
		{
			toBeReplaced = area.getText(s.startIndex, s.keyword.length());
		}
		catch(Exception e)
		{
			logger.warn("Problem in getting the replacement word",e);
			toBeReplaced = s.keyword;
		}

		
		mWordToBeReplaced.setText(toBeReplaced);
		int type = s.type;
		mReplacementBox.setSelectedIndex(type);
		mReplacedByWord.setText(s.replacement);
		highlight(area, s.startIndex, s.keyword.length());
		
		moveViewPort(area,s,true);
		
		
		if(mCurrentSuggestion>=0)
		{
			mAccept.setEnabled(true);
		}
		
		if(mCurrentSuggestion==mNumSuggestions-1)
		{
			mShowNext.setEnabled(false);
		}		
		mASuggestionSeenFlag=true;
		mPreviousSuggestion=s;
			
	}
	
	
	public int getTextComponentPreferredHeight(JTextComponent aText,
			int aWidth) {
		/*
		 aText.setSize(aWidth, Integer.MAX_VALUE);
		 return aText.getPreferredSize().height;
		 */
		//Insets insets = aText.getMargin();
		View rootView = aText.getUI().getRootView(aText);
		rootView.setSize(aWidth, Integer.MAX_VALUE);
		return (int) rootView.getPreferredSpan(View.Y_AXIS);
	}
	

	public String getSelectedText(JTextArea area)
	{
		String result="";
		Caret caret = area.getCaret();
		int start = caret.getMark();
		int end = caret.getDot();
		if (end == start)
			return result;
		else if (end < start) {
			int swap = end;
			end = start;
			start = swap;
		}

		String text = area.getText();
		try
		{
			result = text.substring(start, end);
		}
		catch(Exception e)
		{
			logger.warn("Problem in extracting selected text", e);
		}
		
		return result;
	}
	

	public void mouseClicked(MouseEvent arg0) {
		
	}



	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}



	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	
	public void mousePressed(MouseEvent arg0) {
		Object src = arg0.getSource();
		mSelectionActive = true;
		mActiveArea = src;
		removeAllHighlights();
		mSug = getSuggestions();
		mNumSuggestions = mSug.length;
		if(mNumSuggestions==0)
			mFinding.setText("No more suggestions have been found.");
		else
			mFinding.setText("Some more suggestions have been found.");
		mAccept.setEnabled(false);
		if(mNumSuggestions>0)
		{
			mShowNext.setEnabled(true);
			mCurrentSuggestion = -1;
		}
		else
		{
			mShowNext.setEnabled(false);
		}
		mAccept.setEnabled(false);
	}
	
	
	
	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
		if(!mSelectionActive)
		{
			mSelectionActive=false;
			return;
		}
		String result = getSelectedText((JTextArea)mActiveArea);
		mWordToBeReplaced.setText(result);
		mReplacementBox.setSelectedIndex(GUIConstants.SUGGESTION_TYPES.length-1);
		mReplacedByWord.setText("");
		mOkButton.setEnabled(true);
		handleSelectionOfType();
		
	}
	
	// Creates highlights around all occurrences of pattern in textComp
    public void highlight(JTextComponent textComp, int startIndex, int length) {
        // First remove all old highlights
        removeHighlights(textComp);
    
        try {
            Highlighter hilite = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            hilite.addHighlight(startIndex, startIndex+length, mMyHighlightPainter);
        } catch (BadLocationException e) {
        	logger.warn("Problem in higlight", e);
        }
    }
    
    
    
    
    // Removes only our private highlights
    public void removeHighlights(JTextComponent textComp) {
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
    
        for (int i=0; i<hilites.length; i++) {
            if (hilites[i].getPainter() instanceof MyHighlightPainter) {
                hilite.removeHighlight(hilites[i]);
            }
        }
    }
	
}

//A private subclass of the default highlight painter
class MyHighlightPainter extends DefaultHighlighter.DefaultHighlightPainter {
    public MyHighlightPainter(Color color) {
        super(color);
    }
}


class SuggestionComparator implements Comparator
{
	
	JTextArea[] mAreas;
	public SuggestionComparator(JTextArea[] areas)
	{
		mAreas = areas;
	}
	public int compare(Object arg0, Object arg1)
	{
		Suggestion one = (Suggestion)arg0;
		Suggestion two = (Suggestion)arg1;
		
		int index1=-1;
		int index2=-1;
		
		JTextArea currentArea=(JTextArea)one.component;
		for(int i = 0; i < 5; i ++)
			if(currentArea==mAreas[i])
			{
				index1=i;
				break;
			}
		
		currentArea=(JTextArea)two.component;
		for(int i = 0; i < 5; i ++)
			if(currentArea==mAreas[i])
			{
				index2=i;
				break;
			}
		
		if(index1<index2)
		{
			return -1;
		}
		else if(index1 > index2)
		{
			return 1;
		}
		
		
		if(one.startIndex<two.startIndex)
			return -1;
		else if(one.startIndex>two.startIndex)
			return 1;
		else 
			return 0;
		
		
	}
	
}