package email.anonymize.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.swing.JFrame;
import javax.swing.UIManager;

import org.apache.log4j.Logger;

import email.database.DBConnection;



public class AnonFrame extends JFrame implements ActionListener, WindowListener
{
	static Logger logger=null;
	
	static
	{
		logger = Logger.getLogger(AnonFrame.class);
	}
	
	private DBConnection mDbc;
	private Properties mProps;
	
	public AnonFrame(Properties props)
	{
		this.setSize(800, 600);
		this.setTitle("Anonymization Tool 1.0");
		this.setIconImage(GUIConstants.RADAR_ICON.getImage());
		
		mProps = props;
		mDbc = new DBConnection();
		
		centerOnScreen();
		AnonPanel sp = new AnonPanel(mProps, mDbc, this);
		getContentPane().add(sp);		
		
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		addWindowListener(this);
		this.setVisible(true);
	}
			
	
	public void centerOnScreen()
	{
		 Dimension d = null; // size of what we're positioning against
         Point     p = null;
         
         try
         {
        	 d = Toolkit.getDefaultToolkit().getScreenSize();        
        	 p = new Point();
         }
         catch(Exception e)
         {
        	 logger.warn("Could not center on screen",e);
        	 return;
         }        

         double centreX = p.getX() + d.getWidth()  / 2;
         double centreY = p.getY() + d.getHeight() / 2;

         this.getSize(d);
         p.setLocation(centreX - d.getWidth() / 2,
                       centreY - d.getHeight() / 2);
         if (p.getX() < 0)
           p.setLocation(0, p.getY());

         if (p.getY() < 0)
           p.setLocation(p.getX(), 0);

         this.setLocation(p);
	}
	
	
	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowActivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowClosed(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	
	public void windowDeactivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowDeiconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowIconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowOpened(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	
	public void windowClosing(WindowEvent arg0)
	{
		exit();
	}
	
	public void exit()
	{
		//TODO Auto-generated method stub
		mDbc.closeConnection();
		logger.trace("Closed DB Connection");
		this.setVisible(false);
		this.dispose();
		System.exit(0);
	}
	
	private static Properties getProperties(String propertiesFile)
	{
		Properties properties = new Properties();
		try {
	        properties.load(new FileInputStream(propertiesFile));
	    }
		catch (IOException e)
	    {
			logger.warn("Could not load properties file:"+propertiesFile,e);
			System.exit(0);
	    }			
		return properties;
	}
	
	private static boolean isDelimiter2(String ch)
	{
		String[] delims= {" ","\t","\n",".",",","/","<",">","?",";",":","'","\"","[","]","{","}","\\","|","~","`","!","@","#","$","%","^","&","*","(",")","_","+","-","="};
		Arrays.sort(delims);
		if(Arrays.binarySearch(delims,ch)>=0)
			return true;
		else
			return false;
	}
	
	public static void main(String[] args)
	{
		Properties props = getProperties("hard.disk.emails.properties");
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			logger.warn("Could not set look and feel",e);
		}
		AnonFrame sf = new AnonFrame(props);
	}
	
	
	
}