architecture THREE of STACK is
  type STATE_TYPE is (EMPTY, HALF, FULL);
  signal STATE: STATE_TYPE;
begin
  PUSH_RDY <= STATE /= FULL;
  POP_RDY <= STATE /= EMPTY;
  CONTROL: process
  begin
    if (STATE = EMPTY) then
      if PUSH then
        STATE <= HALF;
        wait until not PUSH;
      else
        wait until PUSH;
      end if;
    elsif (STATE = HALF) then
      if PUSH then
        STATE <= FULL;
        wait until not PUSH;
      elsif POP then
        STATE <= EMPTY;
        wait until not POP;
      else
        wait until PUSH or POP;
      end if;
    else
      if POP then
        STATE <= HALF;
        wait until not POP;
      else
        wait until POP;
      end if;
    end if;
  end process CONTROL;
end THREE;
