/**CHeaderFile*****************************************************************

  FileName    [ timer.h ]

  PackageName [ timer ]

  Synopsis    [ Simple timer library ]

  Description [ This library provides a simple set of functions interface 
  to manage timers. A timer can be created or disposed with the routines
  Timer_New and Timer_Dispose.
  A timer keeps track of user and system time spent by the client
  program.
  A timer might be in three steps: reset, stopped and started. The initial 
  state is reset. 
  When a timer is rest, the time counters are set to 0, when it is stopped,
  it stop incrementing as time passes, and when it is started it resumes
  incrementing. When a timer is in the reset state, it can be started 
  with the function Timer_Start. When a timer is started, it can be reset 
  or stopped with the functions Timer_Reset and Timer_Stop. When a timer 
  is stopped, it can be re-started or reset with the functions Timer_Start 
  and Timer_Reset. All other actions have no effect.
  The time counters held by a started or stopped timer can be printed with
  the function Timer_Display. ]

  Author      [ David Deharbe ]

  Revision    [$Id: $]

  Copyright   [ Carnegie Mellon University - 1996 ]

******************************************************************************/

#ifndef _TIMER
#define _TIMER

#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef struct timerCell_t_ * timer;

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern timer timer_New(void);
extern void timer_Dispose(timer t);
extern void timer_Reset(timer t);
extern void timer_Start(timer t);
extern void timer_Stop(timer t);
extern void timer_Display(FILE * outstream, char * message, timer t);

/**AutomaticEnd***************************************************************/

#endif /* _TIMER */

