/** CHeaderFile ********************************************************

  FileName    [ modelInt.h ]

  PackageName [ model ]

  Synopsis    [ Required ]

  Description [ Optional ]

  SeeAlso     [ ]

  Author      [ David Deharbe. ]

  Copyright   [ Copyright (c) 1996, Carnegie Mellon University.
                All right reserved. ]

  Revision    [ $Id: modelInt.h,v 1.1 1996/05/14 15:00:49 david Exp david $ ]

***********************************************************************/
#ifndef _MODELINT
#define _MODELINT

#include "model.h"

/*--------------------------------------------------------------------*/
/* Constant declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

typedef struct ModelVariableStruct_t_ {
  cvn declaration; /* the address of the variable declaration */
  vbdd coding;       /* the vector of coding BDD propositions */
  vbdd init_coding;  /* initial value of the propositions */
  vbdd transition;   /* transition functions of the propositions */
} ModelVariableStruct_t;

typedef struct ModelDriverStruct_t_ {
  cvn process;   /* the driving process */
  vbdd transition; /* the corresponding transition functions */
} ModelDriverStruct_t;

typedef struct ModelSignalStruct_t_ {
  cvn declaration; /* the address of the signal declaration */
  vbdd coding;       /* the vector of coding BDD propositions 
                        (expressive value) */
  vbdd init_coding;  /* initial value of the coding propositions */
  int nb_drivers;    /* drivers */
  int max_nb_drivers;
  ModelDriverStruct_t * drivers;
  int previous;      /* index of the variable coding the previous value */
  bdd event;         /* bdd representing the event condition */
} ModelSignalStruct_t;

typedef struct ModelConfigStruct_t_ {
  bdd code; /* characteristic function of configuration */
  cvn * object_valuations;/* valuations of VHDL objects (even:object,odd:value) */
  int nbvaluations;/* number of pairs object, value in the previous field */
} ModelConfigStruct_t;

typedef struct  ModelPathStruct_t_ {
  bdd loopstart;
  bdd * transitions;
  int nbtransitions;
  int nbmaxtransitions;
} ModelPathStruct_t;

typedef struct ModelCheckComputation_t_ {
  bdd solution;
  pointer info;
} ModelCheckComputation_t;

typedef struct ModelStruct_t_ {
  bdd_manager bddm;         /* the BDD manager */
  cvn design; 
  unsigned nb_propositions;
  int nb_signals;
  int max_nb_signals;
  ModelSignalStruct_t * signals;
  int nb_variables;
  int max_nb_variables;
  ModelVariableStruct_t * variables;
  int max_nb_names;
  char ** names;
  bdd stable;
  bdd init;
  int still_inputs;
  ant_manager ant;
  img_manager img;
  struct {
    int done ;
    bdd reachable ;
    bdd stable;
    bdd intermediate;
    vbdd frontiers ;
  } reachability_analysis ;
  vbdd vars;
  vbdd state_vars;
  vbdd input_vars;
  /* Fields to handle fairness */
  bdd fair_states; /* null if not computed */
  cvn fairness_constraints;
  /* Fields to handle input invariants */
  bdd invariant;
} ModelStruct_t;

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/
rec_mgr ModelConfigRecMgr;
rec_mgr ModelPathRecMgr;
rec_mgr ModelCheckRecMgr;

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern cvn _ComputeObjectValue(bdd_manager bddm, cvn decl, vbdd coding, bdd c);
extern void _DisplayObjectValues(FILE * outstream, cvn * ov, int nb_ov);
extern int _SelectAssoc(Model m, int selector);
extern void _VHDLDisplayValues(FILE * outstream, cvn * ov, int nb_ov);

/**AutomaticEnd********************************************************/

#endif /* _MODELINT */
