/** CHeaderFile ********************************************************

  FileName    [ model.h ]

  PackageName [ model ]

  Synopsis    [ BDD-based modeling of VHDL architectures ]

  Description [ This header file provides a procedural interface to
  the package model. ]

  SeeAlso     [ cvc(1) ]

  Author      [ David Deharbe. ]

  Copyright   [ Copyright (c) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Id$ ]

***********************************************************************/
#ifndef _MODEL
#define _MODEL

#include <bdd_misc.h>
#include <bdd_up.h>
#include <ctl.h>
#include <cv.h>
#include <label.h>
#include <img.h>
#include <ant.h>
#include <vbdd.h>
#include <vbdd_code.h>
#include <vbdd_print.h>
#include <vbdd_relat.h>

/*--------------------------------------------------------------------*/
/* Constant declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/
typedef bdd (* terminal_check_fn) (pointer, pointer);
typedef struct ModelStruct_t_ * Model;
typedef struct ModelCheckComputation_t_ * ModelCheckComputation;
typedef struct ModelConfigStruct_t_ * ModelConfig;
typedef struct ModelPathStruct_t_ * ModelPath;

/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/
#define MODEL_INPUTMASK 0x1
#define MODEL_STATEMASK 0x2
#define MODEL_ALLMASK (MODEL_INPUTMASK | MODEL_STATEMASK)

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern void model_Init(void);
extern void model_Final(void);
extern void model_Check(Model m, FILE * outstream, ctl_term t, terminal_check_fn fn, pointer env);
extern ModelCheckComputation model_CheckNot(Model m, FILE * outstream, bdd f);
extern ModelCheckComputation model_CheckAnd(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckOr(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckImplies(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckNand(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckNor(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckXor(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckXnor(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckEX(Model m, FILE * outstream, bdd f);
extern ModelCheckComputation model_CheckAX(Model m, FILE * outstream, bdd f);
extern ModelCheckComputation model_CheckEF(Model m, FILE * outstream, bdd f);
extern ModelCheckComputation model_CheckAF(Model m, FILE * outstream, bdd f);
extern ModelCheckComputation model_CheckEG(Model m, FILE * outstream, bdd f);
extern ModelCheckComputation model_CheckAG(Model m, FILE * outstream, bdd f);
extern ModelCheckComputation model_CheckEU(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckAU(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckEW(Model m, FILE * outstream, bdd f, bdd g);
extern ModelCheckComputation model_CheckAW(Model m, FILE * outstream, bdd f, bdd g);
extern void model_CheckDeltaConvergence(Model m, FILE * outstream);
extern ModelCheckComputation model_CheckAllocComputation(bdd solution, pointer info);
extern void model_CheckFreeComputation(ModelCheckComputation data);
extern bdd model_CheckQSolution(ModelCheckComputation result);
extern pointer model_CheckQInfo(ModelCheckComputation result);
extern void model_ExplicitDisplaySet(Model m, FILE * outstream, bdd set, int selector);
extern bdd model_ExplicitComputeCondition(Model m, bdd c, int selector);
extern ModelConfig model_ExplicitNewConfig(Model m, bdd c, int selector);
extern void model_ExplicitFreeConfig(ModelConfig c);
extern void model_ExplicitDisplayConfig(FILE * outstream, ModelConfig s);
extern bdd model_ExplicitQCode(ModelConfig c);
extern ModelPath model_ExplicitNewPath(void);
extern void model_ExplicitFreePath(ModelPath t);
extern ModelPath model_ExplicitLoopPath(ModelPath p, bdd c);
extern void model_ExplicitAppendTransitionToPath(ModelPath p, bdd c);
extern void model_ExplicitAppendPaths(ModelPath path, ModelPath suffix);
extern bdd model_ExplicitQPathDestination(ModelPath t);
extern void model_ExplicitDisplayPath(Model m, FILE * outstream, ModelPath t);
extern void model_ExplicitDisplayVHDL(Model m, FILE * outstream, ModelPath t);
extern long model_MeasureSizeTransition(Model m);
extern double model_MeasureNbStates(Model m);
extern double model_MeasureSetCardinality(Model m, bdd set);
extern double model_MeasureNbReachableStates(Model m);
extern double model_MeasureNbStableStates(Model m);
extern long model_ModifyReduceTransition(Model m, FILE * outstream, bdd f);
extern void model_ModifyReduceSCC(Model m);
extern void model_ModifyStillInputs(Model m);
extern bdd model_ReachabilityStepForward(Model m, bdd set);
extern bdd model_ReachabilityStepBackward(Model m, bdd set);
extern vbdd model_ReachabilityQFrontiers(Model m);
extern bdd model_ReachabilityQAll(Model m);
extern bdd model_ReachabilityQStable(Model m);
extern bdd model_ReachabilityQIntermediate(Model m);
extern bdd model_ReachabilityCompute(Model m, FILE * outstream);
extern Model model_RepresentationNew(bdd_manager bddm, cvn design);
extern void model_RepresentationFreeModel(Model m);
extern int model_RepresentationAddVariable(Model m, cvn decl, vbdd coding, vbdd init_coding, bdd valid);
extern int model_RepresentationAddSignal(Model m, cvn decl, vbdd coding, vbdd init_coding, bdd valid);
extern bdd model_RepresentationAddStable(Model m, bdd st);
extern void model_RepresentationAddDriver(Model m, cvn decl, cvn stm, vbdd trans);
extern void model_RepresentationAddPrevious(Model m, cvn decl, cvn prev, vbdd coding, bdd valid);
extern void model_RepresentationAddTransition(Model m, cvn decl, vbdd trans);
extern vbdd model_RepresentationQCoding(Model m, cvn decl);
extern bdd model_RepresentationQSignalEvent(Model m, cvn decl);
extern bdd model_RepresentationQInitialState(Model m);
extern int model_RepresentationSignalHasPrevious(Model m, cvn s);
extern int model_RepresentationBuildTransition(Model m, bdd * specification_support, int tradeoff);
extern void model_RepresentationSetFair(Model m, FILE * outstream, cvn constraints);
extern void model_RepresentationSetInvariant(Model m, bdd invariant);
extern void model_RepresentationAddInvariant(Model m, bdd invariant);
extern void model_RepresentationFlush(Model m);
extern ModelPath model_WitnessConfig(Model m, bdd config);
extern ModelPath model_WitnessEX(Model m, bdd s, bdd f);
extern ModelPath model_WitnessEG(Model m, FILE * outstream, bdd s, bdd f, bdd EGf, vbdd * approximations);
extern ModelPath model_WitnessEU(Model m, bdd s, bdd f, bdd g, vbdd frontiers);

/**AutomaticEnd********************************************************/

#endif /* _MODEL */
