/** CHeaderFile ********************************************************

  FileName    [ label.h ]

  PackageName [ label ]

  Synopsis    [ a label management package ]

  Description [ This library provides a rudimentary management for
  providing unique labels to client applications. If an application
  needs labels, it first create a label manager with the routine
  label_NewManager(). Labels can thereafter be obtained or freed
  by invoking the functions label_NewRec(), and label_FreeRec(). 
  Calling the function label_FreeManager() frees all the labels
  associated to a manager.
  A label is a null terminated array of characters. It has two
  parts: a prefix that is common to all labels associated to
  a given manager, and a suffix that is composed of digits.

  This package uses the mem(3) library: when linking, use -llabel -lmem. ]

  Author      [ David Deharbe. ]

  Copyright   [ Copyright (c) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Id$ ]

***********************************************************************/
#ifndef _LABEL
#define _LABEL

/*--------------------------------------------------------------------*/
/* Constant declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/
typedef struct labelManagerStruct_t_ * label_manager;

/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern label_manager label_NewManager(char * prefix);
extern void label_FreeManager(label_manager mgr);
extern char * label_NewLabel(label_manager mgr);
extern void label_FreeLabel(label_manager mgr, char * label);

/**AutomaticEnd********************************************************/

#endif /* _LABEL */
