/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    graph.h                                                   */
/*                                                              */
/* Description:                                                 */
/*    Declarations of data types and routines that represent and*/
/*    manipulate graph- and tree-like data structures.          */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */

#if !defined(_GRAPHH)
#   define _GRAPHH

/* ------------------------------------------------------------ */
struct VertexCell ;
struct EdgeCell ;

struct EdgeCell {
   void * Label ;
   struct VertexCell * Target ;
} ;
typedef struct EdgeCell tEdge ;

struct VertexCell {
   void * Data ;
   long Arity ;
   tEdge * Edges ;
   int Mark ;
} ;

typedef struct VertexCell * tVertex ;
typedef tVertex tGraph ;

/* ------------------------------------------------------------ */
/* Declaration of the profile of routines local to the file */
#   if !defined(ARGS)
#      if defined(__STDC__)
#         define ARGS(args) args
#      else
#         define ARGS(args) ()
#      endif
#   endif

extern tVertex graph_new_vertex 
   ARGS((void * Data, long Arity, int Mark)) ;
extern void graph_free_vertex 
   ARGS((tVertex Vertex)) ;
extern void graph_free
   ARGS((tGraph Graph, int Free_Data, int Free_Label)) ;

extern long graph_get_arity 
   ARGS((tVertex Vertex)) ;
extern void graph_set_arity 
   ARGS((tVertex Vertex, long Arity)) ;
extern void * graph_get_data 
   ARGS((tVertex Vertex)) ;
extern void graph_set_data 
   ARGS((tVertex Vertex, void * Data)) ;

extern int graph_get_mark
   ARGS((tVertex Vertex)) ;
extern void graph_mark_vertex
   ARGS((tVertex Vertex, int Mark)) ;
extern void graph_unmark_vertex
   ARGS((tVertex Vertex, int Mark)) ;
extern int graph_is_marked
   ARGS((tVertex Vertex, int Mark)) ;

extern void graph_set_edge
   ARGS((tVertex Vertex, long EdgeNo,
         void * Label, tVertex Target)) ;
extern void graph_set_label
   ARGS((tVertex Vertex, long EdgeNo, void * Label)) ;
extern void * graph_get_label
   ARGS((tVertex Vertex, long EdgeNo)) ;
extern void graph_set_target
   ARGS((tVertex Vertex, long EdgeNo, tVertex Target)) ;
extern tVertex graph_get_target
   ARGS((tVertex Vertex, long EdgeNo)) ;

/* ------------------------------------------------------------ */
#endif _GRAPHH
/* ------------------------------------------------------------ */
