/**CHeaderFile*****************************************************************

  FileName    [ fn.h ]
  PackageName [ fn ]
  Synopsis    [ Declarations of generic function types ]
  Author      [ David Deharbe ]
  Copyright   [ Carnegie Mellon University 1996 ]
  Revision    [ 1 ]

******************************************************************************/

#ifndef _FNH
#define _FNH

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef void   (* fn_apply)     (void * value, void * environment);
typedef void * (* fn_map)       (void * value, void * environment);
typedef int    (* fn_predicate) (void * value, void * environment);
typedef int    (* fn_compare) (void * v1, void * v2, void * environment);

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/
/** Macro **
  Synopsis    [ Equality predicate ]
  Description [ This macro is an equality predicate of the suitable type
  that implements equality compatible with the C operator ==. ]
  SideEffects [ None ]
*/
#define fn_predicate_equality ((fn_predicate) & fn_Cequality)
/** Macro **
  Synopsis    [ Equality predicate ]
  Description [ This macro is an equality predicate of the suitable type
  that implements equality compatible with the C operator ==. ]
  SideEffects [ None ]
*/
#define fn_predicate_tautology ((fn_predicate) & fn_Ctautology)
/** Macro **
  Synopsis    [ Identity map ]
  Description [ This macro is an identity map of the suitable type. ]
  SideEffects [ None ]
*/
#define fn_map_identity ((fn_map) & fn_Cidentity)

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern int fn_Cequality(void * v1, void * v2);
extern int fn_Ctautology(void * v1, void * v2);
extern void * fn_Cidentity(void * v, void * e);

/**AutomaticEnd***************************************************************/

#endif /* _FNH */
