/**CFile***********************************************************************

  FileName    [ fn.c ]
  PackageName [ fn ]
  Synopsis    [ Package implementation ]
  Description [ Basic data management ]
  SeeAlso     [ fn.h ]
  Author      [ David Deharbe ]
  Copyright   [ Carnegie Mellon University 1996 ]

******************************************************************************/
#include <memuser.h>

#include "fnInt.h" 

static char rcsid[] = "1_1";

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/


/**Function**
  Synopsis           [ Generic equality function ]
  Description        [ Take two generic arguments and returns 0 if they are 
  congruent with respect to the == operator. ]
  SideEffects        [ None ]
  SeeAlso            [ fn_predicate_eq ]
**/
int
fn_Cequality
(void * v1,
 void * v2)
{
  return (v1 == v2);
}

/**Function**
  Synopsis           [ Generic tautology function ]
  Description        [ Take two generic arguments and returns 1. ]
  SideEffects        [ None ]
  SeeAlso            [ fn_predicate_eq ]
**/
int
fn_Ctautology
(void * v1,
 void * v2)
{
  return 1;
}

/**Function**
  Synopsis           [ Generic identity function ]
  Description        [ Take to generic arguments and returns 0 if they are 
  congruent with respect to the == operator. ]
  SideEffects        [ None ]
  SeeAlso            [ fn_predicate_eq ]
**/
void *
fn_Cidentity
(void * v, void * e)
{
  return v;
}

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/

