#include <stdio.h>
#include <memuser.h>
#include "cvInt.h"

static void rList (cvn, FILE *);
static void rEntityDeclaration (cvn, FILE *);
static void rArchitectureBody (cvn, FILE *);
static void rPackageDeclaration (cvn, FILE *);
static void rPackageBody (cvn, FILE *);
static void rIntegerType (cvn, FILE *);
static void rEnumerationType (cvn, FILE *);
static void rSubtype (cvn, FILE *);
static void rTypeDeclaration (cvn, FILE *);
static void rSubtypeDeclaration (cvn, FILE *);
static void rSignalDeclaration (cvn, FILE *);
static void rVariableDeclaration (cvn, FILE *);
static void rConstantDeclaration (cvn, FILE *);
static void rUnary (cvn, FILE *);
static void rBinary (cvn, FILE *);
static void rIntegerValue (cvn, FILE *);
static void rRange (cvn, FILE *);
static void rIfStatement (cvn, FILE *);
static void rBranch (cvn, FILE *);
static void rCaseStatement (cvn, FILE *);
static void rWhileStatement (cvn, FILE *);
static void rForStatement (cvn, FILE *);
static void rAlternative (cvn, FILE *);
static void rWaitStatement (cvn, FILE *);
static void rVariableAssignmentStatement (cvn, FILE *);
static void rNullStatement (cvn, FILE *);
static void rWaveform (cvn, FILE *);
static void rSignalAssignmentStatement (cvn, FILE *);
static void rBlockStatement (cvn, FILE *);
static void rProcessStatement (cvn, FILE *);
static void rConditionalWaveform (cvn, FILE *);
static void rConditionalSignalAssignmentStatement (cvn, FILE *);
static void rSelectedSignalAssignmentStatement (cvn, FILE *);
static void rUseClause (cvn, FILE *);
static void rIdentifier (cvn, FILE *);
static void rCharacterLiteral (cvn, FILE *);
static void rEnumeratedLiteral (cvn, FILE *);

static void rString (char ** field, FILE * instream);

typedef void (* read_fn) (cvn, FILE *);
static read_fn read_fn_tab [] = {
  & rList,
  & rEntityDeclaration,
  & rArchitectureBody,
  & rPackageDeclaration,
  & rPackageBody,
  & rIntegerType,
  & rEnumerationType,
  & rSubtype,
  & rTypeDeclaration,
  & rSubtypeDeclaration,
  & rSignalDeclaration,
  & rVariableDeclaration,
  & rConstantDeclaration,
  & rUnary,
  & rBinary,
  & rIntegerValue,
  & rRange,
  & rIfStatement,
  & rBranch,
  & rCaseStatement,
  & rWhileStatement,
  & rForStatement,
  & rAlternative,
  & rWaitStatement,
  & rVariableAssignmentStatement,
  & rNullStatement,
  & rWaveform,
  & rSignalAssignmentStatement,
  & rBlockStatement,
  & rProcessStatement,
  & rConditionalWaveform,
  & rConditionalSignalAssignmentStatement,
  & rSelectedSignalAssignmentStatement,
  & rUseClause,
  & rIdentifier,
  & rCharacterLiteral,
  & rEnumeratedLiteral};

cvn
read_cvn
(FILE * instream, ref position)
{
  cvn result;
  int kind;
  fscanf(instream, "<%i ", & kind);
  result = cvn_alloc((tKind) kind);
  /* opening delimiter */
  result->header.aToolInfo = 0;
  result->header.position.unit = position.unit;
  result->header.position.offset = position.offset;
  /* variable information */
  (* read_fn_tab[(int) kind])(result, instream);
  /* closing delimiter */
  fscanf(instream, ">\n");
  return result;
}

static void
rList
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u %u "
         "%u %u "
         "%u %u ",
         & n->List.nNext.unit, & n->List.nNext.offset,
         & n->List.nPrevious.unit, & n->List.nPrevious.offset,
         & n->List.nValue.unit, & n->List.nValue.offset);
}

static void
rEntityDeclaration
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->EntityDeclaration.aLine,
         & n->EntityDeclaration.nNext.unit, & n->EntityDeclaration.nNext.offset,
         & n->EntityDeclaration.nPrevious.unit, & n->EntityDeclaration.nPrevious.offset);
  rString(& n->EntityDeclaration.aName, instream);
  fscanf(instream, 
         "%u %u "
         "%u %u ",
         & n->EntityDeclaration.nPorts.unit, & n->EntityDeclaration.nPorts.offset,
         & n->EntityDeclaration.nDeclarations.unit, & n->EntityDeclaration.nDeclarations.offset);
}

static void
rArchitectureBody
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->ArchitectureBody.aLine,
         & n->ArchitectureBody.nNext.unit, & n->ArchitectureBody.nNext.offset,
         & n->ArchitectureBody.nPrevious.unit, & n->ArchitectureBody.nPrevious.offset);
  rString(& n->ArchitectureBody.aName, instream);
  fscanf(instream, 
         "%u %u "
         "%u %u "
         "%u %u ",
         & n->ArchitectureBody.nDeclarations.unit, & n->ArchitectureBody.nDeclarations.offset,
         & n->ArchitectureBody.nStatements.unit, & n->ArchitectureBody.nStatements.offset,
         & n->ArchitectureBody.nPrimary.unit, & n->ArchitectureBody.nPrimary.offset);
}

static void
rPackageDeclaration
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->PackageDeclaration.aLine,
         & n->PackageDeclaration.nNext.unit, & n->PackageDeclaration.nNext.offset,
         & n->PackageDeclaration.nPrevious.unit, & n->PackageDeclaration.nPrevious.offset);
  rString(& n->PackageDeclaration.aName, instream);
  fscanf(instream, 
          "%u %u ",
          & n->PackageDeclaration.nDeclarations.unit, & n->PackageDeclaration.nDeclarations.offset);
}

static void
rPackageBody
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->PackageBody.aLine,
         & n->PackageBody.nNext.unit, & n->PackageBody.nNext.offset,
         & n->PackageBody.nPrevious.unit, & n->PackageBody.nPrevious.offset);
  rString(& n->PackageBody.aName, instream);
  fscanf(instream, 
         "%u %u "
         "%u %u ",
         & n->PackageBody.nDeclarations.unit, & n->PackageBody.nDeclarations.offset,
         & n->PackageBody.nPrimary.unit, & n->PackageBody.nPrimary.offset);
}

static void
rIntegerType
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u %u ",
          & n->IntegerType.nDeclaration.unit, & n->IntegerType.nDeclaration.offset, 
          & n->IntegerType.nRange.unit, & n->IntegerType.nRange.offset);
}

static void
rEnumerationType
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u %u ",
          & n->EnumerationType.nDeclaration.unit, & n->EnumerationType.nDeclaration.offset, 
          & n->EnumerationType.nElements.unit, & n->EnumerationType.nElements.offset);
}

static void
rSubtype
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u %u "
          "%u %u ",
          & n->Subtype.nDeclaration.unit, & n->Subtype.nDeclaration.offset,
          & n->Subtype.nBaseType.unit, & n->Subtype.nBaseType.offset,
          & n->Subtype.nConstraint.unit, & n->Subtype.nConstraint.offset);
}

static void
rTypeDeclaration
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->TypeDeclaration.aLine,
         & n->TypeDeclaration.nNext.unit, & n->TypeDeclaration.nNext.offset,
         & n->TypeDeclaration.nPrevious.unit, & n->TypeDeclaration.nPrevious.offset);
  rString(& n->TypeDeclaration.aName, instream);
  fscanf(instream, 
          "%u %u ",
          & n->TypeDeclaration.nSubtype.unit, & n->TypeDeclaration.nSubtype.offset);
}

static void
rSubtypeDeclaration
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->SubtypeDeclaration.aLine,
         & n->SubtypeDeclaration.nNext.unit, & n->SubtypeDeclaration.nNext.offset,
         & n->SubtypeDeclaration.nPrevious.unit, & n->SubtypeDeclaration.nPrevious.offset);
  rString(& n->SubtypeDeclaration.aName, instream);
  fscanf(instream, 
          "%u %u ",
          & n->SubtypeDeclaration.nSubtype.unit, & n->SubtypeDeclaration.nSubtype.offset);
}

static void
rSignalDeclaration
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->SignalDeclaration.aLine,
         & n->SignalDeclaration.nNext.unit, & n->SignalDeclaration.nNext.offset,
         & n->SignalDeclaration.nPrevious.unit, & n->SignalDeclaration.nPrevious.offset);
  rString(& n->SignalDeclaration.aName, instream);
  fscanf(instream, 
          "%u %u "
          "%u "
          "%u %u ",
          & n->SignalDeclaration.nSubtype.unit, & n->SignalDeclaration.nSubtype.offset,
          (unsigned *) & n->SignalDeclaration.aMode,
          & n->SignalDeclaration.nDefaultValue.unit, & n->SignalDeclaration.nDefaultValue.offset);
}

static void
rVariableDeclaration
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->VariableDeclaration.aLine,
         & n->VariableDeclaration.nNext.unit, & n->VariableDeclaration.nNext.offset,
         & n->VariableDeclaration.nPrevious.unit, & n->VariableDeclaration.nPrevious.offset);
  rString(& n->VariableDeclaration.aName, instream);
  fscanf(instream, 
          "%u %u "
          "%u "
          "%u %u ",
          & n->VariableDeclaration.nSubtype.unit, & n->VariableDeclaration.nSubtype.offset,
          (unsigned *) & n->VariableDeclaration.aMode,
          & n->VariableDeclaration.nInitialValue.unit, & n->VariableDeclaration.nInitialValue.offset);
}

static void
rConstantDeclaration
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->ConstantDeclaration.aLine,
         & n->ConstantDeclaration.nNext.unit, & n->ConstantDeclaration.nNext.offset,
         & n->ConstantDeclaration.nPrevious.unit, & n->ConstantDeclaration.nPrevious.offset);
  rString(& n->ConstantDeclaration.aName, instream);
  fscanf(instream, 
          "%u %u "
          "%u %u ",
          & n->ConstantDeclaration.nSubtype.unit, & n->ConstantDeclaration.nSubtype.offset,
          & n->ConstantDeclaration.nValue.unit, & n->ConstantDeclaration.nValue.offset);
}

static void
rUnary
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u "
          "%u %u ",
          & n->Unary.nSubtype.unit, & n->Unary.nSubtype.offset,
          (unsigned *) & n->Unary.aOperator,
          & n->Unary.nOperand.unit, & n->Unary.nOperand.offset);
}

static void
rBinary
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u "
          "%u %u "
          "%u %u ",
          & n->Binary.nSubtype.unit, & n->Binary.nSubtype.offset,
          (unsigned *) & n->Binary.aOperator,
          & n->Binary.nLeft.unit, & n->Binary.nLeft.offset,
          & n->Binary.nRight.unit, & n->Binary.nRight.offset);
}

static void
rIntegerValue
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%i ",
          & n->IntegerValue.nSubtype.unit, & n->IntegerValue.nSubtype.offset,
          & n->IntegerValue.aIntegerValue);
}

static void
rRange
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
          (unsigned *) & n->Range.aDirection,
          & n->Range.nLeft.unit, & n->Range.nLeft.offset,
          & n->Range.nRight.unit, & n->Range.nRight.offset);
}

static void
rIfStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->IfStatement.aLine,
         & n->IfStatement.nNext.unit, & n->IfStatement.nNext.offset,
         & n->IfStatement.nPrevious.unit, & n->IfStatement.nPrevious.offset);
  rString(& n->IfStatement.aName, instream);
  fscanf(instream, 
          "%u %u ",
          & n->IfStatement.nBranches.unit, & n->IfStatement.nBranches.offset);
}

static void
rBranch
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u %u "
          "%u %u "
          "%u %u ",
          & n->Branch.nNext.unit, & n->Branch.nNext.offset,
          & n->Branch.nPrevious.unit, & n->Branch.nPrevious.offset,
          & n->Branch.nCondition.unit, & n->Branch.nCondition.offset,
          & n->Branch.nStatements.unit, & n->Branch.nStatements.offset);
}
static void
rCaseStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->CaseStatement.aLine,
         & n->CaseStatement.nNext.unit, & n->CaseStatement.nNext.offset,
         & n->CaseStatement.nPrevious.unit, & n->CaseStatement.nPrevious.offset);
  rString(& n->CaseStatement.aName, instream);
  fscanf(instream, 
          "%u %u "
          "%u %u ",
          & n->CaseStatement.nSelector.unit, & n->CaseStatement.nSelector.offset,
          & n->CaseStatement.nAlternatives.unit, & n->CaseStatement.nAlternatives.offset);
}

static void
rWhileStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->WhileStatement.aLine,
         & n->WhileStatement.nNext.unit, & n->WhileStatement.nNext.offset,
         & n->WhileStatement.nPrevious.unit, & n->WhileStatement.nPrevious.offset);
  rString(& n->WhileStatement.aName, instream);
  fscanf(instream, 
          "%u %u "
          "%u %u ",
          & n->WhileStatement.nStatements.unit, & n->WhileStatement.nStatements.offset,
          & n->WhileStatement.nCondition.unit, & n->WhileStatement.nCondition.offset);
}

static void
rForStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->ForStatement.aLine,
         & n->ForStatement.nNext.unit, & n->ForStatement.nNext.offset,
         & n->ForStatement.nPrevious.unit, & n->ForStatement.nPrevious.offset);
  rString(& n->ForStatement.aName, instream);
  fscanf(instream, 
          "%u %u "
          "%u %u "
          "%u %u ",
          & n->ForStatement.nStatements.unit, & n->ForStatement.nStatements.offset,
          & n->ForStatement.nParameter.unit, & n->ForStatement.nParameter.offset,
          & n->ForStatement.nRange.unit, & n->ForStatement.nRange.offset);
}

static void
rAlternative
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u %u "
          "%u %u "
          "%u %u ",
          & n->Alternative.nNext.unit, & n->Alternative.nNext.offset,
          & n->Alternative.nPrevious.unit, & n->Alternative.nPrevious.offset,
          & n->Alternative.nChoices.unit, & n->Alternative.nChoices.offset,
          & n->Alternative.nStatements.unit, & n->Alternative.nStatements.offset);
}

static void
rWaitStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->WaitStatement.aLine,
         & n->WaitStatement.nNext.unit, & n->WaitStatement.nNext.offset,
         & n->WaitStatement.nPrevious.unit, & n->WaitStatement.nPrevious.offset);
  rString(& n->ForStatement.aName, instream);
  fscanf(instream, 
         "%u %u "
         "%u %u ",
          & n->WaitStatement.nCondition.unit, & n->WaitStatement.nCondition.offset,
          & n->WaitStatement.nSignals.unit, & n->WaitStatement.nSignals.offset);
}

static void
rVariableAssignmentStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->VariableAssignmentStatement.aLine,
         & n->VariableAssignmentStatement.nNext.unit, & n->VariableAssignmentStatement.nNext.offset,
         & n->VariableAssignmentStatement.nPrevious.unit, & n->VariableAssignmentStatement.nPrevious.offset);
  rString(& n->VariableAssignmentStatement.aName, instream);
  fscanf(instream, 
         "%u %u "
         "%u %u ",
          & n->VariableAssignmentStatement.nTarget.unit, & n->VariableAssignmentStatement.nTarget.offset,
          & n->VariableAssignmentStatement.nSource.unit, & n->VariableAssignmentStatement.nSource.offset);
}

static void
rNullStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->NullStatement.aLine,
         & n->NullStatement.nNext.unit, & n->NullStatement.nNext.offset,
         & n->NullStatement.nPrevious.unit, & n->NullStatement.nPrevious.offset);
  rString(& n->NullStatement.aName, instream);
}

static void
rWaveform
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u %u ",
          & n->Waveform.nValue.unit, & n->Waveform.nValue.offset);
}

static void
rSignalAssignmentStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->SignalAssignmentStatement.aLine,
         & n->SignalAssignmentStatement.nNext.unit, & n->SignalAssignmentStatement.nNext.offset,
         & n->SignalAssignmentStatement.nPrevious.unit, & n->SignalAssignmentStatement.nPrevious.offset);
  rString(& n->SignalAssignmentStatement.aName, instream);
  fscanf(instream, 
         "%u %u "
         "%u %u ",
          & n->SignalAssignmentStatement.nTarget.unit, & n->SignalAssignmentStatement.nTarget.offset,
          & n->SignalAssignmentStatement.nSource.unit, & n->SignalAssignmentStatement.nSource.offset);
}

static void
rBlockStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->BlockStatement.aLine,
         & n->BlockStatement.nNext.unit, & n->BlockStatement.nNext.offset,
         & n->BlockStatement.nPrevious.unit, & n->BlockStatement.nPrevious.offset);
  rString(& n->BlockStatement.aName, instream);
  fscanf(instream, 
         "%u %u "
         "%u %u ",
          & n->BlockStatement.nDeclarations.unit, & n->BlockStatement.nDeclarations.offset,
          & n->BlockStatement.nStatements.unit, & n->BlockStatement.nStatements.offset);
}

static void
rProcessStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
         "%u "
         "%u %u "
         "%u %u ",
         & n->ProcessStatement.aLine,
         & n->ProcessStatement.nNext.unit, & n->ProcessStatement.nNext.offset,
         & n->ProcessStatement.nPrevious.unit, & n->ProcessStatement.nPrevious.offset);
  rString(& n->ProcessStatement.aName, instream);
  fscanf(instream, 
         "%u %u "
         "%u %u "
         "%u %u ",
          & n->ProcessStatement.nSensitivityList.unit, & n->ProcessStatement.nSensitivityList.offset,
          & n->ProcessStatement.nDeclarations.unit, & n->ProcessStatement.nDeclarations.offset,
          & n->ProcessStatement.nStatements.unit, & n->ProcessStatement.nStatements.offset);
}

static void
rConditionalWaveform
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u %u "
          "%u %u "
          "%u %u ",
          & n->ConditionalWaveform.nNext.unit, & n->ConditionalWaveform.nNext.offset,
          & n->ConditionalWaveform.nPrevious.unit, & n->ConditionalWaveform.nPrevious.offset,
          & n->ConditionalWaveform.nCondition.unit, & n->ConditionalWaveform.nCondition.offset,
          & n->ConditionalWaveform.nValue.unit, & n->ConditionalWaveform.nValue.offset);
}

static void
rConditionalSignalAssignmentStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->ConditionalSignalAssignmentStatement.aLine,
         & n->ConditionalSignalAssignmentStatement.nNext.unit, & n->ConditionalSignalAssignmentStatement.nNext.offset,
         & n->ConditionalSignalAssignmentStatement.nPrevious.unit, & n->ConditionalSignalAssignmentStatement.nPrevious.offset);
  rString(& n->ConditionalSignalAssignmentStatement.aName, instream);
  fscanf(instream, 
          "%u %u "
          "%u %u ",
          & n->ConditionalSignalAssignmentStatement.nTarget.unit, & n->ConditionalSignalAssignmentStatement.nTarget.offset,
          & n->ConditionalSignalAssignmentStatement.nSource.unit, & n->ConditionalSignalAssignmentStatement.nSource.offset);
}

static void
rSelectedSignalAssignmentStatement
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u "
          "%u %u "
          "%u %u ",
         & n->SelectedSignalAssignmentStatement.aLine,
         & n->SelectedSignalAssignmentStatement.nNext.unit, & n->SelectedSignalAssignmentStatement.nNext.offset,
         & n->SelectedSignalAssignmentStatement.nPrevious.unit, & n->SelectedSignalAssignmentStatement.nPrevious.offset);
  rString(& n->SelectedSignalAssignmentStatement.aName, instream);
  fscanf(instream, 
          "%u %u "
          "%u %u "
          "%u %u ",
          & n->SelectedSignalAssignmentStatement.nTarget.unit, & n->SelectedSignalAssignmentStatement.nTarget.offset,
          & n->SelectedSignalAssignmentStatement.nSelector.unit, & n->SelectedSignalAssignmentStatement.nSelector.offset, 
          & n->SelectedSignalAssignmentStatement.nAlternatives.unit, 
          & n->SelectedSignalAssignmentStatement.nAlternatives.offset);
}

static void
rUseClause
(cvn n, FILE * instream)
{
  fscanf(instream,
          "%u %u "
          "%u %u "
          "%u %u ",
          & n->UseClause.nNext.unit, & n->UseClause.nNext.offset,
          & n->UseClause.nPrevious.unit, & n->UseClause.nPrevious.offset,
          & n->UseClause.nSelectedNames.unit, & n->UseClause.nSelectedNames.offset);
}

static void
rIdentifier
(cvn n, FILE * instream)
{
  rString(& n->Identifier.aName, instream);
  fscanf(instream, 
          "%u %u ",
          & n->Identifier.nDeclaration.unit, & n->Identifier.nDeclaration.offset);
}

static void
rCharacterLiteral
(cvn n, FILE * instream)
{
  rString(& n->CharacterLiteral.aName, instream);
  fscanf(instream, 
          "%u "
          "%u %u ",
          & n->CharacterLiteral.aOrdinalValue,
          & n->CharacterLiteral.nDeclaration.unit, & n->CharacterLiteral.nDeclaration.offset);
}

static void
rEnumeratedLiteral
(cvn n, FILE * instream)
{
  rString(& n->EnumeratedLiteral.aName, instream);
  fscanf(instream, 
          "%u "
          "%u %u ",
          & n->EnumeratedLiteral.aOrdinalValue,
          & n->EnumeratedLiteral.nDeclaration.unit, & n->EnumeratedLiteral.nDeclaration.offset);
}

static void
rString
(char ** field, FILE * instream)
{
  unsigned long length;
  fscanf(instream, "%lu ", &length);
  * field = (char *) mem_get_block((SIZE_T) (length + 1) * sizeof(char));
  if (length == 0) {
    (* field)[0] = 0;
  } else {
    fscanf(instream, "%s ", * field);
  }
}
