#include "Errors.h"
#include "cvInt.h"

int
IsA
(const cvn t,
 const tKind k)
{
  return (qKind(t) == k);
}

/* ------------------------------------------------------------ */
int
NullNode
(const cvn t)
{
  return (t == 0);
}

/* ------------------------------------------------------------ */
int
cv_eq
(const cvn t1, 
 const cvn t2)
{
  return (t1 == t2);
}

int
cv_eq_decl
(const cvn t1, 
 const cvn t2)
{
  return ((t1 == t2) || (qDeclaration(t1) == qDeclaration(t2)));
}

/* ------------------------------------------------------------ */
cvn
qNext
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kList :
      r = t->List.nNext;
      break;
    case kEntityDeclaration :
      r = t->EntityDeclaration.nNext;
      break;
    case kArchitectureBody :
      r = t->ArchitectureBody.nNext;
      break;
    case kPackageDeclaration :
      r = t->PackageDeclaration.nNext;
      break;
    case kPackageBody :
      r = t->PackageBody.nNext;
      break;
    case kSignalDeclaration :
      r = t->SignalDeclaration.nNext;
      break;
    case kVariableDeclaration :
      r = t->VariableDeclaration.nNext;
      break;
    case kConstantDeclaration :
      r = t->ConstantDeclaration.nNext;
      break;
    case kTypeDeclaration :
      r = t->TypeDeclaration.nNext;
      break;
    case kSubtypeDeclaration :
      r = t->SubtypeDeclaration.nNext;
      break;
    case kProcessStatement :
      r = t->ProcessStatement.nNext;
      break;
    case kBlockStatement :
      r = t->BlockStatement.nNext;
      break;
    case kIfStatement :
      r = t->IfStatement.nNext;
      break;
    case kCaseStatement :
      r = t->CaseStatement.nNext;
      break;
    case kNullStatement :
      r = t->NullStatement.nNext;
      break;
    case kBranch :
      r = t->Branch.nNext;
      break;
    case kWaitStatement :
      r = t->WaitStatement.nNext;
      break;
    case kVariableAssignmentStatement :
      r = t->VariableAssignmentStatement.nNext;
      break;
    case kSignalAssignmentStatement :
      r = t->SignalAssignmentStatement.nNext;
      break;
    case kConditionalSignalAssignmentStatement :
      r = t->ConditionalSignalAssignmentStatement.nNext;
      break;
    case kSelectedSignalAssignmentStatement :
      r = t->SelectedSignalAssignmentStatement.nNext;
      break;
    case kAlternative :
      r = t->Alternative.nNext;
      break;
    case kConditionalWaveform :
      r = t->ConditionalWaveform.nNext;
      break;
    case kUseClause :
      r = t->UseClause.nNext;
      break;
    default :
      Message("(libcv.a) qNext - no nNext value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

cvn
qPrevious
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kList :
      r = t->List.nPrevious;
      break;
    case kEntityDeclaration :
      r = t->EntityDeclaration.nPrevious;
      break;
    case kArchitectureBody :
      r = t->ArchitectureBody.nPrevious;
      break;
    case kPackageDeclaration :
      r = t->PackageDeclaration.nPrevious;
      break;
    case kPackageBody :
      r = t->PackageBody.nPrevious;
      break;
    case kSignalDeclaration :
      r = t->SignalDeclaration.nPrevious;
      break;
    case kVariableDeclaration :
      r = t->VariableDeclaration.nPrevious;
      break;
    case kConstantDeclaration :
      r = t->ConstantDeclaration.nPrevious;
      break;
    case kTypeDeclaration :
      r = t->TypeDeclaration.nPrevious;
      break;
    case kSubtypeDeclaration :
      r = t->SubtypeDeclaration.nPrevious;
      break;
    case kProcessStatement :
      r = t->ProcessStatement.nPrevious;
      break;
    case kBlockStatement :
      r = t->BlockStatement.nPrevious;
      break;
    case kIfStatement :
      r = t->IfStatement.nPrevious;
      break;
    case kCaseStatement :
      r = t->CaseStatement.nPrevious;
      break;
    case kNullStatement :
      r = t->CaseStatement.nPrevious;
      break;
    case kBranch :
      r = t->Branch.nPrevious;
      break;
    case kWaitStatement :
      r = t->WaitStatement.nPrevious;
      break;
    case kVariableAssignmentStatement :
      r = t->VariableAssignmentStatement.nPrevious;
      break;
    case kSignalAssignmentStatement :
      r = t->SignalAssignmentStatement.nPrevious;
      break;
    case kConditionalSignalAssignmentStatement :
      r = t->ConditionalSignalAssignmentStatement.nPrevious;
      break;
    case kAlternative :
      r = t->Alternative.nPrevious;
      break;
    case kConditionalWaveform :
      r = t->ConditionalWaveform.nPrevious;
      break;
    case kUseClause :
      r = t->UseClause.nPrevious;
      break;
    default :
      Message("(libcv.a) qPrevious - no qPrevious value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qValue
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kList :
      r = t->List.nValue;
      break;
    case kWaveform :
      r = t->Waveform.nValue;
      break;
    case kConditionalWaveform :
      r = t->ConditionalWaveform.nValue;
      break;
    case kConstantDeclaration :
      r = t->ConstantDeclaration.nValue;
      break;
    default :
      Message("(libcv.a) qValue - no nValue value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qSensitivityList
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kProcessStatement :
      r = t->ProcessStatement.nSensitivityList;
      break;
    default :
      Message("(libcv.a) qSensitivityList - no nSensitivityList value",
              xxRepair, NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qDeclarations
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kEntityDeclaration :
      r = t->EntityDeclaration.nDeclarations;
      break;
    case kArchitectureBody :
      r = t->ArchitectureBody.nDeclarations;
      break;
    case kPackageDeclaration :
      r = t->PackageDeclaration.nDeclarations;
      break;
    case kPackageBody :
      r = t->PackageBody.nDeclarations;
      break;
    case kProcessStatement :
      r = t->ProcessStatement.nDeclarations;
      break;
    case kBlockStatement :
      r = t->BlockStatement.nDeclarations;
      break;
    default :
      Message("(libcv.a) qDeclarations - no nDeclarations value", 
              xxRepair, NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qStatements
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
   switch (qKind(t)) {
    case kArchitectureBody :
      r = t->ArchitectureBody.nStatements;
      break;
    case kProcessStatement :
      r = t->ProcessStatement.nStatements;
      break;
    case kBlockStatement :
      r = t->BlockStatement.nStatements;
      break;
    case kForStatement :
      r = t->ForStatement.nStatements;
      break;
    case kWhileStatement :
      r = t->WhileStatement.nStatements;
      break;
    case kBranch :
      r = t->Branch.nStatements;
      break;
    case kAlternative :
      r = t->Alternative.nStatements;
      break;
    default :
      Message("(libcv.a) qStatements - no nStatements value", 
              xxRepair, NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}


/* ------------------------------------------------------------------------ */
cvn
qPorts
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kEntityDeclaration :
      r = t->EntityDeclaration.nPorts;
      break;
    default :
      Message("(libcv.a) qPorts - no nPorts value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qPrimary
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kArchitectureBody :
      r = t->ArchitectureBody.nPrimary;
      break;
    case kPackageBody :
      r = t->PackageBody.nPrimary;
      break;
    default :
      Message("(libcv.a) qPrimary - no nPrimary value", xxRepair, 
              NoPosition);
    return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qDeclaration
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kIdentifier :
      r = t->Identifier.nDeclaration;
      break;
    case kCharacterLiteral :
      r = t->CharacterLiteral.nDeclaration;
      break;
    case kEnumeratedLiteral :
      r = t->EnumeratedLiteral.nDeclaration;
      break;
    case kEnumerationType :
      r = t->EnumerationType.nDeclaration;
      break;
    case kIntegerType :
      r = t->IntegerType.nDeclaration;
      break;
    case kSubtype :
      r = t->Subtype.nDeclaration;
      break;
    default :
      Message("(libcv.a) qDeclaration - no nDeclaration value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qLeft
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kBinary :
      r = t->Binary.nLeft;
      break;
    case kRange :
      r = t->Range.nLeft;
      break;
    default :
      Message("(libcv.a) qLeft - no nLeft value", xxRepair, NoPosition);
    return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qRight
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kBinary :
      r = t->Binary.nRight;
      break;
    case kRange :
      r = t->Range.nRight;
      break;
    default :
      Message("(libcv.a) qRight - no nRight value", xxRepair, NoPosition);
    return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qRange
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kIntegerType :
      r = t->IntegerType.nRange;
      break;
    default :
      Message("(libcv.a) qRange - no nRange value", xxRepair,
              NoPosition);
    return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qElements
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kEnumerationType :
      r = t->EnumerationType.nElements;
      break;
    default :
      Message("(libcv.a) qElements - no nElements value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qSubtype
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kSignalDeclaration :
      r = t->SignalDeclaration.nSubtype;
      break;
    case kVariableDeclaration :
      r = t->VariableDeclaration.nSubtype;
      break;
    case kConstantDeclaration :
      r = t->ConstantDeclaration.nSubtype;
      break;
    case kTypeDeclaration :
      r = t->TypeDeclaration.nSubtype;
      break;
    case kSubtypeDeclaration :
      r = t->SubtypeDeclaration.nSubtype;
      break;
    case kIntegerValue :
      r = t->IntegerValue.nSubtype;
      break;
    case kUnary :
      r = t->Unary.nSubtype;
      break;
    case kBinary :
      r = t->Binary.nSubtype;
      break;
    case kCharacterLiteral :
    case kEnumeratedLiteral :
      return qSubtype(qDeclaration(t));
    case kIdentifier : { 
      cvn decl = qDeclaration(t);
      if (decl &&
          (IsA(decl, kSignalDeclaration) ||
           IsA(decl, kVariableDeclaration) ||
           IsA(decl, kConstantDeclaration)))
	  return qSubtype(decl);
    /* else error: goes through on purpose */
    }
    default :
      Message("(libcv.a) qSubtype - no nSubtype value", xxRepair, NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}
  
/* ------------------------------------------------------------------------ */
cvn
qBaseType
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kSubtype :
      r = t->Subtype.nBaseType;
      break;
    default :
      Message("(libcv.a) qBaseType - no nBaseType value", xxRepair, NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qConstraint
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kSubtype :
      r = t->Subtype.nConstraint;
      break;
    default :
      Message("(libcv.a) qConstraint - no nConstraint value", xxRepair, NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qSelectedNames
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kUseClause:
      r = t->UseClause.nSelectedNames;
      break;
    default:
      Message("(libcv.a) qSelectedNames - no nSelectedNames value", xxRepair,
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qDefaultValue
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kSignalDeclaration :
      r = t->SignalDeclaration.nDefaultValue;
      break;
    default :
      Message("(libcv.a) qDefaultValue - no nDefaultValue value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qInitialValue
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kVariableDeclaration :
      r = t->VariableDeclaration.nInitialValue;
      break;
    default :
      Message("(libcv.a) qInitialValue - no nInitialValue value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qOperand
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
   switch (qKind(t)) {
    case kUnary :
      r = t->Unary.nOperand;
      break;
    default :
      Message("(libcv.a) qOperand - no nOperand value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qBranches
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kIfStatement :
      r = t->IfStatement.nBranches;
      break;
    default :
      Message("(libcv.a) qBranches - no nBranches value", xxRepair, 
              NoPosition);
    return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qCondition
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kWaitStatement :
      r = t->WaitStatement.nCondition;
      break;
    case kConditionalWaveform :
      r = t->ConditionalWaveform.nCondition;
      break;
    case kBranch :
      r = t->Branch.nCondition;
      break;
    default :
      Message("(libcv.a) qCondition - no nCondition value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qSelector
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kCaseStatement :
      r = t->CaseStatement.nSelector;
      break;
    case kSelectedSignalAssignmentStatement :
      r = t->SelectedSignalAssignmentStatement.nSelector;
      break;
    default :
      Message("(libcv.a) qSelector - no nSelector value", xxRepair, 
	      NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qAlternatives
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kCaseStatement :
      r = t->CaseStatement.nAlternatives;
      break;
    case kSelectedSignalAssignmentStatement :
      r = t->SelectedSignalAssignmentStatement.nAlternatives;
      break;
    default :
      Message("(libcv.a) qSelector - no nSelector value", xxRepair, 
              NoPosition);
    return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qChoices
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
   switch (qKind(t)) {
    case kAlternative :
      r = t->Alternative.nChoices;
      break;
    default :
      Message("(libcv.a) qChoices - no nChoices value", xxRepair, 
              NoPosition);
     return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qSignals
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kWaitStatement :
      r = t->WaitStatement.nSignals;
      break;
    default :
      Message("(libcv.a) qSignals - no nSignals value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qTarget
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kSignalAssignmentStatement :
      r = t->SignalAssignmentStatement.nTarget;
      break;
    case kConditionalSignalAssignmentStatement :
      r = t->ConditionalSignalAssignmentStatement.nTarget;
      break;
    case kSelectedSignalAssignmentStatement :
      r = t->SelectedSignalAssignmentStatement.nTarget;
      break;
    case kVariableAssignmentStatement :
      r = t->VariableAssignmentStatement.nTarget;
      break;
    default :
      Message("(libcv.a) qTarget - no nTarget value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}

/* ------------------------------------------------------------------------ */
cvn
qSource
(const cvn t)
{
  ref r;
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kSignalAssignmentStatement :
      r = t->SignalAssignmentStatement.nSource;
      break;
    case kConditionalSignalAssignmentStatement :
      r = t->ConditionalSignalAssignmentStatement.nSource;
      break;
    case kVariableAssignmentStatement :
      r = t->VariableAssignmentStatement.nSource;
      break;
    default :
      Message("(libcv.a) qSource - no nSource value", xxRepair, 
              NoPosition);
      return 0;
  }
  return ref_to_cvn(r);
}
/* ------------------------------------------------------------------------ */

void *
qToolInfo
(const cvn t)
{
  if (t == 0) return 0;
  return t->EntityDeclaration.aToolInfo;
}

unsigned
qOrdinalValue
(const cvn t)
{
  if (t == 0) return 0;
   switch (qKind(t)) {
    case kEnumeratedLiteral :
      return t->EnumeratedLiteral.aOrdinalValue;
      break;
    case kCharacterLiteral :
      return t->CharacterLiteral.aOrdinalValue;
      break;
    default :
      Message("(libcv.a) qOrdinalValue - no aOrdinalValue attribute", 
              xxRepair, NoPosition);
      return 0;
  }
}

unsigned
qLine
(const cvn t)
{
  if (t == 0) return 0;
   switch (qKind(t)) {
    case kEntityDeclaration :
      return t->EntityDeclaration.aLine;
    case kArchitectureBody :
      return t->ArchitectureBody.aLine;
    case kPackageDeclaration :
      return t->PackageDeclaration.aLine;
    case kPackageBody :
      return t->PackageBody.aLine;
    case kSignalDeclaration :
      return t->SignalDeclaration.aLine;
    case kVariableDeclaration :
      return t->VariableDeclaration.aLine;
    case kConstantDeclaration :
      return t->ConstantDeclaration.aLine;
    case kTypeDeclaration :
      return t->TypeDeclaration.aLine;
    case kSubtypeDeclaration :
      return t->SubtypeDeclaration.aLine;
    case kProcessStatement :
      return t->ProcessStatement.aLine;
    case kBlockStatement :
      return t->BlockStatement.aLine;
    case kIfStatement :
      return t->IfStatement.aLine;
    case kCaseStatement :
      return t->CaseStatement.aLine;
    case kNullStatement :
      return t->NullStatement.aLine;
    case kWaitStatement :
      return t->WaitStatement.aLine;
    case kSignalAssignmentStatement :
      return t->SignalAssignmentStatement.aLine;
    case kConditionalSignalAssignmentStatement :
      return t->ConditionalSignalAssignmentStatement.aLine;
    case kSelectedSignalAssignmentStatement :
      return t->SelectedSignalAssignmentStatement.aLine;
    case kVariableAssignmentStatement :
      return t->VariableAssignmentStatement.aLine;
    default :
      Message("(libcv.a) qLine - no aLine attribute", xxRepair, NoPosition);
      return 0;
  }
}

char *
qName
(const cvn t)
{
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kEntityDeclaration :
      return t->EntityDeclaration.aName;
    case kArchitectureBody :
      return t->ArchitectureBody.aName;
    case kPackageDeclaration :
      return t->PackageDeclaration.aName;
    case kPackageBody :
      return t->PackageBody.aName;
    case kSignalDeclaration :
      return t->SignalDeclaration.aName;
    case kVariableDeclaration :
      return t->VariableDeclaration.aName;
    case kConstantDeclaration :
      return t->ConstantDeclaration.aName;
    case kTypeDeclaration :
      return t->TypeDeclaration.aName;
    case kSubtypeDeclaration :
      return t->SubtypeDeclaration.aName;
    case kProcessStatement :
      return t->ProcessStatement.aName;
    case kBlockStatement :
      return t->BlockStatement.aName;
    case kIfStatement :
      return t->IfStatement.aName;
    case kCaseStatement :
      return t->CaseStatement.aName;
    case kNullStatement :
      return t->NullStatement.aName;
    case kSignalAssignmentStatement :
      return t->SignalAssignmentStatement.aName;
    case kConditionalSignalAssignmentStatement :
      return t->ConditionalSignalAssignmentStatement.aName;
    case kSelectedSignalAssignmentStatement :
      return t->SelectedSignalAssignmentStatement.aName;
    case kVariableAssignmentStatement :
      return t->VariableAssignmentStatement.aName;
    case kWaitStatement :
      return t->WaitStatement.aName;
    case kIdentifier :
      return t->Identifier.aName;
    case kEnumeratedLiteral :
      return t->EnumeratedLiteral.aName;
    case kCharacterLiteral :
      return t->CharacterLiteral.aName;
    default :
      Message("(libcv.a) qName - no aName attribute", xxRepair, 
              NoPosition);
      return 0;
  }
}

/* ------------------------------------------------------------------------ */
tMode
qMode
(const cvn t)
{
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kSignalDeclaration :
      return t->SignalDeclaration.aMode;
    case kVariableDeclaration :
      return t->VariableDeclaration.aMode;
    default :
      Message("(libcv.a) qMode - no aMode attribute", xxRepair, NoPosition);
      return kDefaultMode;
  }
}

/* ------------------------------------------------------------------------ */
tDirection
qDirection
(const cvn t)
{
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kRange :
      return t->Range.aDirection;
    default :
      Message("(libcv.a) qDirection - no aDirection attribute", xxRepair, NoPosition);
      return kDefaultDirection;
  }
}

/* ------------------------------------------------------------------------ */
tOperator
qOperator
(const cvn t)
{
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kUnary :
      return t->Unary.aOperator;
    case kBinary :
      return t->Binary.aOperator;
      default :
         Message("(libcv.a) qOperator - no aOperator attribute", xxRepair, NoPosition);
      return (tOperator) 0;
  }
}

/* ------------------------------------------------------------------------ */
int
qIntegerValue
(const cvn t)
{
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kIntegerValue :
      return t->IntegerValue.aIntegerValue;
    default :
      Message("(libcv.a) qIntegerValue - no aIntegerValue attribute", xxRepair, 
              NoPosition);
      return 0;
  }
}

/* ------------------------------------------------------------------------ */
cvn
qLower
(const cvn t)
{
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kRange :
      return qLeft(t);
    default :
      Message("(libcv.a) qLower - no nLower value", xxRepair, NoPosition);
      return 0;
  }
}

/* ------------------------------------------------------------------------ */
cvn
qUpper
(const cvn t)
{
  if (t == 0) return 0;
  switch (qKind(t)) {
    case kRange :
      return qRight(t);
    default :
      Message("(libcv.a) qUpper - no nUpper value", xxRepair, NoPosition);
      return 0;
  }
}

/* ------------------------------------------------------------------------ */
tKind
qKind
(const cvn t)
{
  return t->header.aKind;
}

