#include <memuser.h>
#include "cvInt.h"

/* ------------------------------------------ m* --- */

cvn
mList
(void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnValue)
{
  register cvn result;
  result = cvn_new(kList);
  result->List.aToolInfo = paToolInfo;
  cvn_to_ref(& result->List.nNext, pnNext);
  cvn_to_ref(& result->List.nPrevious, pnPrevious);
  cvn_to_ref(& result->List.nValue, pnValue);
  return result;
}

cvn mEntityDeclaration
(void * paToolInfo,
 unsigned paLine,
 cvn pnNext,
 cvn pnPrevious,
 char * paName,
 cvn pnPorts,
 cvn pnDeclarations)
{
  register cvn result;
  result = cvn_new(kEntityDeclaration);
  result->EntityDeclaration.aToolInfo = paToolInfo;
  result->EntityDeclaration.aLine = paLine;
  cvn_to_ref(& result->EntityDeclaration.nNext, pnNext);
  cvn_to_ref(& result->EntityDeclaration.nPrevious, pnPrevious);
  result->EntityDeclaration.aName = paName;
  cvn_to_ref(& result->EntityDeclaration.nPorts, pnPorts);
  cvn_to_ref(& result->EntityDeclaration.nDeclarations, pnDeclarations);
  return result;
}

cvn mArchitectureBody
(void * paToolInfo,
 unsigned paLine,
 cvn pnNext,
 cvn pnPrevious,
 char * paName,
 cvn pnDeclarations,
 cvn pnStatements,
 cvn pnPrimary)
{
  register cvn result;
  result = cvn_new(kArchitectureBody);
  result->ArchitectureBody.aToolInfo = paToolInfo;
  result->ArchitectureBody.aLine = paLine;
  cvn_to_ref(& result->ArchitectureBody.nNext, pnNext);
  cvn_to_ref(& result->ArchitectureBody.nPrevious, pnPrevious);
  result->ArchitectureBody.aName = paName;
  cvn_to_ref(& result->ArchitectureBody.nDeclarations, pnDeclarations);
  cvn_to_ref(& result->ArchitectureBody.nStatements, pnStatements);
  cvn_to_ref(& result->ArchitectureBody.nPrimary, pnPrimary);
  return result;
}

cvn mPackageDeclaration
(void * paToolInfo,
 unsigned paLine,
 cvn pnNext,
 cvn pnPrevious,
 char * paName,
 cvn pnDeclarations)
{
  register cvn result;
  result = cvn_new(kPackageDeclaration);
  result->PackageDeclaration.aToolInfo = paToolInfo;
  result->PackageDeclaration.aLine = paLine;
  cvn_to_ref(& result->PackageDeclaration.nNext, pnNext);
  cvn_to_ref(& result->PackageDeclaration.nPrevious, pnPrevious);
  result->PackageDeclaration.aName = paName;
  cvn_to_ref(& result->PackageDeclaration.nDeclarations, pnDeclarations);
  return result;
}

cvn mPackageBody
(void * paToolInfo,
 unsigned paLine,
 cvn pnNext,
 cvn pnPrevious,
 char * paName,
 cvn pnDeclarations,
 cvn pnPrimary)
{
  register cvn result;
  result = cvn_new(kPackageBody);
  result->PackageBody.aToolInfo = paToolInfo;
  result->PackageBody.aLine = paLine;
  cvn_to_ref(& result->PackageBody.nNext, pnNext);
  cvn_to_ref(& result->PackageBody.nPrevious, pnPrevious);
  result->PackageBody.aName = paName;
  cvn_to_ref(& result->PackageBody.nDeclarations, pnDeclarations);
  cvn_to_ref(& result->PackageBody.nPrimary, pnPrimary);
  return result;
}

cvn mIntegerType
(void * paToolInfo,
 cvn pnDeclaration,
 cvn pnRange)
{
  register cvn result;
  result = cvn_new(kIntegerType);
  result->IntegerType.aToolInfo = paToolInfo;
  cvn_to_ref(& result->IntegerType.nDeclaration, pnDeclaration);
  cvn_to_ref(& result->IntegerType.nRange, pnRange);
  return result;
}

cvn mEnumerationType
(void * paToolInfo,
 cvn pnDeclaration,
 cvn pnElements)
{
  register cvn result;
  result = cvn_new(kEnumerationType);
  result->EnumerationType.aToolInfo = paToolInfo;
  cvn_to_ref(& result->EnumerationType.nDeclaration, pnDeclaration);
  cvn_to_ref(& result->EnumerationType.nElements, pnElements);
  return result;
}

cvn mSubtype
(void * paToolInfo,
 cvn pnDeclaration,
 cvn pnBaseType,
 cvn pnConstraint)
{
  register cvn result;
  result = cvn_new(kSubtype);
  result->Subtype.aToolInfo = paToolInfo;
  cvn_to_ref(& result->Subtype.nDeclaration, pnDeclaration);
  cvn_to_ref(& result->Subtype.nBaseType, pnBaseType);
  cvn_to_ref(& result->Subtype.nConstraint, pnConstraint);
  return result;
}

cvn mTypeDeclaration
(void * paToolInfo,
 unsigned paLine,
 cvn pnNext,
 cvn pnPrevious,
 char * paName,
 cvn pnSubtype)
{
  register cvn result;
  result = cvn_new(kTypeDeclaration);
  result->TypeDeclaration.aToolInfo = paToolInfo;
  result->TypeDeclaration.aLine = paLine;
  cvn_to_ref(& result->TypeDeclaration.nNext, pnNext);
  cvn_to_ref(& result->TypeDeclaration.nPrevious, pnPrevious);
  result->TypeDeclaration.aName = paName;
  cvn_to_ref(& result->TypeDeclaration.nSubtype, pnSubtype);
  return result;
}

cvn mSubtypeDeclaration
(void * paToolInfo,
 unsigned paLine,
 cvn pnNext,
 cvn pnPrevious,
 char * paName,
 cvn pnSubtype)
{
  register cvn result;
  result = cvn_new(kSubtypeDeclaration);
  result->SubtypeDeclaration.aToolInfo = paToolInfo;
  result->SubtypeDeclaration.aLine = paLine;
  cvn_to_ref(& result->SubtypeDeclaration.nNext, pnNext);
  cvn_to_ref(& result->SubtypeDeclaration.nPrevious, pnPrevious);
  result->SubtypeDeclaration.aName = paName;
  cvn_to_ref(& result->SubtypeDeclaration.nSubtype, pnSubtype);
  return result;
}

cvn mSignalDeclaration
(void * paToolInfo,
 unsigned paLine,
 cvn pnNext,
 cvn pnPrevious,
 char * paName,
 cvn pnSubtype,
 tMode paMode,
 cvn pnDefaultValue)
{
  register cvn result;
  result = cvn_new(kSignalDeclaration);
  result->SignalDeclaration.aToolInfo = paToolInfo;
  result->SignalDeclaration.aLine = paLine;
  cvn_to_ref(& result->SignalDeclaration.nNext, pnNext);
  cvn_to_ref(& result->SignalDeclaration.nPrevious, pnPrevious);
  result->SignalDeclaration.aName = paName;
  cvn_to_ref(& result->SignalDeclaration.nSubtype, pnSubtype);
  result->SignalDeclaration.aMode = paMode;
  cvn_to_ref(& result->SignalDeclaration.nDefaultValue, pnDefaultValue);
  return result;
}

cvn mVariableDeclaration
(void * paToolInfo,
 unsigned paLine,
 cvn pnNext,
 cvn pnPrevious,
 char * paName,
 cvn pnSubtype,
 tMode paMode,
 cvn pnInitialValue)
{
  register cvn result;
  result = cvn_new(kVariableDeclaration);
  result->VariableDeclaration.aToolInfo = paToolInfo;
  result->VariableDeclaration.aLine = paLine;
  cvn_to_ref(& result->VariableDeclaration.nNext, pnNext);
  cvn_to_ref(& result->VariableDeclaration.nPrevious, pnPrevious);
  result->VariableDeclaration.aName = paName;
  cvn_to_ref(& result->VariableDeclaration.nSubtype, pnSubtype);
  result->VariableDeclaration.aMode = paMode;
  cvn_to_ref(& result->VariableDeclaration.nInitialValue, pnInitialValue);
  return result;
}

cvn mConstantDeclaration
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnSubtype, cvn pnValue)
{
 register cvn result;
 result = cvn_new(kConstantDeclaration);
 result->ConstantDeclaration.aToolInfo = paToolInfo;
 result->ConstantDeclaration.aLine = paLine;
 cvn_to_ref(& result->ConstantDeclaration.nNext, pnNext);
 cvn_to_ref(& result->ConstantDeclaration.nPrevious, pnPrevious);
 result->ConstantDeclaration.aName = paName;
 cvn_to_ref(& result->ConstantDeclaration.nSubtype, pnSubtype);
 cvn_to_ref(& result->ConstantDeclaration.nValue, pnValue);
 return result;
}

cvn mUnary
(void * paToolInfo, cvn pnSubtype, tOperator paOperator, cvn pnOperand)
{
 register cvn result;
 result = cvn_new(kUnary);
 result->Unary.aToolInfo = paToolInfo;
 cvn_to_ref(& result->Unary.nSubtype, pnSubtype);
 result->Unary.aOperator = paOperator;
 cvn_to_ref(& result->Unary.nOperand, pnOperand);
 return result;
}

cvn mBinary
(void * paToolInfo, cvn pnSubtype, tOperator paOperator, cvn pnLeft, cvn pnRight)
{
 register cvn result;
 result = cvn_new(kBinary);
 result->Binary.aToolInfo = paToolInfo;
 cvn_to_ref(& result->Binary.nSubtype, pnSubtype);
 result->Binary.aOperator = paOperator;
 cvn_to_ref(& result->Binary.nLeft, pnLeft);
 cvn_to_ref(& result->Binary.nRight, pnRight);
 return result;
}

cvn mIntegerValue
(void * paToolInfo, cvn pnSubtype, int paIntegerValue)
{
 register cvn result;
 result = cvn_new(kIntegerValue);
 result->IntegerValue.aToolInfo = paToolInfo;
 cvn_to_ref(& result->IntegerValue.nSubtype, pnSubtype);
 result->IntegerValue.aIntegerValue = paIntegerValue;
 return result;
}

cvn mRange
(void * paToolInfo, tDirection paDirection, cvn pnLeft, cvn pnRight)
{
 register cvn result;
 result = cvn_new(kRange);
 result->Range.aToolInfo = paToolInfo;
 result->Range.aDirection = paDirection;
 cvn_to_ref(& result->Range.nLeft, pnLeft);
 cvn_to_ref(& result->Range.nRight, pnRight);
 return result;
}

cvn mIfStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnBranches)
{
 register cvn result;
 result = cvn_new(kIfStatement);
 result->IfStatement.aToolInfo = paToolInfo;
 result->IfStatement.aLine = paLine;
 cvn_to_ref(& result->IfStatement.nNext, pnNext);
 cvn_to_ref(& result->IfStatement.nPrevious, pnPrevious);
 result->IfStatement.aName = paName;
 cvn_to_ref(& result->IfStatement.nBranches, pnBranches);
 return result;
}

cvn mBranch
(void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnCondition, cvn pnStatements)
{
 register cvn result;
 result = cvn_new(kBranch);
 result->Branch.aToolInfo = paToolInfo;
 cvn_to_ref(& result->Branch.nNext, pnNext);
 cvn_to_ref(& result->Branch.nPrevious, pnPrevious);
 cvn_to_ref(& result->Branch.nCondition, pnCondition);
 cvn_to_ref(& result->Branch.nStatements, pnStatements);
 return result;
}

cvn mCaseStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnSelector, cvn pnAlternatives)
{
 register cvn result;
 result = cvn_new(kCaseStatement);
 result->CaseStatement.aToolInfo = paToolInfo;
 result->CaseStatement.aLine = paLine;
 cvn_to_ref(& result->CaseStatement.nNext, pnNext);
 cvn_to_ref(& result->CaseStatement.nPrevious, pnPrevious);
 result->CaseStatement.aName = paName;
 cvn_to_ref(& result->CaseStatement.nSelector, pnSelector);
 cvn_to_ref(& result->CaseStatement.nAlternatives, pnAlternatives);
 return result;
}

cvn mWhileStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnStatements, cvn pnCondition)
{
 register cvn result;
 result = cvn_new(kWhileStatement);
 result->WhileStatement.aToolInfo = paToolInfo;
 result->WhileStatement.aLine = paLine;
 cvn_to_ref(& result->WhileStatement.nNext, pnNext);
 cvn_to_ref(& result->WhileStatement.nPrevious, pnPrevious);
 result->WhileStatement.aName = paName;
 cvn_to_ref(& result->WhileStatement.nStatements, pnStatements);
 cvn_to_ref(& result->WhileStatement.nCondition, pnCondition);
 return result;
}

cvn mForStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnStatements, cvn pnParameter, cvn pnRange)
{
 register cvn result;
 result = cvn_new(kForStatement);
 result->ForStatement.aToolInfo = paToolInfo;
 result->ForStatement.aLine = paLine;
 cvn_to_ref(& result->ForStatement.nNext, pnNext);
 cvn_to_ref(& result->ForStatement.nPrevious, pnPrevious);
 result->ForStatement.aName = paName;
 cvn_to_ref(& result->ForStatement.nStatements, pnStatements);
 cvn_to_ref(& result->ForStatement.nParameter, pnParameter);
 cvn_to_ref(& result->ForStatement.nRange, pnRange);
 return result;
}

cvn mAlternative
(void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnChoices, cvn pnStatements)
{
 register cvn result;
 result = cvn_new(kAlternative);
 result->Alternative.aToolInfo = paToolInfo;
 cvn_to_ref(& result->Alternative.nNext, pnNext);
 cvn_to_ref(& result->Alternative.nPrevious, pnPrevious);
 cvn_to_ref(& result->Alternative.nChoices, pnChoices);
 cvn_to_ref(& result->Alternative.nStatements, pnStatements);
 return result;
}

cvn mWaitStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnCondition, cvn pnSignals)
{
 register cvn result;
 result = cvn_new(kWaitStatement);
 result->WaitStatement.aToolInfo = paToolInfo;
 result->WaitStatement.aLine = paLine;
 cvn_to_ref(& result->WaitStatement.nNext, pnNext);
 cvn_to_ref(& result->WaitStatement.nPrevious, pnPrevious);
 result->WaitStatement.aName = paName;
 cvn_to_ref(& result->WaitStatement.nCondition, pnCondition);
 cvn_to_ref(& result->WaitStatement.nSignals, pnSignals);
 return result;
}

cvn mVariableAssignmentStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnTarget, cvn pnSource)
{
 register cvn result;
 result = cvn_new(kVariableAssignmentStatement);
 result->VariableAssignmentStatement.aToolInfo = paToolInfo;
 result->VariableAssignmentStatement.aLine = paLine;
 cvn_to_ref(& result->VariableAssignmentStatement.nNext, pnNext);
 cvn_to_ref(& result->VariableAssignmentStatement.nPrevious, pnPrevious);
 result->VariableAssignmentStatement.aName = paName;
 cvn_to_ref(& result->VariableAssignmentStatement.nTarget, pnTarget);
 cvn_to_ref(& result->VariableAssignmentStatement.nSource, pnSource);
 return result;
}

cvn mNullStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName)
{
 register cvn result;
 result = cvn_new(kNullStatement);
 result->NullStatement.aToolInfo = paToolInfo;
 result->NullStatement.aLine = paLine;
 cvn_to_ref(& result->NullStatement.nNext, pnNext);
 cvn_to_ref(& result->NullStatement.nPrevious, pnPrevious);
 result->NullStatement.aName = paName;
 return result;
}

cvn mWaveform
(void * paToolInfo, cvn pnValue)
{
 register cvn result;
 result = cvn_new(kWaveform);
 result->Waveform.aToolInfo = paToolInfo;
 cvn_to_ref(& result->Waveform.nValue, pnValue);
 return result;
}

cvn mSignalAssignmentStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnTarget, cvn pnSource)
{
 register cvn result;
 result = cvn_new(kSignalAssignmentStatement);
 result->SignalAssignmentStatement.aToolInfo = paToolInfo;
 result->SignalAssignmentStatement.aLine = paLine;
 cvn_to_ref(& result->SignalAssignmentStatement.nNext, pnNext);
 cvn_to_ref(& result->SignalAssignmentStatement.nPrevious, pnPrevious);
 result->SignalAssignmentStatement.aName = paName;
 cvn_to_ref(& result->SignalAssignmentStatement.nTarget, pnTarget);
 cvn_to_ref(& result->SignalAssignmentStatement.nSource, pnSource);
 return result;
}

cvn mBlockStatement
(void * paToolInfo, cvn pnDeclarations, cvn pnStatements, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName)
{
 register cvn result;
 result = cvn_new(kBlockStatement);
 result->BlockStatement.aToolInfo = paToolInfo;
 result->BlockStatement.aLine = paLine;
 cvn_to_ref(& result->BlockStatement.nNext, pnNext);
 cvn_to_ref(& result->BlockStatement.nPrevious, pnPrevious);
 result->BlockStatement.aName = paName;
 cvn_to_ref(& result->BlockStatement.nDeclarations, pnDeclarations);
 cvn_to_ref(& result->BlockStatement.nStatements, pnStatements);
 return result;
}

cvn mProcessStatement
(void * paToolInfo, cvn pnSensitivityList, cvn pnDeclarations, cvn pnStatements, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName)
{
 register cvn result;
 result = cvn_new(kProcessStatement);
 result->ProcessStatement.aToolInfo = paToolInfo;
 result->ProcessStatement.aLine = paLine;
 cvn_to_ref(& result->ProcessStatement.nNext, pnNext);
 cvn_to_ref(& result->ProcessStatement.nPrevious, pnPrevious);
 result->ProcessStatement.aName = paName;
 cvn_to_ref(& result->ProcessStatement.nSensitivityList, pnSensitivityList);
 cvn_to_ref(& result->ProcessStatement.nDeclarations, pnDeclarations);
 cvn_to_ref(& result->ProcessStatement.nStatements, pnStatements);
 return result;
}

cvn mConditionalWaveform
(void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnValue, cvn pnCondition)
{
 register cvn result;
 result = cvn_new(kConditionalWaveform);
 result->ConditionalWaveform.aToolInfo = paToolInfo;
 cvn_to_ref(& result->ConditionalWaveform.nNext, pnNext);
 cvn_to_ref(& result->ConditionalWaveform.nPrevious, pnPrevious);
 cvn_to_ref(& result->ConditionalWaveform.nValue, pnValue);
 cvn_to_ref(& result->ConditionalWaveform.nCondition, pnCondition);
 return result;
}

cvn mConditionalSignalAssignmentStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnTarget, cvn pnSource)
{
 register cvn result;
 result = cvn_new(kConditionalSignalAssignmentStatement);
 result->ConditionalSignalAssignmentStatement.aToolInfo = paToolInfo;
 result->ConditionalSignalAssignmentStatement.aLine = paLine;
 cvn_to_ref(& result->ConditionalSignalAssignmentStatement.nNext, pnNext);
 cvn_to_ref(& result->ConditionalSignalAssignmentStatement.nPrevious, pnPrevious);
 result->ConditionalSignalAssignmentStatement.aName = paName;
 cvn_to_ref(& result->ConditionalSignalAssignmentStatement.nTarget, pnTarget);
 cvn_to_ref(& result->ConditionalSignalAssignmentStatement.nSource, pnSource);
 return result;
}

cvn mSelectedSignalAssignmentStatement
(void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnTarget, cvn pnSelector, cvn pnAlternatives)
{
 register cvn result;
 result = cvn_new(kSelectedSignalAssignmentStatement);
 result->SelectedSignalAssignmentStatement.aToolInfo = paToolInfo;
 result->SelectedSignalAssignmentStatement.aLine = paLine;
 cvn_to_ref(& result->SelectedSignalAssignmentStatement.nNext, pnNext);
 cvn_to_ref(& result->SelectedSignalAssignmentStatement.nPrevious, pnPrevious);
 result->SelectedSignalAssignmentStatement.aName = paName;
 cvn_to_ref(& result->SelectedSignalAssignmentStatement.nTarget, pnTarget);
 cvn_to_ref(& result->SelectedSignalAssignmentStatement.nSelector, pnSelector);
 cvn_to_ref(& result->SelectedSignalAssignmentStatement.nAlternatives, pnAlternatives);
 return result;
}

cvn mUseClause
(void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnSelectedNames)
{
 register cvn result;
 result = cvn_new(kUseClause);
 result->UseClause.aToolInfo = paToolInfo;
 cvn_to_ref(& result->UseClause.nNext, pnNext);
 cvn_to_ref(& result->UseClause.nPrevious, pnPrevious);
 cvn_to_ref(& result->UseClause.nSelectedNames, pnSelectedNames);
 return result;
}

cvn mIdentifier
(void * paToolInfo, char * paName, cvn pnDeclaration)
{
 register cvn result;
 result = cvn_new(kIdentifier);
 result->Identifier.aToolInfo = paToolInfo;
 result->Identifier.aName = paName;
 cvn_to_ref(& result->Identifier.nDeclaration, pnDeclaration);
 return result;
}

cvn mCharacterLiteral
(void * paToolInfo, char * paName, unsigned paOrdinalValue, cvn pnDeclaration)
{
 register cvn result;
 result = cvn_new(kCharacterLiteral);
 result->CharacterLiteral.aToolInfo = paToolInfo;
 result->CharacterLiteral.aName = paName;
 result->CharacterLiteral.aOrdinalValue = paOrdinalValue;
 cvn_to_ref(& result->CharacterLiteral.nDeclaration, pnDeclaration);
 return result;
}

cvn mEnumeratedLiteral
(void * paToolInfo, char * paName, unsigned paOrdinalValue, cvn pnDeclaration)
{
 register cvn result;
 result = cvn_new(kEnumeratedLiteral);
 result->EnumeratedLiteral.aToolInfo = paToolInfo;
 result->EnumeratedLiteral.aName = paName;
 result->EnumeratedLiteral.aOrdinalValue = paOrdinalValue;
 cvn_to_ref(& result->EnumeratedLiteral.nDeclaration, pnDeclaration);
 return result;
}

