#if !defined _CVINTH
#define _CVINTH

#include "cv.h"

typedef struct ref_ {
  unsigned unit;
  unsigned offset;
} ref;

typedef union cvn_rec_ {
  struct {
    ref position;
    void * aToolInfo;
    tKind aKind;
  } header;
  struct {                           /* List */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nNext;
    ref nPrevious;
    ref nValue;
  } List;
  struct {                           /* EntityDeclaration */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nPorts;
    ref nDeclarations;
  } EntityDeclaration;
  struct {                           /* ArchitectureBody */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nDeclarations;
    ref nStatements;
    ref nPrimary;
  } ArchitectureBody;
  struct {                           /* Package declaration */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nDeclarations;
  } PackageDeclaration;
  struct {                           /* Package body */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nDeclarations;
    ref nPrimary;
  } PackageBody;
  struct {                           /* Integer type */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nDeclaration;
    ref nRange;
  } IntegerType;
  struct {                            /* Enumeration type */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nDeclaration;
    ref nElements;
  } EnumerationType;
  struct {                             /* Subtype */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nDeclaration;
    ref nBaseType;
    ref nConstraint;
  } Subtype;
  struct {                              /* Type declaration */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nSubtype;
  } TypeDeclaration;
  struct {                              /* Subtype declaration */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nSubtype;
  } SubtypeDeclaration;
  struct {                              /* Signal declaration */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nSubtype;
    tMode aMode;
    ref nDefaultValue;
  } SignalDeclaration;
  struct {                             /* Variable declaration */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nSubtype;
    tMode aMode;
    ref nInitialValue;
  } VariableDeclaration;
  struct {                             /* Constant declaration */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nSubtype;
    ref nValue;
  } ConstantDeclaration;
  struct {                             /* Unary */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nSubtype;
    tOperator aOperator;
    ref nOperand;
  } Unary;
  struct {                             /* Binary */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nSubtype;
    tOperator aOperator;
    ref nLeft;
    ref nRight;
  } Binary;
  struct {                             /* Integer value */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nSubtype;
    int aIntegerValue;
  } IntegerValue;
  struct {                             /* Range */
    ref position;
    void * aToolInfo;
    tKind aKind;
    tDirection aDirection;
    ref nLeft;
    ref nRight;
  } Range;
  struct {                             /* If statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nBranches;
  } IfStatement;
  struct {                             /* Branch */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nNext;
    ref nPrevious;
    ref nCondition;
    ref nStatements;
  } Branch;
  struct {                             /* Case statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nSelector;
    ref nAlternatives;
  } CaseStatement;
  struct {                             /* While statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nStatements;
    ref nCondition;
  } WhileStatement;
  struct {                             /* For statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nStatements;
    ref nParameter;
    ref nRange;
  } ForStatement;
  struct {                             /* Alternative */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nNext;
    ref nPrevious;
    ref nChoices;
    ref nStatements;
  } Alternative;
  struct {                             /* Wait statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nCondition;
    ref nSignals;
  } WaitStatement;
  struct {                             /* Variable assignment statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nTarget;
    ref nSource;
  } VariableAssignmentStatement;
  struct {                             /* Null statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
  } NullStatement;
  struct {                             /* Waveform */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nValue;
  } Waveform;
  struct {                            /* Signal assignment statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nTarget;
    ref nSource;
  } SignalAssignmentStatement;
  struct {                            /* Block statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nDeclarations;
    ref nStatements;
  } BlockStatement;
  struct {                            /* Process statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nSensitivityList;
    ref nDeclarations;
    ref nStatements;
  } ProcessStatement;
  struct {                            /* Conditional waveform */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nNext;
    ref nPrevious;
    ref nValue;
    ref nCondition;
  } ConditionalWaveform;
  struct {                            /* Conditional signal assignment statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nTarget;
    ref nSource;
  } ConditionalSignalAssignmentStatement;
  struct {                           /* Selected signal assignment statement */
    ref position;
    void * aToolInfo;
    tKind aKind;
    unsigned aLine;
    ref nNext;
    ref nPrevious;
    char * aName;
    ref nTarget;
    ref nSelector;
    ref nAlternatives;
  } SelectedSignalAssignmentStatement;
  struct {                           /* Use clause */
    ref position;
    void * aToolInfo;
    tKind aKind;
    ref nNext;
    ref nPrevious;
    ref nSelectedNames;
  } UseClause;
  struct {                           /* Identifier */
    ref position;
    void * aToolInfo;
    tKind aKind;
    char * aName;
    ref nDeclaration;
  } Identifier;
  struct {                           /* Character literal */
    ref position;
    void * aToolInfo;
    tKind aKind;
    char * aName;
    unsigned aOrdinalValue;
    ref nDeclaration;
  } CharacterLiteral;
  struct {                           /* Enumerated literal */
    ref position;
    void * aToolInfo;
    tKind aKind;
    char * aName;
    unsigned aOrdinalValue;
    ref nDeclaration;
  } EnumeratedLiteral;
} cvn_rec;

/* -- constants -- */

extern const unsigned no_unit;

/* -- routines -- */

extern cvn ref_to_cvn (const ref);
extern void cvn_to_ref (ref *, const cvn);
extern void write_cvn(cvn, FILE *);
extern cvn read_cvn(FILE *, ref);
extern cvn cvn_alloc (tKind);
extern void translate_cvn (cvn, unsigned *);

#endif /* _CVINTH */
