#if !defined _CVH
#  define _CVH

#include <stdio.h>

#define NB_KINDS 37
typedef enum {kList,
              kEntityDeclaration,
              kArchitectureBody,
              kPackageDeclaration,
              kPackageBody,
              kIntegerType,
              kEnumerationType,
              kSubtype,
              kTypeDeclaration,
              kSubtypeDeclaration,
              kSignalDeclaration,
              kVariableDeclaration,
              kConstantDeclaration,
              kUnary,
              kBinary,
              kIntegerValue,
              kRange,
              kIfStatement,
              kBranch,
              kCaseStatement,
              kWhileStatement,
              kForStatement,
              kAlternative,
              kWaitStatement,
              kVariableAssignmentStatement,
              kNullStatement,
              kWaveform,
              kSignalAssignmentStatement,
              kBlockStatement,
              kProcessStatement,
              kConditionalWaveform,
              kConditionalSignalAssignmentStatement,
              kSelectedSignalAssignmentStatement,
              kUseClause,
              kIdentifier,
              kCharacterLiteral,
              kEnumeratedLiteral} tKind;

#   define NB_MODES 5
typedef enum {kDefaultMode, kIn, kOut, kInternal, kInout} tMode;

extern char * if_Mode[];

#   define NB_CLASSES 4
typedef enum {kDefaultClass, kConstant, kSignal, kVariable} tClass;

extern char * if_Class[];

#   define NB_OPERATORS 22
typedef enum {kDefaultOperator,
              kNot, kAbs, 
              kAnd, kOr, kNand, kNor, kXor, kXnor,
              kEq, kNeq, kGt, kGe, kLt, kLe,
              kPlus, kMinus, kCatenate,
              kTimes, kDivide, kMod, kRem} tOperator;

extern char * if_Operator[];

#   define NB_DIRECTIONS 3
typedef enum {kDefaultDirection, kTo, kDownto} tDirection;

extern char * if_Direction[];

typedef union cvn_rec_ * cvn;

/* -- variables -- */
extern cvn std_clause;
extern cvn integer_type, boolean_type, bit_type;
extern cvn false_literal, true_literal;
extern cvn bit0_literal, bit1_literal;

/* -- routines -- */

/* -- display -- */
extern void cvn_display (FILE *, cvn);

/* -- list -- */
extern cvn cv_list_union (cvn, cvn, int (*) (const cvn, const cvn));
extern cvn cv_list_add (cvn, cvn, int (*) (const cvn, const cvn));
extern int cv_list_size (const cvn);

/* -- make -- */
extern cvn mList (void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnValue);
extern cvn mEntityDeclaration (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnPorts, cvn pnDeclarations);
extern cvn mArchitectureBody (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnDeclarations, cvn pnStatements, cvn pnPrimary);
extern cvn mPackageDeclaration (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnDeclarations);
extern cvn mPackageBody (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnDeclarations, cvn pnPrimary);
extern cvn mIntegerType (void * paToolInfo, cvn pnDeclaration, cvn pnRange);
extern cvn mEnumerationType (void * paToolInfo, cvn pnDeclaration, cvn pnElements);
extern cvn mSubtype (void * paToolInfo, cvn pnDeclaration, cvn pnBaseType, cvn pnConstraint);
extern cvn mTypeDeclaration (void * paToolInfo, unsigned paLine, cvn pnNext,
 cvn pnPrevious, char * paName, cvn pnSubtype);
extern cvn mSubtypeDeclaration (void * paToolInfo, unsigned paLine, cvn pnNext,
 cvn pnPrevious, char * paName, cvn pnSubtype);
extern cvn mSignalDeclaration (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnSubtype, tMode paMode, cvn pnDefaultValue);
extern cvn mVariableDeclaration (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnSubtype, tMode paMode, cvn pnInitialValue);
extern cvn mConstantDeclaration (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnSubtype, cvn pnValue);
extern cvn mUnary (void * paToolInfo, cvn pnSubtype, tOperator paOperator, cvn pnOperand);
extern cvn mBinary (void * paToolInfo, cvn pnSubtype, tOperator paOperator, cvn pnLeft, cvn pnRight);
extern cvn mIntegerValue (void * paToolInfo, cvn pnSubtype, int paIntegerValue);
extern cvn mRange (void * paToolInfo, tDirection paDirection, cvn pnLeft, cvn pnRight);
extern cvn mIfStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnBranches);
extern cvn mBranch (void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnCondition, cvn pnStatements);
extern cvn mCaseStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnSelector, cvn pnAlternatives);
extern cvn mWhileStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnStatements, cvn pnCondition);
extern cvn mForStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnStatements, cvn pnParameter, cvn pnRange);
extern cvn mAlternative (void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnChoices, cvn pnStatements);
extern cvn mWaitStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnCondition, cvn pnSignals);
extern cvn mVariableAssignmentStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnTarget, cvn pnSource);
extern cvn mNullStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName);
extern cvn mWaveform (void * paToolInfo, cvn pnValue);
extern cvn mSignalAssignmentStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnTarget, cvn pnSource);
extern cvn mBlockStatement (void * paToolInfo, cvn pnDeclarations, cvn pnStatements, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName);
extern cvn mProcessStatement (void * paToolInfo, cvn pnSensitivityList, cvn pnDeclarations, cvn pnStatements, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName);
extern cvn mConditionalWaveform (void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnValue, cvn pnCondition);
extern cvn mConditionalSignalAssignmentStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnTarget, cvn pnSource);
extern cvn mSelectedSignalAssignmentStatement (void * paToolInfo, unsigned paLine, cvn pnNext, cvn pnPrevious, char * paName, cvn pnTarget, cvn pnSelector, cvn pnAlternatives);
extern cvn mUseClause (void * paToolInfo, cvn pnNext, cvn pnPrevious, cvn pnSelectedNames);
extern cvn mIdentifier (void * paToolInfo, char * paName, cvn pnDeclaration);
extern cvn mCharacterLiteral (void * paToolInfo, char * paName, unsigned paOrdinalValue, cvn pnDeclaration);
cvn mEnumeratedLiteral (void * paToolInfo, char * paName, unsigned paOrdinalValue, cvn pnDeclaration);

/* -- manager -- */
extern char * cv_version(void);
extern void cv_initialize(void);
extern cvn cv_load_unit(char *, char *, char *);
extern cvn cvn_new(const tKind);
extern cvn cvn_copy(const cvn);
extern void cv_reset_store(void);
extern int cv_save_store(cvn root);

/* -- misc -- */
extern cvn cv_expression_support(const cvn);
extern cvn cv_signal_support(const cvn);
extern cvn cv_wait_sensitivity_list (const cvn);

/* -- query -- */
extern int IsA(const cvn t, const tKind k);
extern int NullNode(const cvn t);
extern int cv_eq(const cvn t1, const cvn t2);
extern int cv_eq_decl(const cvn t1, const cvn t2);
extern cvn qFirst (const cvn t);
extern cvn qPrimary (const cvn t);
extern cvn qLast (const cvn t);
extern cvn qNext (const cvn t);
extern cvn qPrevious (const cvn t);
extern cvn qValue (const cvn t);
extern cvn qSensitivityList (const cvn t);
extern cvn qDeclarations (const cvn t);
extern cvn qStatements (const cvn t);
extern cvn qPorts (const cvn t);
extern cvn qEntity (const cvn t);
extern cvn qDeclaration (const cvn t);
extern cvn qLeft (const cvn t);
extern cvn qRight (const cvn t);
extern cvn qElements (const cvn t);
extern cvn qSubtype (const cvn t);
extern cvn qBaseType (const cvn t);
extern cvn qDefaultValue (const cvn t);
extern cvn qInitialValue (const cvn t);
extern cvn qOperand (const cvn t);
extern cvn qBranches (const cvn t);
extern cvn qCondition (const cvn t);
extern cvn qSelector (const cvn t);
extern cvn qAlternatives (const cvn t);
extern cvn qChoices (const cvn t);
extern cvn qSignals (const cvn t);
extern cvn qTarget (const cvn t);
extern cvn qSource (const cvn t);
extern tKind qKind (const cvn t);
extern void * qToolInfo (const cvn t);
extern unsigned qLine (const cvn t);
extern char * qName (const cvn t);
extern unsigned qOrdinalValue (const cvn t);
extern tMode qMode (const cvn t);
extern tDirection qDirection (const cvn t);
extern tOperator qOperator (const cvn t);
extern int qIntegerValue (const cvn t);
extern cvn qRange(const cvn t);
extern cvn qConstraint(const cvn t);
extern cvn qUpper(const cvn t);
extern cvn qLower(const cvn t);
extern cvn qSelectedNames(const cvn t);

/* -- set -- */
extern void sFirst (const cvn t, const cvn c);
extern void sPrimary (const cvn t, const cvn c);
extern void sLast (const cvn t, const cvn c);
extern void sNext (const cvn t, const cvn c);
extern void sPrevious (const cvn t, const cvn c);
extern void sValue (const cvn t, const cvn c);
extern void sSensitivityList (const cvn t, const cvn c);
extern void sDeclarations (const cvn t, const cvn c);
extern void sStatements (const cvn t, const cvn c);
extern void sPorts (const cvn t, const cvn c);
extern void sEntity (const cvn t, const cvn c);
extern void sDeclaration (const cvn t, const cvn c);
extern void sLeft (const cvn t, const cvn c);
extern void sRight (const cvn t, const cvn c);
extern void sElements (const cvn t, const cvn c);
extern void sSubtype (const cvn t, const cvn c);
extern void sBaseType (const cvn t, const cvn c);
extern void sDefaultValue (const cvn t, const cvn c);
extern void sInitialValue (const cvn t, const cvn c);
extern void sOperand (const cvn t, const cvn c);
extern void sBranches (const cvn t, const cvn c);
extern void sCondition (const cvn t, const cvn c);
extern void sSelector (const cvn t, const cvn c);
extern void sAlternatives (const cvn t, const cvn c);
extern void sChoices (const cvn t, const cvn c);
extern void sSignals (const cvn t, const cvn c);
extern void sTarget (const cvn t, const cvn c);
extern void sSource (const cvn t, const cvn c);
extern void sToolInfo (const cvn t, void * i);
extern void sLine (const cvn t, unsigned l);
extern void sName (const cvn t, char * n);
extern void sOrdinalValue (const cvn t, unsigned o);
extern void sMode (const cvn t, tMode m);
extern void sDirection (const cvn t, tDirection m);
extern void sOperator (const cvn t, tOperator c);
extern void sIntegerValue (const cvn t, int c);
extern void sRange (const cvn t, const cvn c);
extern void sConstraint (const cvn t, const cvn c);
extern void sSelectedNames (const cvn t, const cvn c);

/* -- subtype -- */

extern int cv_subtype_size (const cvn);
extern cvn cv_subtype_nth (const cvn, int);

#endif _CVH
