/** CHeaderFile ********************************************************

  FileName    [ ctlInt.h ]

  PackageName [ ctl ]

  Synopsis    [ Type definition ]

  Description [ This header file holds the private type definition
  for a CTL formula ]

  SeeAlso     [ ctl.h ]

  Author      [ David Deharbe. ]

  Copyright   [ Copyright (c) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Log$ ]

***********************************************************************/
#ifndef _CTLINT
#define _CTLINT

#include "ctl.h"

/*--------------------------------------------------------------------*/
/* Constant declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/

typedef union {
  pointer atom;
  struct {
    ctl_Operator_t op;
    ctl_term arg1;
    ctl_term arg2;
  } bin;
  struct {
    ctl_Operator_t op;
    ctl_term arg;
  } un;
  struct {
    ctl_Operator_t op;
  } macro;
} ctlTerm_t__;

typedef struct ctlTermStruct {
  ctl_term link;
  pointer info;
  ctl_Type_t type;
  ctlTerm_t__ cell;
} ctlTerm_t_;

/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern void ctlBasicSOperator(ctl_term t, ctl_Operator_t op);
extern void ctlBasicSArgument(ctl_term t, ctl_term arg);
extern void ctlBasicSArgument2(ctl_term t, ctl_term arg);

/**AutomaticEnd********************************************************/

#endif /* _CTLINT */
