/** CHeaderFile ********************************************************

  FileName    [ ctl.h ]

  PackageName [ ctl ]

  Synopsis    [ Computation Tree Logic syntax ]

  Description [ This package defines a C implementation for CTL
  formulas: constant, type, constructor and destructor routines.
  To add: a rewriting system that decreases the number of temporal
  logic operators in a formula. ]

  SeeAlso     [ ]

  Author      [ David Deharbe. ]

  Copyright   [ Copyright (c) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Log$ ]

***********************************************************************/
#ifndef _CTL
#define _CTL

#include <memuser.h>
#include <Errors.h>

/*--------------------------------------------------------------------*/
/* Constant declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/
typedef struct ctlTermStruct * ctl_term;
typedef enum {ctl_BinaryTerm, ctl_UnaryTerm, ctl_AtomicTerm,
              ctl_MacroTerm} ctl_Type_t;
/* list of the TL operators */
typedef enum {ctl_EX, ctl_AX, ctl_EF, ctl_AF, ctl_EG, ctl_AG, 
              ctl_EU, ctl_AU, ctl_EW, ctl_AW,
              ctl_Implies, ctl_Not,
              ctl_And, ctl_Or, ctl_Xor, ctl_Xnor,
              ctl_Nand, ctl_Nor,
              ctl_Stable} ctl_Operator_t;
typedef void (* ctl_TerminalDisplayFn_t) (FILE *, pointer);
typedef void * (* ctl_TerminalSupportFn_t) (void *, void * env);
typedef void * (* ctl_SupportUnionFn_t) (void *, void *, void * env);

/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern ctl_term ctl_BasicNew(ctl_term link, pointer info, ctl_Type_t type, ...);
extern void ctl_BasicFree(ctl_term t);
extern ctl_Type_t ctl_BasicQType(ctl_term t);
extern void ctl_BasicSType(ctl_term t, ctl_Type_t type);
extern ctl_term ctl_BasicQNext(ctl_term t);
extern ctl_term ctl_BasicSNext(ctl_term t, ctl_term link);
extern pointer ctl_BasicQInfo(ctl_term t);
extern void ctl_BasicSInfo(ctl_term t, pointer info);
extern ctl_Operator_t ctl_BasicQOperator(ctl_term t);
extern ctl_term ctl_BasicQArgument(ctl_term t);
extern ctl_term ctl_BasicQArgument2(ctl_term t);
extern pointer ctl_BasicQAtomicTerm(ctl_term t);
extern ctl_Operator_t ctl_BasicQMacro(ctl_term t);
extern void ctl_DisplayText(FILE * outstream, ctl_term t, ctl_TerminalDisplayFn_t fn);
extern int ctl_MiscSupport(ctl_term t, ctl_TerminalSupportFn_t support_fn, ctl_SupportUnionFn_t union_fn, void * env, void ** result);
extern int ctl_MiscIsInvariant(ctl_term t);
extern ctl_term ctl_RewriteTerm(ctl_term t);

/**AutomaticEnd********************************************************/

#endif /* _CTL */
