/** CHeaderFile ********************************************************

  FileName    [ cache.h ]

  PackageName [ cache ]

  Synopsis    [ Management of generic caches. ]

  Description [ This package implements different generic caches
  structures. It requires hashed data to be lists, i.e. pointers to 
  structures with an aligned _first_ field named link that is itself
  the address of such structure. 
  The first type of cache (cache1_mgr) is a LRU, fixed size cache with
  one entry per line.
  The second type of cache (cacheX_mgr) is a non-fixed size cache, based
  on McMillan's implementation of hashing in smv(1) and David Long's bdd(3)
  package.
  Memory management is performed with David Long's mem(3) package. 
  Link with -lhash -lmem. ]

  SeeAlso     [ smv(1), mem(3) ]

  Author      [ D. Dharbe (using code from K. McMillan and D.Long) ]

  Copyright   [ Copyright (c) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Id$ ]

***********************************************************************/
#ifndef _CACHE
#define _CACHE

#include <memuser.h>

/*--------------------------------------------------------------------*/
/* Constant declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/

/* cache_mgr hash managers handle the accesses to a hash table */
typedef struct rec_ * rec_ptr;
typedef struct cacheX_ * cacheX_mgr;
typedef struct cache1_ * cache1_mgr;

/* hash_fun hash functions are used to hash data */ 
typedef long (* hash_function)(pointer, pointer env);
/* eq_fun equality functions are used as a predicate equality for data */
typedef int (* eq_function)(pointer, pointer, pointer env);
/* del_fun delete function */
typedef void (* del_function)(pointer, pointer env);

/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern cache1_mgr cache_1New(long init_size, hash_function hash, eq_function equal, del_function delete, pointer env, float rehash_threshold, float resize_factor);
extern void cache_1Free(cache1_mgr c);
extern void cache_1Reset(cache1_mgr cache);
extern void cache_1Stats(cache1_mgr cache, FILE * outstream);
extern pointer cache_1Find(cache1_mgr cache, pointer ptr);
extern void cache_1Insert(cache1_mgr cache, pointer ptr);
extern int cache_1Remove(cache1_mgr cache, pointer ptr);
extern cacheX_mgr cache_XNew(long init_size, hash_function hashcode, eq_function equality, del_function delete, pointer env, rec_mgr memory, float rehash_threshold, float resize_factor);
extern void cache_XFree(cacheX_mgr c);
extern void cache_XReset(cacheX_mgr cache);
extern pointer cache_XFind(cacheX_mgr cache, rec_ptr ptr);
extern void cache_XInsert(cacheX_mgr cache, rec_ptr ptr);
extern int cache_XRemove(cacheX_mgr cache, rec_ptr ptr);

/**AutomaticEnd********************************************************/

#endif /* _HASH */
