/* Basic BDD routines */

#include "bddint.h"

/* bdd_short_stats(bddm, fp) prints few statistics to the file indicated */
/* by fp. */

#include <stdio.h>
void
#if defined(__STDC__)
bdd_short_stats(bdd_manager bddm, FILE *fp)
#else
bdd_short_stats(bddm, fp)
     bdd_manager bddm;
     FILE *fp;
#endif
{
  long i;
  long ue, ce, cs, mem;
  assoc_list q;

  ue=bddm->unique_table.entries;
  ce=bddm->op_cache.entries;
  cs=bddm->op_cache.size;
  mem=0;
  for (i=0; i < bddm->vars; ++i)
    {
      mem+=sizeof(struct var_table_);
      mem+=bddm->unique_table.tables[i]->size*sizeof(bdd);
    }
  mem=ue*sizeof(struct bdd_);
  mem+=cs*sizeof(struct cache_bin_)+ce*sizeof(struct cache_entry_);
  mem+=bddm->maxvars*(sizeof(bdd_index_type)+sizeof(bdd_indexindex_type)+sizeof(bdd)+sizeof(var_table));
  for (q=bddm->assocs, i=1; q; q=q->next, ++i);
  mem+=i*bddm->maxvars*sizeof(bdd);
  fprintf(fp, "Approximate bytes used: %ld\n", mem);
  fprintf(fp, "Number of nodes: %ld\n", ue);
  fprintf(fp, "Number of variables: %ld\n", bddm->vars);
}

