/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    vbdd.h                                                    */
/*                                                              */
/* Description:                                                 */
/*    Declarations of extra routines that manipulate vectors of */
/*    BDDs.      						*/
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#if !defined(_VBDD_RELATH)
#   define _VBDD_RELATH

#   include "vbdd.h"

#if defined(__STDC__)
#define ARGS(args) args
#else
#define ARGS(args) ()
#endif

/* ------------------------------------------------------------ */

extern bdd vbdd_eq
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_eq_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_neq
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_neq_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_le
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_le_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_lt
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_lt_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_ge
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_ge_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_gt
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern bdd vbdd_gt_up
   ARGS((bdd_manager, vbdd, vbdd)) ;

#endif _VBDD_RELATH
