/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    vbdd_print.c                                              */
/*                                                              */
/* Description:                                                 */
/*    Extra routines that manipulate BDDs.                      */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#include "vbdd_print.h"
#include "bdd_misc.h"

void vbdd_print
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a)
#else
   (bddm, a)
   bdd_manager bddm ;
   vbdd a ;
#endif
{
  bdd * t;
  for (t = vbdd_elements(a); * t; ++t)
    bdd_print(bddm, * t) ;
}

void vbdd_print_bdd
#if defined(__STDC__)
   (bdd_manager bddm, 
    vbdd a,
    char * (* f) (bdd_manager, bdd, pointer), 
    pointer e)
#else
  (bddm, a, f, e)
  bdd_manager bddm ;
  vbdd a ;
  char * (* f) (); 
  pointer e;
#endif
{
  bdd * t;
  for (t = vbdd_elements(a); * t; ++t)
    bdd_print_bdd(bddm, * t, f, bdd_terminal_id_fn_none, e, stdout) ;
}

void vbdd_print_sop
#if defined(__STDC__)
   (bdd_manager bddm, 
    vbdd a,
    char * (* f) (bdd_manager, bdd, pointer), 
    pointer e)
#else
  (bddm, a, f, e)
  bdd_manager bddm ;
  vbdd a ;
  char * (* f) (); 
  pointer e;
#endif
{
  bdd * t;
  for (t = vbdd_elements(a); * t; ++t)
    bdd_print_sop(bddm, * t, f, e) ;
}

