#if !defined(_VBDD_CODEH)
#  define _VBDD_CODEH

#  include "vbdd.h"

#  if !defined(ARGS)
#    if defined(__STDC__)
#      define ARGS(s) s
#    else
#      define ARGS(s)
#    endif __STDC__
#  endif ARGS

/* number of bits necessary to represent code "size" different values */
/* e.g. 5 -> 3 */
extern int vbdd_code_length 
ARGS((int size));

/* characteristic function of "size" consecutive codings with "code". */
/* e.g. <a, b, c>, 5 -> */
/*          not a or (not b and not c) [i.e. ~a~b~c+~a~bc+~ab~c+~abc+a~b~c] */
extern bdd vbdd_code_valid 
ARGS((bdd_manager bddm, vbdd code, int size));

/* vbdd of length "nb_variables" constants coding "ord". */
/* e.g. 3, 3 -> <0, 1, 1> */
extern vbdd vbdd_code_ordinal 
ARGS((bdd_manager bddm, int nb_variables, int ord));

/* ordinal value encoded by code with the vbdd "coding" */
/* e.g. ~abc, <a, b, c> -> 3 */
extern int vbdd_decode_ordinal 
ARGS((bdd_manager bddm, bdd code, vbdd coding));

#endif
