/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    vbdd_arith.h                                              */
/*                                                              */
/* Description:                                                 */
/*    Declarations of extra routines that manipulate vectors of */
/*    BDDs.      						*/
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#if !defined(_VBDD_ARITHH)
#   define _VBDD_ARITHH

#   include "vbdd.h"

#if defined(__STDC__)
#define ARGS(args) args
#else
#define ARGS(args) ()
#endif

/* ------------------------------------------------------------ */

/* Arithmetic operators */
extern vbdd vbdd_plus
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_plus_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_minus
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_minus_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_pluscarry
   ARGS((bdd_manager, vbdd, vbdd, bdd)) ;
extern vbdd vbdd_pluscarry_up
   ARGS((bdd_manager, vbdd, vbdd, bdd)) ;

#endif _VBDD_ARITHH
