/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    vbdd.h                                                    */
/*                                                              */
/* Description:                                                 */
/*    Declarations of extra routines that manipulate vectors of */
/*    BDDs.      						*/
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

#if !defined(_VBDDH)
#   define _VBDDH

#   include <bdduser.h>

#   if defined(__STDC__)
#      define ARGS(args) args
#   else
#      define ARGS(args) ()
#   endif

typedef struct vbdd_ * vbdd;

/* ------------------------------------------------------------ */
extern void vbdd_init ARGS((void));
extern vbdd vbdd_new ARGS((void));
extern vbdd vbdd_newn ARGS((int));
extern void vbdd_free ARGS((bdd_manager, vbdd));
extern int vbdd_length ARGS((vbdd));
extern bdd * vbdd_elements ARGS((vbdd));
extern bdd * vbdd_position ARGS((vbdd, bdd));
extern void vbdd_set ARGS((bdd_manager, vbdd, int, bdd));
extern bdd vbdd_nth ARGS((vbdd, int));
extern bdd vbdd_add ARGS((bdd_manager, vbdd, bdd));
extern vbdd vbdd_copy ARGS((bdd_manager, vbdd));
extern void vbdd_delete ARGS((bdd_manager, vbdd));
extern bdd vbdd_last ARGS((vbdd));
extern void vbdd_append ARGS((bdd_manager, vbdd, vbdd));
extern vbdd vbdd_interleave ARGS((bdd_manager, vbdd, vbdd));

extern void vbdd_apply
   ARGS((void (*) (bdd_manager, bdd), bdd_manager, vbdd)) ;
extern vbdd vbdd_apply1
   ARGS((bdd (*) (bdd_manager, bdd), bdd_manager, vbdd)) ;
extern vbdd vbdd_apply1_up
   ARGS((bdd (*) (bdd_manager, bdd), bdd_manager, vbdd)) ;
extern vbdd vbdd_apply2
   ARGS((bdd (*) (bdd_manager, bdd, bdd), bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_apply2_up
   ARGS((bdd (*) (bdd_manager, bdd, bdd), bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_distribute
   ARGS((bdd (*) (bdd_manager, bdd, bdd), bdd_manager, bdd, vbdd, int)) ;
extern vbdd vbdd_distribute_up
   ARGS((bdd (*) (bdd_manager, bdd, bdd), bdd_manager, bdd, vbdd, int)) ;
extern vbdd vbdd_distribute_up2
   ARGS((bdd (*) (bdd_manager, bdd, bdd), bdd_manager, bdd, vbdd, int)) ;
extern vbdd vbdd_protect ARGS((bdd_manager, vbdd)) ;
extern void vbdd_unprotect ARGS((bdd_manager, vbdd)) ;

#endif _VBDDH
