/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    bdd_misc.h                                                */
/*                                                              */
/* Description:                                                 */
/*    Declarations of extra routines that manipulate BDDs.      */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#if !defined(_BDD_MISCH)
#   define _BDD_MISCH

#   include <bdduser.h>

#   if !defined(ARGS)
#      if defined(__STDC__)
#         define ARGS(args) args
#      else
#         define ARGS(args) ()
#      endif
#   endif
extern void bdd_print_sop 
ARGS((bdd_manager, bdd, 
      char * (* f) ARGS((bdd_manager, bdd, pointer)), 
      pointer)) ;
extern void bdd_print_cube 
ARGS((bdd_manager, bdd, 
      char * (* f) ARGS((bdd_manager, bdd, pointer)), pointer)) ;
extern void bdd_print ARGS((bdd_manager, bdd)) ;
extern double bdd_satisfying_number ARGS((bdd_manager, bdd, unsigned)) ;

#endif _BDD_MISCH
