/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    bdd_misc.c                                                */
/*                                                              */
/* Description:                                                 */
/*    Extra routines that manipulate BDDs.                      */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#include "bdd_misc.h"
#include "bdd_up.h"

/* ------------------------------------------------------------ */
void bdd_print
#if defined(__STDC__)
   (bdd_manager M, bdd f)
#else
   (M, f)
   bdd_manager M ;
   bdd f;
#endif
{
  bdd_print_bdd(M, f, bdd_naming_fn_none, bdd_terminal_id_fn_none, 
                (pointer) NULL, stdout) ;
}

void
#if defined(__STDC__)
bdd_print_cube
(bdd_manager bddm, bdd cube, 
 char * (* naming_fn) (bdd_manager, bdd, pointer), 
 pointer e)
#else
bdd_print_cube
  (bddm, cube, naming_fn, e)
bdd_manager bddm;
bdd cube;
char * (* naming_fn)();
pointer e;
#endif
{
  bdd v;
  bdd next;
  bdd temp;

  cube=bdd_identity(bddm, cube);
  while (1)
    {
      v=bdd_if(bddm, cube);
      temp=bdd_and(bddm, v, cube);
      if (temp == bdd_zero(bddm))
	fputs("not ", stdout);
      if (naming_fn) {
	fputs(naming_fn(bddm, v, e), stdout);
      } else {
	char varstring[15];
	sprintf(varstring, "var.%li", bdd_if_id(bddm, v));
	fputs(varstring, stdout);
      }
      if (temp == bdd_zero(bddm))
	fputs("", stdout);
      else
	bdd_free(bddm, temp);
      next=bdd_then(bddm, cube);
      if (next == bdd_zero(bddm))
	next=bdd_else(bddm, cube);
      bdd_free(bddm, cube);
      cube=next;
      if (cube != bdd_one(bddm))
	fputs(" and ", stdout);
      else
	break;
    }
}

void
#if defined(__STDC__)
bdd_print_sop(bdd_manager bddm, bdd f, 
	      char * (* naming_fn) (bdd_manager, bdd, pointer), 
	      pointer e)
#else
print_sop(bddm, f, naming_fn, e)
     bdd_manager bddm;
     bdd f;
char * (* naming_fn)();
pointer e;
#endif
{
  bdd outside;
  bdd cube;
  bdd temp1, temp2;

  if (f == bdd_one(bddm))
    puts("1");
  else if (f == bdd_zero(bddm))
    puts("0");
  else
    {
      f=bdd_identity(bddm, f);
      outside=bdd_not(bddm, f);
      while (1)
	{
	  /* Pick a cube. */
	  cube=bdd_satisfy(bddm, f);
	  temp1=bdd_or(bddm, outside, cube);
	  temp2=cube;
	  /* Expand the cube, but don't include anything outside of f. */
	  cube=bdd_reduce(bddm, temp2, temp1);
	  bdd_free(bddm, temp1);
	  bdd_free(bddm, temp2);
	  bdd_print_cube(bddm, cube, naming_fn, e);
	  temp1=bdd_not(bddm, cube);
	  bdd_free(bddm, cube);
	  temp2=f;
	  /* Remove cube from f. */
	  f=bdd_and(bddm, temp1, temp2);
	  bdd_free(bddm, temp1);
	  bdd_free(bddm, temp2);
	  if (f != bdd_zero(bddm))
	    puts(" or");
	  else
	    {
	      putchar('\n');
	      break;
	    }
	}
      bdd_free(bddm, outside);
    }
}

/* ------------------------------------------------------------ */
double bdd_satisfying_number
#if defined(__STDC__)
(bdd_manager bddm, bdd f, unsigned nbvars)
#else
(bddm, f, nbvars)
bdd_manager bddm;
bdd f;
unsigned nbvars;
#endif
{
  double result;
  result = (double)
  bdd_satisfying_fraction(bddm, f);
  while (nbvars--) 
    result *= 2;
  return result;
}

/* ------------------------------------------------------------ */
